package org.xelevra.architecture.util;

import android.util.Log;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import static android.util.Log.DEBUG;
import static android.util.Log.ERROR;
import static android.util.Log.INFO;
import static android.util.Log.VERBOSE;

public class Easy {
    public static final String LOG_NAME = "Easy";

    private static int logLevel = VERBOSE;

    public static void setLogLevel(int logLevel){
        Easy.logLevel = logLevel;
    }

    private static Stack<Long> times = new Stack<Long>();

    public static void logD(Object... values) {
        if (logLevel <= DEBUG){
            for (String string : createLogStrings(values)) Log.d(LOG_NAME, string);
        }
    }

    public static void logE(Object... values) {
        if (logLevel <= ERROR) {
            Log.e(LOG_NAME, getLocation());
            for (String string : createLogStrings(values)) Log.e(LOG_NAME, string);
        }
    }

    public static void logI(Object... values) {
        if (logLevel <= INFO){
            for (String string : createLogStrings(values)) Log.i(LOG_NAME, string);
        }
    }

    public static void logE(Throwable throwable) {
        if (logLevel <= ERROR)
            Log.e(LOG_NAME, getLocation() + "\n" + Log.getStackTraceString(throwable));
    }


    private static String getLocation() {
        final String className = Easy.class.getName();
        final StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        boolean found = false;
        for (StackTraceElement trace : traces) {
            try {
                if (found) {
                    if (!trace.getClassName().startsWith(className)) {
                        Class.forName(trace.getClassName());
                        return "[" + trace + "]: ";
                    }
                } else if (trace.getClassName().startsWith(className)) {
                    found = true;
                }
            } catch (ClassNotFoundException e) {
                Log.e("Error " + LOG_NAME, "Error in the logger=" + e);
            }
        }
        return "[]: ";
    }

    private static List<String> createLogStrings(Object[] values) {
        LinkedList<String> result = new LinkedList<>();
        StringBuilder output = new StringBuilder();
        for (Object v : values) {
            output.append(v);
            output.append(" ");
        }
        String message = output.toString();
        byte[] bytes = message.getBytes();
        if(bytes.length <= 4076) {
            result.add(message);
        } else {
            double parts = Math.ceil(bytes.length / 4076d);
            int substringIndex = (int) ( message.length() / parts);
            for (int i = 0; i <= message.length(); i+=substringIndex){
                result.add(message.substring(i, Math.min(i + substringIndex, message.length())));
            }
        }
        return result;
    }

    public static void start() {
        times.push(System.currentTimeMillis());
    }

    public static void finish(String description) {
        long now = System.currentTimeMillis();
        logI(description + timeString(now - times.pop()));
    }

    public static String timeString(long milliseconds) {
        if (milliseconds < 1000) return milliseconds + "ms";
        int seconds = (int) (milliseconds / 1000);
        if (seconds < 60) return seconds + "s " + (milliseconds - seconds * 1000) + "ms";
        int minutes = seconds / 60;
        return minutes + "min " + (seconds - minutes * 60) + "s " + (milliseconds - seconds * 1000) + "ms";
    }
}
