package org.xelevra.architecture.util;

import android.content.Context;
import android.view.Gravity;
import android.widget.Toast;

public class Toaster {
    private Context context;

    public Toaster(Context app) {
        context = app;
    }

    public void toast(String message) {
        Toast toast = Toast.makeText(context, message, Toast.LENGTH_SHORT);
        toast.show();
    }

    public void toast(int messageResId) {
        toast(context.getString(messageResId));
    }

    public void toastLong(String message) {
        Toast toast = Toast.makeText(context, message, Toast.LENGTH_LONG);
        toast.setGravity(Gravity.TOP, 0, 200);
        toast.show();
    }
}
