package org.xelevra.architecture.base;

import android.view.View;

import org.xelevra.architecture.util.Easy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public abstract class ErrorHandler {

    public abstract void handleError(Throwable error, Object viewObject);

    /**
     * @param body error
     * @param viewObject View or content holder with fields
     * @return error message to show
     */
    protected abstract String parseServerError(Object body, Object viewObject);

    /**
     *
     * @param tag Web tag of form field which looking for
     * @param errorObject object which contains the form field.
     *                    It can be View object or content holder: it determines logic of finding fields
     * @return View which represents form field
     */
    static View findErrorField(String tag, Object errorObject){
        if(errorObject instanceof View){
            return ((View) errorObject).findViewWithTag(tag);
        } else {
            for (Field field : errorObject.getClass().getDeclaredFields()){
                if(View.class.isAssignableFrom(field.getType())){
                    try {
                        field.setAccessible(true);
                        View object = (View) field.get(errorObject);
                        field.setAccessible(false);
                        if(object != null && tag.equals(object.getTag())){
                            return object;
                        } else {
                            for (Annotation annotation : field.getAnnotations()){
                                if(annotation instanceof FormField){
                                    for (String annotatedTag :((FormField) annotation).value()){
                                        if(tag.equals(annotatedTag)){
                                            return object;
                                        }
                                    }
                                }
                            }
                        }
                    } catch (IllegalAccessException e) {
                        Easy.logE(e);
                    }
                }
            }
            return null;
        }
    }
}
