/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.common.Common;
import org.wysaid.nativePort.CGEFrameRenderer;
import org.wysaid.texUtils.TextureRenderer;

public class VideoPlayerGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    public static final String LOG_TAG = "libCGE_java";
    private SurfaceTexture mSurfaceTexture;
    private int mVideoTextureID;
    private CGEFrameRenderer mFrameRenderer;
    private TextureRenderer.Viewport mRenderViewport = new TextureRenderer.Viewport();
    private float[] mTransformMatrix = new float[16];
    private boolean mIsUsingMask = false;
    private float mMaskAspectRatio = 1.0f;
    private int mViewWidth = 1000;
    private int mViewHeight = 1000;
    private int mVideoWidth = 1000;
    private int mVideoHeight = 1000;
    private boolean mFitFullView = false;
    private MediaPlayer mPlayer;
    private Uri mVideoUri;
    PlayerInitializeCallback mPlayerInitCallback;
    PlayPreparedCallback mPreparedCallback;
    PlayCompletionCallback mPlayCompletionCallback;
    private OnCreateCallback mOnCreateCallback;
    private long mTimeCount2 = 0L;
    private long mFramesCount2 = 0L;
    private long mLastTimestamp2 = 0L;

    public boolean isUsingMask() {
        return this.mIsUsingMask;
    }

    public int getViewWidth() {
        return this.mViewWidth;
    }

    public int getViewheight() {
        return this.mViewHeight;
    }

    public void setFitFullView(boolean fit) {
        this.mFitFullView = fit;
        if (this.mFrameRenderer != null) {
            this.calcViewport();
        }
    }

    public void setPlayerInitializeCallback(PlayerInitializeCallback callback) {
        this.mPlayerInitCallback = callback;
    }

    public synchronized void setVideoUri(Uri uri, PlayPreparedCallback preparedCallback, PlayCompletionCallback completionCallback) {
        this.mVideoUri = uri;
        this.mPreparedCallback = preparedCallback;
        this.mPlayCompletionCallback = completionCallback;
        if (this.mFrameRenderer != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"setVideoUri...");
                    if (VideoPlayerGLSurfaceView.this.mSurfaceTexture == null || VideoPlayerGLSurfaceView.this.mVideoTextureID == 0) {
                        VideoPlayerGLSurfaceView.this.mVideoTextureID = Common.genSurfaceTextureID();
                        VideoPlayerGLSurfaceView.this.mSurfaceTexture = new SurfaceTexture(VideoPlayerGLSurfaceView.this.mVideoTextureID);
                        VideoPlayerGLSurfaceView.this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)VideoPlayerGLSurfaceView.this);
                    }
                    VideoPlayerGLSurfaceView.this._useUri();
                }
            });
        }
    }

    public synchronized void setFilterWithConfig(final String config) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayerGLSurfaceView.this.mFrameRenderer != null) {
                    VideoPlayerGLSurfaceView.this.mFrameRenderer.setFilterWidthConfig(config);
                } else {
                    Log.e((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"setFilterWithConfig after release!!");
                }
            }
        });
    }

    public void setFilterIntensity(final float intensity) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayerGLSurfaceView.this.mFrameRenderer != null) {
                    VideoPlayerGLSurfaceView.this.mFrameRenderer.setFilterIntensity(intensity);
                } else {
                    Log.e((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"setFilterIntensity after release!!");
                }
            }
        });
    }

    public void setMaskBitmap(Bitmap bmp, boolean shouldRecycle) {
        this.setMaskBitmap(bmp, shouldRecycle, null);
    }

    public void setMaskBitmap(final Bitmap bmp, final boolean shouldRecycle, final SetMaskBitmapCallback callback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayerGLSurfaceView.this.mFrameRenderer == null) {
                    Log.e((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"setMaskBitmap after release!!");
                    return;
                }
                if (bmp == null) {
                    VideoPlayerGLSurfaceView.this.mFrameRenderer.setMaskTexture(0, 1.0f);
                    VideoPlayerGLSurfaceView.this.mIsUsingMask = false;
                    VideoPlayerGLSurfaceView.this.calcViewport();
                    return;
                }
                int texID = Common.genNormalTextureID(bmp, 9728, 33071);
                VideoPlayerGLSurfaceView.this.mFrameRenderer.setMaskTexture(texID, (float)bmp.getWidth() / (float)bmp.getHeight());
                VideoPlayerGLSurfaceView.this.mIsUsingMask = true;
                VideoPlayerGLSurfaceView.this.mMaskAspectRatio = (float)bmp.getWidth() / (float)bmp.getHeight();
                if (callback != null) {
                    callback.setMaskOK(VideoPlayerGLSurfaceView.this.mFrameRenderer);
                }
                if (shouldRecycle) {
                    bmp.recycle();
                }
                VideoPlayerGLSurfaceView.this.calcViewport();
            }
        });
    }

    public synchronized MediaPlayer getPlayer() {
        if (this.mPlayer == null) {
            Log.e((String)LOG_TAG, (String)"Player is not initialized!");
        }
        return this.mPlayer;
    }

    public void setOnCreateCallback(final OnCreateCallback callback) {
        assert (callback != null) : "\u65e0\u610f\u4e49\u64cd\u4f5c!";
        if (this.mFrameRenderer == null) {
            this.mOnCreateCallback = callback;
        } else {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    callback.createOK();
                }
            });
        }
    }

    public VideoPlayerGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Log.i((String)LOG_TAG, (String)"MyGLSurfaceView Construct...");
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 8, 0);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setZOrderOnTop(true);
        Log.i((String)LOG_TAG, (String)"MyGLSurfaceView Construct OK...");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)LOG_TAG, (String)"video player onSurfaceCreated...");
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2960);
        if (this.mOnCreateCallback != null) {
            this.mOnCreateCallback.createOK();
        }
        if (this.mVideoUri != null && (this.mSurfaceTexture == null || this.mVideoTextureID == 0)) {
            this.mVideoTextureID = Common.genSurfaceTextureID();
            this.mSurfaceTexture = new SurfaceTexture(this.mVideoTextureID);
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this._useUri();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.calcViewport();
    }

    public void release() {
        Log.i((String)LOG_TAG, (String)"Video player view release...");
        if (this.mPlayer != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"Video player view release run...");
                    if (VideoPlayerGLSurfaceView.this.mPlayer != null) {
                        VideoPlayerGLSurfaceView.this.mPlayer.setSurface(null);
                        if (VideoPlayerGLSurfaceView.this.mPlayer.isPlaying()) {
                            VideoPlayerGLSurfaceView.this.mPlayer.stop();
                        }
                        VideoPlayerGLSurfaceView.this.mPlayer.release();
                        VideoPlayerGLSurfaceView.this.mPlayer = null;
                    }
                    if (VideoPlayerGLSurfaceView.this.mFrameRenderer != null) {
                        VideoPlayerGLSurfaceView.this.mFrameRenderer.release();
                        VideoPlayerGLSurfaceView.this.mFrameRenderer = null;
                    }
                    if (VideoPlayerGLSurfaceView.this.mSurfaceTexture != null) {
                        VideoPlayerGLSurfaceView.this.mSurfaceTexture.release();
                        VideoPlayerGLSurfaceView.this.mSurfaceTexture = null;
                    }
                    if (VideoPlayerGLSurfaceView.this.mVideoTextureID != 0) {
                        GLES20.glDeleteTextures((int)1, (int[])new int[]{VideoPlayerGLSurfaceView.this.mVideoTextureID}, (int)0);
                        VideoPlayerGLSurfaceView.this.mVideoTextureID = 0;
                    }
                    VideoPlayerGLSurfaceView.this.mIsUsingMask = false;
                    VideoPlayerGLSurfaceView.this.mPreparedCallback = null;
                    VideoPlayerGLSurfaceView.this.mPlayCompletionCallback = null;
                    Log.i((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"Video player view release OK");
                }
            });
        }
    }

    public void onPause() {
        Log.i((String)LOG_TAG, (String)"surfaceview onPause ...");
        super.onPause();
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mSurfaceTexture == null || this.mFrameRenderer == null) {
            return;
        }
        this.mSurfaceTexture.updateTexImage();
        if (!this.mPlayer.isPlaying()) {
            return;
        }
        this.mSurfaceTexture.getTransformMatrix(this.mTransformMatrix);
        this.mFrameRenderer.update(this.mVideoTextureID, this.mTransformMatrix);
        this.mFrameRenderer.runProc();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClear((int)16384);
        GLES20.glEnable((int)3042);
        this.mFrameRenderer.render(this.mRenderViewport.x, this.mRenderViewport.y, this.mRenderViewport.width, this.mRenderViewport.height);
        GLES20.glDisable((int)3042);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.requestRender();
        if (this.mLastTimestamp2 == 0L) {
            this.mLastTimestamp2 = System.currentTimeMillis();
        }
        long currentTimestamp = System.currentTimeMillis();
        ++this.mFramesCount2;
        this.mTimeCount2 += currentTimestamp - this.mLastTimestamp2;
        this.mLastTimestamp2 = currentTimestamp;
        if ((double)this.mTimeCount2 >= 1000.0) {
            Log.i((String)LOG_TAG, (String)String.format("\u64ad\u653e\u5e27\u7387: %d", this.mFramesCount2));
            this.mTimeCount2 = (long)((double)this.mTimeCount2 - 1000.0);
            this.mFramesCount2 = 0L;
        }
    }

    private void calcViewport() {
        int h;
        int w;
        float scaling = this.mIsUsingMask ? this.mMaskAspectRatio : (float)this.mVideoWidth / (float)this.mVideoHeight;
        float viewRatio = (float)this.mViewWidth / (float)this.mViewHeight;
        float s = scaling / viewRatio;
        if (this.mFitFullView) {
            if ((double)s > 1.0) {
                w = (int)((float)this.mViewHeight * scaling);
                h = this.mViewHeight;
            } else {
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
            }
        } else if ((double)s > 1.0) {
            w = this.mViewWidth;
            h = (int)((float)this.mViewWidth / scaling);
        } else {
            h = this.mViewHeight;
            w = (int)((float)this.mViewHeight * scaling);
        }
        this.mRenderViewport.width = w;
        this.mRenderViewport.height = h;
        this.mRenderViewport.x = (this.mViewWidth - this.mRenderViewport.width) / 2;
        this.mRenderViewport.y = (this.mViewHeight - this.mRenderViewport.height) / 2;
        Log.i((String)LOG_TAG, (String)String.format("View port: %d, %d, %d, %d", this.mRenderViewport.x, this.mRenderViewport.y, this.mRenderViewport.width, this.mRenderViewport.height));
    }

    private void _useUri() {
        block8: {
            if (this.mPlayer != null) {
                this.mPlayer.stop();
                this.mPlayer.reset();
            } else {
                this.mPlayer = new MediaPlayer();
            }
            try {
                this.mPlayer.setDataSource(this.getContext(), this.mVideoUri);
                this.mPlayer.setSurface(new Surface(this.mSurfaceTexture));
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)LOG_TAG, (String)"useUri failed");
                if (this.mPlayCompletionCallback != null) {
                    this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (VideoPlayerGLSurfaceView.this.mPlayCompletionCallback != null && !VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(VideoPlayerGLSurfaceView.this.mPlayer, 1, -1010)) {
                                VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(VideoPlayerGLSurfaceView.this.mPlayer);
                            }
                        }
                    });
                }
                return;
            }
            if (this.mPlayerInitCallback != null) {
                this.mPlayerInitCallback.initPlayer(this.mPlayer);
            }
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (VideoPlayerGLSurfaceView.this.mPlayCompletionCallback != null) {
                        VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(VideoPlayerGLSurfaceView.this.mPlayer);
                    }
                    Log.i((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"Video Play Over");
                }
            });
            this.mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    VideoPlayerGLSurfaceView.this.mVideoWidth = mp.getVideoWidth();
                    VideoPlayerGLSurfaceView.this.mVideoHeight = mp.getVideoHeight();
                    VideoPlayerGLSurfaceView.this.queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            if (VideoPlayerGLSurfaceView.this.mFrameRenderer == null) {
                                VideoPlayerGLSurfaceView.this.mFrameRenderer = new CGEFrameRenderer();
                            }
                            if (VideoPlayerGLSurfaceView.this.mFrameRenderer.init(VideoPlayerGLSurfaceView.this.mVideoWidth, VideoPlayerGLSurfaceView.this.mVideoHeight, VideoPlayerGLSurfaceView.this.mVideoWidth, VideoPlayerGLSurfaceView.this.mVideoHeight)) {
                                VideoPlayerGLSurfaceView.this.mFrameRenderer.setSrcFlipScale(1.0f, -1.0f);
                                VideoPlayerGLSurfaceView.this.mFrameRenderer.setRenderFlipScale(1.0f, -1.0f);
                            } else {
                                Log.e((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)"Frame Recorder init failed!");
                            }
                            VideoPlayerGLSurfaceView.this.calcViewport();
                        }
                    });
                    if (VideoPlayerGLSurfaceView.this.mPreparedCallback != null) {
                        VideoPlayerGLSurfaceView.this.mPreparedCallback.playPrepared(VideoPlayerGLSurfaceView.this.mPlayer);
                    } else {
                        mp.start();
                    }
                    Log.i((String)VideoPlayerGLSurfaceView.LOG_TAG, (String)String.format("Video resolution 1: %d x %d", VideoPlayerGLSurfaceView.this.mVideoWidth, VideoPlayerGLSurfaceView.this.mVideoHeight));
                }
            });
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    if (VideoPlayerGLSurfaceView.this.mPlayCompletionCallback != null) {
                        return VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(mp, what, extra);
                    }
                    return false;
                }
            });
            try {
                this.mPlayer.prepareAsync();
            }
            catch (Exception e) {
                Log.i((String)LOG_TAG, (String)String.format("Error handled: %s, play failure handler would be called!", e.toString()));
                if (this.mPlayCompletionCallback == null) break block8;
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (VideoPlayerGLSurfaceView.this.mPlayCompletionCallback != null && !VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(VideoPlayerGLSurfaceView.this.mPlayer, 1, -1010)) {
                            VideoPlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(VideoPlayerGLSurfaceView.this.mPlayer);
                        }
                    }
                });
            }
        }
    }

    public synchronized void takeShot(final TakeShotCallback callback) {
        assert (callback != null) : "callback must not be null!";
        if (this.mFrameRenderer == null) {
            Log.e((String)LOG_TAG, (String)"Drawer not initialized!");
            callback.takeShotOK(null);
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.allocate(((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.width * ((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height);
                GLES20.glReadPixels((int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.x, (int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.y, (int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.width, (int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height, (int)6408, (int)5121, (Buffer)buffer);
                Bitmap bmp = Bitmap.createBitmap((int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.width, (int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)buffer);
                Bitmap bmp2 = Bitmap.createBitmap((int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.width, (int)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bmp2);
                Matrix mat = new Matrix();
                mat.setTranslate(0.0f, (float)(-((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height) / 2.0f);
                mat.postScale(1.0f, -1.0f);
                mat.postTranslate(0.0f, (float)((VideoPlayerGLSurfaceView)VideoPlayerGLSurfaceView.this).mRenderViewport.height / 2.0f);
                canvas.drawBitmap(bmp, mat, null);
                bmp.recycle();
                callback.takeShotOK(bmp2);
            }
        });
    }

    public static interface TakeShotCallback {
        public void takeShotOK(Bitmap var1);
    }

    public static interface OnCreateCallback {
        public void createOK();
    }

    public static interface SetMaskBitmapCallback {
        public void setMaskOK(CGEFrameRenderer var1);
    }

    public static interface PlayCompletionCallback {
        public void playComplete(MediaPlayer var1);

        public boolean playFailed(MediaPlayer var1, int var2, int var3);
    }

    public static interface PlayPreparedCallback {
        public void playPrepared(MediaPlayer var1);
    }

    public static interface PlayerInitializeCallback {
        public void initPlayer(MediaPlayer var1);
    }
}

