/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.texUtils;

import android.opengl.GLES20;
import org.wysaid.texUtils.TextureRenderer;
import org.wysaid.texUtils.TextureRendererDrawOrigin;

public class TextureRendererWave
extends TextureRendererDrawOrigin {
    private static final String fshWave = "precision mediump float;\nvarying vec2 texCoord;\nuniform %s inputImageTexture;\nuniform float motion;\nconst float angle = 20.0;void main()\n{\n   vec2 coord;\n   coord.x = texCoord.x + 0.01 * sin(motion + texCoord.x * angle);\n   coord.y = texCoord.y + 0.01 * sin(motion + texCoord.y * angle);\n   gl_FragColor = texture2D(inputImageTexture, coord);\n}";
    private int mMotionLoc = 0;
    private boolean mAutoMotion = false;
    private float mMotion = 0.0f;
    private float mMotionSpeed = 0.0f;

    public static TextureRendererWave create(boolean isExternalOES) {
        TextureRendererWave renderer = new TextureRendererWave();
        if (!renderer.init(isExternalOES)) {
            renderer.release();
            return null;
        }
        return renderer;
    }

    @Override
    public boolean init(boolean isExternalOES) {
        if (this.setProgramDefault("attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat4 transform;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   vec2 coord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n   texCoord = (transform * vec4(coord, 0.0, 1.0)).xy;\n}", fshWave, isExternalOES)) {
            this.mProgram.bind();
            this.mMotionLoc = this.mProgram.getUniformLoc("motion");
            return true;
        }
        return false;
    }

    public void setWaveMotion(float motion) {
        this.mProgram.bind();
        GLES20.glUniform1f((int)this.mMotionLoc, (float)motion);
    }

    public void setAutoMotion(float speed) {
        this.mMotionSpeed = speed;
        this.mAutoMotion = speed != 0.0f;
    }

    @Override
    public void renderTexture(int texID, TextureRenderer.Viewport viewport) {
        if (viewport != null) {
            GLES20.glViewport((int)viewport.x, (int)viewport.y, (int)viewport.width, (int)viewport.height);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.TEXTURE_2D_BINDABLE, (int)texID);
        GLES20.glBindBuffer((int)34962, (int)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        this.mProgram.bind();
        if (this.mAutoMotion) {
            this.mMotion += this.mMotionSpeed;
            GLES20.glUniform1f((int)this.mMotionLoc, (float)this.mMotion);
            if ((double)this.mMotion > 62.83185307179586) {
                this.mMotion = (float)((double)this.mMotion - 62.83185307179586);
            }
        }
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }
}

