/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.texUtils;

import android.opengl.GLES20;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.wysaid.common.ProgramObject;

public abstract class TextureRenderer {
    public static final String LOG_TAG = "libCGE_java";
    protected static final String REQUIRE_STRING_EXTERNAL_OES = "#extension GL_OES_EGL_image_external : require\n";
    protected static final String SAMPLER2D_VAR_EXTERNAL_OES = "samplerExternalOES";
    protected static final String SAMPLER2D_VAR = "sampler2D";
    protected static final String vshDrawDefault = "attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat4 transform;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   vec2 coord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n   texCoord = (transform * vec4(coord, 0.0, 1.0)).xy;\n}";
    protected static final String POSITION_NAME = "vPosition";
    protected static final String ROTATION_NAME = "rotation";
    protected static final String FLIPSCALE_NAME = "flipScale";
    protected static final String TRANSFORM_NAME = "transform";
    public static final float[] vertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    public static final int DRAW_FUNCTION = 6;
    protected int TEXTURE_2D_BINDABLE;
    protected int mVertexBuffer;
    protected ProgramObject mProgram;
    protected int mTextureWidth;
    protected int mTextureHeight;
    protected int mRotationLoc;
    protected int mFlipScaleLoc;
    protected int mTransformLoc;

    public abstract boolean init(boolean var1);

    public void release() {
        if (this.mVertexBuffer != 0) {
            GLES20.glDeleteBuffers((int)1, (int[])new int[]{this.mVertexBuffer}, (int)0);
            this.mVertexBuffer = 0;
        }
        if (this.mProgram != null) {
            this.mProgram.release();
            this.mProgram = null;
        }
    }

    public abstract void renderTexture(int var1, Viewport var2);

    public abstract void setTextureSize(int var1, int var2);

    public abstract String getVertexShaderString();

    public abstract String getFragmentShaderString();

    public void setRotation(float rad) {
        float cosRad = (float)Math.cos(rad);
        float sinRad = (float)Math.sin(rad);
        float[] rot = new float[]{cosRad, sinRad, -sinRad, cosRad};
        assert (this.mProgram != null) : "setRotation must not be called before init!";
        this.mProgram.bind();
        GLES20.glUniformMatrix2fv((int)this.mRotationLoc, (int)1, (boolean)false, (float[])rot, (int)0);
    }

    public void setFlipscale(float x, float y) {
        this.mProgram.bind();
        GLES20.glUniform2f((int)this.mFlipScaleLoc, (float)x, (float)y);
    }

    public void setTransform(float[] matrix) {
        this.mProgram.bind();
        GLES20.glUniformMatrix4fv((int)this.mTransformLoc, (int)1, (boolean)false, (float[])matrix, (int)0);
    }

    protected boolean setProgramDefault(String vsh, String fsh, boolean isExternalOES) {
        this.TEXTURE_2D_BINDABLE = isExternalOES ? 36197 : 3553;
        this.mProgram = new ProgramObject();
        this.mProgram.bindAttribLocation(POSITION_NAME, 0);
        String fshResult = (isExternalOES ? REQUIRE_STRING_EXTERNAL_OES : "") + String.format(fsh, isExternalOES ? SAMPLER2D_VAR_EXTERNAL_OES : SAMPLER2D_VAR);
        if (this.mProgram.init(vsh, fshResult)) {
            this.mRotationLoc = this.mProgram.getUniformLoc(ROTATION_NAME);
            this.mFlipScaleLoc = this.mProgram.getUniformLoc(FLIPSCALE_NAME);
            this.mTransformLoc = this.mProgram.getUniformLoc(TRANSFORM_NAME);
            this.setRotation(0.0f);
            this.setFlipscale(1.0f, 1.0f);
            this.setTransform(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            return true;
        }
        return false;
    }

    protected void defaultInitialize() {
        int[] vertexBuffer = new int[1];
        GLES20.glGenBuffers((int)1, (int[])vertexBuffer, (int)0);
        this.mVertexBuffer = vertexBuffer[0];
        if (this.mVertexBuffer == 0) {
            Log.e((String)LOG_TAG, (String)"Invalid VertexBuffer!");
        }
        GLES20.glBindBuffer((int)34962, (int)this.mVertexBuffer);
        FloatBuffer buffer = FloatBuffer.allocate(vertices.length);
        buffer.put(vertices).position(0);
        GLES20.glBufferData((int)34962, (int)32, (Buffer)buffer, (int)35044);
    }

    public static class Viewport {
        public int x;
        public int y;
        public int width;
        public int height;

        public Viewport() {
        }

        public Viewport(int _x, int _y, int _width, int _height) {
            this.x = _x;
            this.y = _y;
            this.width = _width;
            this.height = _height;
        }
    }
}

