/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.wysaid.nativePort.NativeLibraryLoader;

public class CGEMultiInputFilterWrapper {
    private long mNativeAddress = 0L;
    IntBuffer mInputTextureBuffer;

    private CGEMultiInputFilterWrapper() {
    }

    public static CGEMultiInputFilterWrapper create(String vsh, String fsh) {
        CGEMultiInputFilterWrapper wrapper = new CGEMultiInputFilterWrapper();
        wrapper.mNativeAddress = CGEMultiInputFilterWrapper.nativeCreate(vsh, fsh);
        if (wrapper.mNativeAddress == 0L) {
            wrapper = null;
        }
        return wrapper;
    }

    public void release(boolean deleteFilter) {
        if (this.mNativeAddress != 0L) {
            if (deleteFilter) {
                CGEMultiInputFilterWrapper.nativeRelease(this.mNativeAddress);
            }
            this.mNativeAddress = 0L;
        }
    }

    public long getNativeAddress() {
        return this.mNativeAddress;
    }

    public void updateInputTextures(IntBuffer inputTextureBuffer, int count) {
        this.nativeUpdateInputTextures(this.mNativeAddress, inputTextureBuffer, count);
    }

    public void updateInputTextures(int[] inputTextures) {
        if (this.mInputTextureBuffer == null || this.mInputTextureBuffer.capacity() < inputTextures.length) {
            this.mInputTextureBuffer = ByteBuffer.allocateDirect(inputTextures.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        this.mInputTextureBuffer.put(inputTextures);
        this.mInputTextureBuffer.position(0);
        this.nativeUpdateInputTextures(this.mNativeAddress, this.mInputTextureBuffer, inputTextures.length);
    }

    protected static native long nativeCreate(String var0, String var1);

    protected static native void nativeRelease(long var0);

    protected native void nativeUpdateInputTextures(long var1, IntBuffer var3, int var4);

    static {
        NativeLibraryLoader.load();
    }
}

