/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import android.graphics.Bitmap;
import org.wysaid.nativePort.NativeLibraryLoader;

public class CGEImageHandler {
    protected long mNativeAddress = this.nativeCreateHandler();

    public boolean initWithBitmap(Bitmap bmp) {
        if (bmp == null) {
            return false;
        }
        if (bmp.getConfig() != Bitmap.Config.ARGB_8888) {
            bmp = bmp.copy(Bitmap.Config.ARGB_8888, false);
        }
        return this.nativeInitWithBitmap(this.mNativeAddress, bmp);
    }

    public boolean initWithSize(int width, int height) {
        return this.nativeInitWithSize(this.mNativeAddress, width, height);
    }

    public Bitmap getResultBitmap() {
        return this.nativeGetResultBitmap(this.mNativeAddress);
    }

    public void setDrawerRotation(float rad) {
        this.nativeSetDrawerRotation(this.mNativeAddress, rad);
    }

    public void setDrawerFlipScale(float x, float y) {
        this.nativeSetDrawerFlipScale(this.mNativeAddress, x, y);
    }

    public void setFilterWithConfig(String config) {
        this.nativeSetFilterWithConfig(this.mNativeAddress, config, true, true);
    }

    public void setFilterWithConfig(String config, boolean shouldClearOlder, boolean shouldProcess) {
        this.nativeSetFilterWithConfig(this.mNativeAddress, config, shouldClearOlder, shouldProcess);
    }

    public void setFilterIntensity(float intensity) {
        this.nativeSetFilterIntensity(this.mNativeAddress, intensity, true);
    }

    public void setFilterIntensity(float intensity, boolean shouldProcess) {
        this.nativeSetFilterIntensity(this.mNativeAddress, intensity, shouldProcess);
    }

    public boolean setFilterIntensityAtIndex(float intensity, int index, boolean shouldProcess) {
        return this.nativeSetFilterIntensityAtIndex(this.mNativeAddress, intensity, index, shouldProcess);
    }

    public void drawResult() {
        this.nativeDrawResult(this.mNativeAddress);
    }

    public void bindTargetFBO() {
        this.nativeBindTargetFBO(this.mNativeAddress);
    }

    public void setAsTarget() {
        this.nativeSetAsTarget(this.mNativeAddress);
    }

    public void swapBufferFBO() {
        this.nativeSwapBufferFBO(this.mNativeAddress);
    }

    public void revertImage() {
        this.nativeRevertImage(this.mNativeAddress);
    }

    public void processFilters() {
        this.nativeProcessingFilters(this.mNativeAddress);
    }

    public void processWithFilter(long filterAddress) {
        this.nativeProcessWithFilter(this.mNativeAddress, filterAddress);
    }

    public void release() {
        if (this.mNativeAddress != 0L) {
            this.nativeRelease(this.mNativeAddress);
            this.mNativeAddress = 0L;
        }
    }

    public void setFilterWithAddres(long filter) {
        this.nativeSetFilterWithAddress(this.mNativeAddress, filter);
    }

    protected native long nativeCreateHandler();

    protected native boolean nativeInitWithBitmap(long var1, Bitmap var3);

    protected native boolean nativeInitWithSize(long var1, int var3, int var4);

    protected native Bitmap nativeGetResultBitmap(long var1);

    protected native void nativeSetDrawerRotation(long var1, float var3);

    protected native void nativeSetDrawerFlipScale(long var1, float var3, float var4);

    protected native boolean nativeSetFilterWithConfig(long var1, String var3, boolean var4, boolean var5);

    protected native void nativeSetFilterWithAddress(long var1, long var3);

    protected native void nativeSetFilterIntensity(long var1, float var3, boolean var4);

    protected native boolean nativeSetFilterIntensityAtIndex(long var1, float var3, int var4, boolean var5);

    protected native void nativeDrawResult(long var1);

    protected native void nativeBindTargetFBO(long var1);

    protected native void nativeSetAsTarget(long var1);

    protected native void nativeSwapBufferFBO(long var1);

    protected native void nativeRevertImage(long var1);

    protected native void nativeProcessingFilters(long var1);

    protected native void nativeProcessWithFilter(long var1, long var3);

    protected native void nativeRelease(long var1);

    static {
        NativeLibraryLoader.load();
    }
}

