/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.gpuCodec;

import android.opengl.GLES20;
import android.util.Log;
import org.wysaid.gpuCodec.TextureDrawerCodec;

public class TextureDrawerNV21ToRGB
extends TextureDrawerCodec {
    private static final String fshNV21ToRGB = "precision mediump float;\nvarying vec2 texCoord;\nuniform sampler2D textureY;\nuniform sampler2D textureUV;\nuniform mat3 colorConversion;\nvoid main()\n{\n    vec3 yuv;\n    yuv.x = texture2D(textureY, texCoord).r;\n    yuv.yz = texture2D(textureUV, texCoord).ra - vec2(0.5, 0.5);\n    vec3 rgb = colorConversion * yuv;\n    gl_FragColor = vec4(rgb, 1.0);\n}";

    public static TextureDrawerNV21ToRGB create() {
        TextureDrawerNV21ToRGB drawer = new TextureDrawerNV21ToRGB();
        if (!drawer.init("attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   texCoord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n}", fshNV21ToRGB)) {
            Log.e((String)"libCGE_java", (String)"TextureDrawerNV21ToRGB create failed!");
            drawer.release();
            drawer = null;
        }
        return drawer;
    }

    @Override
    protected boolean init(String vsh, String fsh) {
        if (super.init(vsh, fsh)) {
            this.mProgram.bind();
            this.mProgram.sendUniformi("textureUV", 1);
            this.mProgram.sendUniformMat3("colorConversion", 1, false, MATRIX_YUV2RGB);
            return true;
        }
        return false;
    }

    public void drawTextures() {
        this.mProgram.bind();
        GLES20.glBindBuffer((int)34962, (int)this.mVertBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    public void drawTextures(int texY, int texUV) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)texY);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)texUV);
        this.drawTextures();
    }
}

