/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.common;

import android.opengl.GLES20;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.wysaid.common.ProgramObject;

public class TextureDrawer {
    protected static final String vshDrawer = "attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   texCoord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n}";
    protected static final String fshDrawer = "precision mediump float;\nvarying vec2 texCoord;\nuniform sampler2D inputImageTexture;\nvoid main()\n{\n   gl_FragColor = texture2D(inputImageTexture, texCoord);\n}";
    public static final float[] vertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    public static final int DRAW_FUNCTION = 6;
    protected ProgramObject mProgram;
    protected int mVertBuffer;
    protected int mRotLoc;
    protected int mFlipScaleLoc;

    public ProgramObject getProgram() {
        return this.mProgram;
    }

    protected TextureDrawer() {
    }

    protected boolean init(String vsh, String fsh) {
        this.mProgram = new ProgramObject();
        this.mProgram.bindAttribLocation("vPosition", 0);
        if (!this.mProgram.init(vsh, fsh)) {
            this.mProgram.release();
            this.mProgram = null;
            return false;
        }
        this.mProgram.bind();
        this.mRotLoc = this.mProgram.getUniformLoc("rotation");
        this.mFlipScaleLoc = this.mProgram.getUniformLoc("flipScale");
        int[] vertBuffer = new int[1];
        GLES20.glGenBuffers((int)1, (int[])vertBuffer, (int)0);
        this.mVertBuffer = vertBuffer[0];
        GLES20.glBindBuffer((int)34962, (int)this.mVertBuffer);
        FloatBuffer buffer = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buffer.put(vertices).position(0);
        GLES20.glBufferData((int)34962, (int)32, (Buffer)buffer, (int)35044);
        this.setRotation(0.0f);
        this.setFlipScale(1.0f, 1.0f);
        return true;
    }

    public static TextureDrawer create() {
        TextureDrawer drawer = new TextureDrawer();
        if (!drawer.init(vshDrawer, fshDrawer)) {
            Log.e((String)"libCGE_java", (String)"TextureDrawer create failed!");
            drawer.release();
            drawer = null;
        }
        return drawer;
    }

    public void release() {
        if (this.mProgram != null) {
            this.mProgram.release();
            this.mProgram = null;
        }
        GLES20.glDeleteBuffers((int)1, (int[])new int[]{this.mVertBuffer}, (int)0);
        this.mVertBuffer = 0;
    }

    public void drawTexture(int texID) {
        this.drawTexture(texID, 3553);
    }

    public void drawTexture(int texID, int type) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)type, (int)texID);
        GLES20.glBindBuffer((int)34962, (int)this.mVertBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        this.mProgram.bind();
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    public void bindVertexBuffer() {
        GLES20.glBindBuffer((int)34962, (int)this.mVertBuffer);
    }

    public void setRotation(float rad) {
        this._rotate(this.mRotLoc, rad);
    }

    public void setFlipScale(float x, float y) {
        this.mProgram.bind();
        GLES20.glUniform2f((int)this.mFlipScaleLoc, (float)x, (float)y);
    }

    private void _rotate(int location, float rad) {
        float cosRad = (float)Math.cos(rad);
        float sinRad = (float)Math.sin(rad);
        float[] rotation = new float[]{cosRad, sinRad, -sinRad, cosRad};
        this.mProgram.bind();
        GLES20.glUniformMatrix2fv((int)location, (int)1, (boolean)false, (float[])rotation, (int)0);
    }
}

