/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.common.Common;
import org.wysaid.texUtils.TextureRenderer;
import org.wysaid.texUtils.TextureRendererDrawOrigin;
import org.wysaid.texUtils.TextureRendererMask;

public class SimplePlayerGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    public static final String LOG_TAG = "libCGE_java";
    private SurfaceTexture mSurfaceTexture;
    private int mVideoTextureID;
    private TextureRenderer mDrawer;
    private TextureRenderer.Viewport mRenderViewport = new TextureRenderer.Viewport();
    private float[] mTransformMatrix = new float[16];
    private boolean mIsUsingMask = false;
    private float mMaskAspectRatio = 1.0f;
    private float mDrawerFlipScaleX = 1.0f;
    private float mDrawerFlipScaleY = 1.0f;
    private int mViewWidth = 1000;
    private int mViewHeight = 1000;
    private int mVideoWidth = 1000;
    private int mVideoHeight = 1000;
    private boolean mFitFullView = false;
    private MediaPlayer mPlayer;
    private Uri mVideoUri;
    PlayerInitializeCallback mPlayerInitCallback;
    PlayPreparedCallback mPreparedCallback;
    PlayCompletionCallback mPlayCompletionCallback;
    private OnCreateCallback mOnCreateCallback;
    private long mTimeCount2 = 0L;
    private long mFramesCount2 = 0L;
    private long mLastTimestamp2 = 0L;

    public void setTextureRenderer(TextureRenderer drawer) {
        if (this.mDrawer == null) {
            Log.e((String)LOG_TAG, (String)"Invalid Drawer!");
            return;
        }
        if (this.mDrawer != drawer) {
            this.mDrawer.release();
            this.mDrawer = drawer;
            this.calcViewport();
        }
    }

    public boolean isUsingMask() {
        return this.mIsUsingMask;
    }

    public int getViewWidth() {
        return this.mViewWidth;
    }

    public int getViewheight() {
        return this.mViewHeight;
    }

    public void setFitFullView(boolean fit) {
        this.mFitFullView = fit;
        if (this.mDrawer != null) {
            this.calcViewport();
        }
    }

    public void setPlayerInitializeCallback(PlayerInitializeCallback callback) {
        this.mPlayerInitCallback = callback;
    }

    public synchronized void setVideoUri(Uri uri, PlayPreparedCallback preparedCallback, PlayCompletionCallback completionCallback) {
        this.mVideoUri = uri;
        this.mPreparedCallback = preparedCallback;
        this.mPlayCompletionCallback = completionCallback;
        if (this.mDrawer != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"setVideoUri...");
                    if (SimplePlayerGLSurfaceView.this.mSurfaceTexture == null || SimplePlayerGLSurfaceView.this.mVideoTextureID == 0) {
                        SimplePlayerGLSurfaceView.this.mVideoTextureID = Common.genSurfaceTextureID();
                        SimplePlayerGLSurfaceView.this.mSurfaceTexture = new SurfaceTexture(SimplePlayerGLSurfaceView.this.mVideoTextureID);
                        SimplePlayerGLSurfaceView.this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)SimplePlayerGLSurfaceView.this);
                    }
                    SimplePlayerGLSurfaceView.this._useUri();
                }
            });
        }
    }

    public void setMaskBitmap(Bitmap bmp, boolean shouldRecycle) {
        this.setMaskBitmap(bmp, shouldRecycle, null);
    }

    public synchronized void setMaskBitmap(final Bitmap bmp, final boolean shouldRecycle, final SetMaskBitmapCallback callback) {
        if (this.mDrawer == null) {
            Log.e((String)LOG_TAG, (String)"setMaskBitmap after release!");
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (bmp == null) {
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"Cancel Mask Bitmap!");
                    SimplePlayerGLSurfaceView.this.setMaskTexture(0, 1.0f);
                    if (callback != null) {
                        callback.unsetMaskOK(SimplePlayerGLSurfaceView.this.mDrawer);
                    }
                    return;
                }
                Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"Use Mask Bitmap!");
                int[] texID = new int[]{0};
                GLES20.glGenTextures((int)1, (int[])texID, (int)0);
                GLES20.glBindTexture((int)3553, (int)texID[0]);
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bmp, (int)0);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
                SimplePlayerGLSurfaceView.this.setMaskTexture(texID[0], (float)bmp.getWidth() / (float)bmp.getHeight());
                if (callback != null && SimplePlayerGLSurfaceView.this.mDrawer instanceof TextureRendererMask) {
                    callback.setMaskOK((TextureRendererMask)SimplePlayerGLSurfaceView.this.mDrawer);
                }
                if (shouldRecycle) {
                    bmp.recycle();
                }
            }
        });
    }

    public synchronized void setMaskTexture(int texID, float aspectRatio) {
        Log.i((String)LOG_TAG, (String)"setMaskTexture... ");
        if (texID == 0) {
            if (this.mDrawer instanceof TextureRendererMask) {
                this.mDrawer.release();
                this.mDrawer = TextureRendererDrawOrigin.create(true);
            }
            this.mIsUsingMask = false;
        } else {
            if (!(this.mDrawer instanceof TextureRendererMask)) {
                this.mDrawer.release();
                TextureRendererMask drawer = TextureRendererMask.create(true);
                assert (drawer != null) : "Drawer Create Failed!";
                drawer.setMaskTexture(texID);
                this.mDrawer = drawer;
            }
            this.mIsUsingMask = true;
        }
        this.mMaskAspectRatio = aspectRatio;
        this.calcViewport();
    }

    public synchronized MediaPlayer getPlayer() {
        if (this.mPlayer == null) {
            Log.e((String)LOG_TAG, (String)"Player is not initialized!");
        }
        return this.mPlayer;
    }

    public void setOnCreateCallback(final OnCreateCallback callback) {
        assert (callback != null) : "\u65e0\u610f\u4e49\u64cd\u4f5c!";
        if (this.mDrawer == null) {
            this.mOnCreateCallback = callback;
        } else {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    callback.createOK();
                }
            });
        }
    }

    public SimplePlayerGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Log.i((String)LOG_TAG, (String)"MyGLSurfaceView Construct...");
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 8, 0);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setZOrderOnTop(true);
        Log.i((String)LOG_TAG, (String)"MyGLSurfaceView Construct OK...");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)LOG_TAG, (String)"video player onSurfaceCreated...");
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2960);
        this.mDrawer = TextureRendererDrawOrigin.create(true);
        if (this.mDrawer == null) {
            Log.e((String)LOG_TAG, (String)"Create Drawer Failed!");
            return;
        }
        if (this.mOnCreateCallback != null) {
            this.mOnCreateCallback.createOK();
        }
        if (this.mVideoUri != null && (this.mSurfaceTexture == null || this.mVideoTextureID == 0)) {
            this.mVideoTextureID = Common.genSurfaceTextureID();
            this.mSurfaceTexture = new SurfaceTexture(this.mVideoTextureID);
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this._useUri();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.calcViewport();
    }

    public void release() {
        Log.i((String)LOG_TAG, (String)"Video player view release...");
        if (this.mPlayer != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"Video player view release run...");
                    if (SimplePlayerGLSurfaceView.this.mPlayer != null) {
                        SimplePlayerGLSurfaceView.this.mPlayer.setSurface(null);
                        if (SimplePlayerGLSurfaceView.this.mPlayer.isPlaying()) {
                            SimplePlayerGLSurfaceView.this.mPlayer.stop();
                        }
                        SimplePlayerGLSurfaceView.this.mPlayer.release();
                        SimplePlayerGLSurfaceView.this.mPlayer = null;
                    }
                    if (SimplePlayerGLSurfaceView.this.mDrawer != null) {
                        SimplePlayerGLSurfaceView.this.mDrawer.release();
                        SimplePlayerGLSurfaceView.this.mDrawer = null;
                    }
                    if (SimplePlayerGLSurfaceView.this.mSurfaceTexture != null) {
                        SimplePlayerGLSurfaceView.this.mSurfaceTexture.release();
                        SimplePlayerGLSurfaceView.this.mSurfaceTexture = null;
                    }
                    if (SimplePlayerGLSurfaceView.this.mVideoTextureID != 0) {
                        GLES20.glDeleteTextures((int)1, (int[])new int[]{SimplePlayerGLSurfaceView.this.mVideoTextureID}, (int)0);
                        SimplePlayerGLSurfaceView.this.mVideoTextureID = 0;
                    }
                    SimplePlayerGLSurfaceView.this.mIsUsingMask = false;
                    SimplePlayerGLSurfaceView.this.mPreparedCallback = null;
                    SimplePlayerGLSurfaceView.this.mPlayCompletionCallback = null;
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"Video player view release OK");
                }
            });
        }
    }

    public void onPause() {
        Log.i((String)LOG_TAG, (String)"surfaceview onPause ...");
        super.onPause();
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mSurfaceTexture == null) {
            return;
        }
        this.mSurfaceTexture.updateTexImage();
        if (!this.mPlayer.isPlaying()) {
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClear((int)16384);
        GLES20.glViewport((int)0, (int)0, (int)this.mViewWidth, (int)this.mViewHeight);
        this.mSurfaceTexture.getTransformMatrix(this.mTransformMatrix);
        this.mDrawer.setTransform(this.mTransformMatrix);
        this.mDrawer.renderTexture(this.mVideoTextureID, this.mRenderViewport);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.requestRender();
        if (this.mLastTimestamp2 == 0L) {
            this.mLastTimestamp2 = System.currentTimeMillis();
        }
        long currentTimestamp = System.currentTimeMillis();
        ++this.mFramesCount2;
        this.mTimeCount2 += currentTimestamp - this.mLastTimestamp2;
        this.mLastTimestamp2 = currentTimestamp;
        if ((double)this.mTimeCount2 >= 1000.0) {
            Log.i((String)LOG_TAG, (String)String.format("\u64ad\u653e\u5e27\u7387: %d", this.mFramesCount2));
            this.mTimeCount2 = (long)((double)this.mTimeCount2 - 1000.0);
            this.mFramesCount2 = 0L;
        }
    }

    private void calcViewport() {
        int h;
        int w;
        float scaling;
        if (this.mIsUsingMask) {
            this.flushMaskAspectRatio();
            scaling = this.mMaskAspectRatio;
        } else {
            this.mDrawer.setFlipscale(this.mDrawerFlipScaleX, this.mDrawerFlipScaleY);
            scaling = (float)this.mVideoWidth / (float)this.mVideoHeight;
        }
        float viewRatio = (float)this.mViewWidth / (float)this.mViewHeight;
        float s = scaling / viewRatio;
        if (this.mFitFullView) {
            if ((double)s > 1.0) {
                w = (int)((float)this.mViewHeight * scaling);
                h = this.mViewHeight;
            } else {
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
            }
        } else if ((double)s > 1.0) {
            w = this.mViewWidth;
            h = (int)((float)this.mViewWidth / scaling);
        } else {
            h = this.mViewHeight;
            w = (int)((float)this.mViewHeight * scaling);
        }
        this.mRenderViewport.width = w;
        this.mRenderViewport.height = h;
        this.mRenderViewport.x = (this.mViewWidth - this.mRenderViewport.width) / 2;
        this.mRenderViewport.y = (this.mViewHeight - this.mRenderViewport.height) / 2;
        Log.i((String)LOG_TAG, (String)String.format("View port: %d, %d, %d, %d", this.mRenderViewport.x, this.mRenderViewport.y, this.mRenderViewport.width, this.mRenderViewport.height));
    }

    private void _useUri() {
        block8: {
            if (this.mPlayer != null) {
                this.mPlayer.stop();
                this.mPlayer.reset();
            } else {
                this.mPlayer = new MediaPlayer();
            }
            try {
                this.mPlayer.setDataSource(this.getContext(), this.mVideoUri);
                this.mPlayer.setSurface(new Surface(this.mSurfaceTexture));
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)LOG_TAG, (String)"useUri failed");
                if (this.mPlayCompletionCallback != null) {
                    this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (SimplePlayerGLSurfaceView.this.mPlayCompletionCallback != null && !SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(SimplePlayerGLSurfaceView.this.mPlayer, 1, -1010)) {
                                SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(SimplePlayerGLSurfaceView.this.mPlayer);
                            }
                        }
                    });
                }
                return;
            }
            if (this.mPlayerInitCallback != null) {
                this.mPlayerInitCallback.initPlayer(this.mPlayer);
            }
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (SimplePlayerGLSurfaceView.this.mPlayCompletionCallback != null) {
                        SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(SimplePlayerGLSurfaceView.this.mPlayer);
                    }
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)"Video Play Over");
                }
            });
            this.mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    SimplePlayerGLSurfaceView.this.mVideoWidth = mp.getVideoWidth();
                    SimplePlayerGLSurfaceView.this.mVideoHeight = mp.getVideoHeight();
                    SimplePlayerGLSurfaceView.this.queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            SimplePlayerGLSurfaceView.this.calcViewport();
                        }
                    });
                    if (SimplePlayerGLSurfaceView.this.mPreparedCallback != null) {
                        SimplePlayerGLSurfaceView.this.mPreparedCallback.playPrepared(SimplePlayerGLSurfaceView.this.mPlayer);
                    } else {
                        mp.start();
                    }
                    Log.i((String)SimplePlayerGLSurfaceView.LOG_TAG, (String)String.format("Video resolution 1: %d x %d", SimplePlayerGLSurfaceView.this.mVideoWidth, SimplePlayerGLSurfaceView.this.mVideoHeight));
                }
            });
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    if (SimplePlayerGLSurfaceView.this.mPlayCompletionCallback != null) {
                        return SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(mp, what, extra);
                    }
                    return false;
                }
            });
            try {
                this.mPlayer.prepareAsync();
            }
            catch (Exception e) {
                Log.i((String)LOG_TAG, (String)String.format("Error handled: %s, play failure handler would be called!", e.toString()));
                if (this.mPlayCompletionCallback == null) break block8;
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (SimplePlayerGLSurfaceView.this.mPlayCompletionCallback != null && !SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playFailed(SimplePlayerGLSurfaceView.this.mPlayer, 1, -1010)) {
                            SimplePlayerGLSurfaceView.this.mPlayCompletionCallback.playComplete(SimplePlayerGLSurfaceView.this.mPlayer);
                        }
                    }
                });
            }
        }
    }

    private void flushMaskAspectRatio() {
        float dstRatio = (float)this.mVideoWidth / (float)this.mVideoHeight;
        float s = dstRatio / this.mMaskAspectRatio;
        if (s > 1.0f) {
            this.mDrawer.setFlipscale(this.mDrawerFlipScaleX / s, this.mDrawerFlipScaleY);
        } else {
            this.mDrawer.setFlipscale(this.mDrawerFlipScaleX, s * this.mDrawerFlipScaleY);
        }
    }

    public synchronized void takeShot(final TakeShotCallback callback) {
        assert (callback != null) : "callback must not be null!";
        if (this.mDrawer == null) {
            Log.e((String)LOG_TAG, (String)"Drawer not initialized!");
            callback.takeShotOK(null);
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.allocate(((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.width * ((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height);
                GLES20.glReadPixels((int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.x, (int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.y, (int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.width, (int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height, (int)6408, (int)5121, (Buffer)buffer);
                Bitmap bmp = Bitmap.createBitmap((int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.width, (int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)buffer);
                Bitmap bmp2 = Bitmap.createBitmap((int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.width, (int)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bmp2);
                Matrix mat = new Matrix();
                mat.setTranslate(0.0f, (float)(-((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height) / 2.0f);
                mat.postScale(1.0f, -1.0f);
                mat.postTranslate(0.0f, (float)((SimplePlayerGLSurfaceView)SimplePlayerGLSurfaceView.this).mRenderViewport.height / 2.0f);
                canvas.drawBitmap(bmp, mat, null);
                bmp.recycle();
                callback.takeShotOK(bmp2);
            }
        });
    }

    public static interface TakeShotCallback {
        public void takeShotOK(Bitmap var1);
    }

    public static interface OnCreateCallback {
        public void createOK();
    }

    public static interface SetMaskBitmapCallback {
        public void setMaskOK(TextureRendererMask var1);

        public void unsetMaskOK(TextureRenderer var1);
    }

    public static interface PlayCompletionCallback {
        public void playComplete(MediaPlayer var1);

        public boolean playFailed(MediaPlayer var1, int var2, int var3);
    }

    public static interface PlayPreparedCallback {
        public void playPrepared(MediaPlayer var1);
    }

    public static interface PlayerInitializeCallback {
        public void initPlayer(MediaPlayer var1);
    }
}

