/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.util.AttributeSet;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.camera.CameraInstance;
import org.wysaid.common.Common;
import org.wysaid.gpuCodec.TextureDrawerNV12ToRGB;
import org.wysaid.view.CameraGLSurfaceView;

public class CameraGLSurfaceViewWithBuffer
extends CameraGLSurfaceView
implements Camera.PreviewCallback {
    protected byte[] mPreviewBuffer0;
    protected byte[] mPreviewBuffer1;
    protected TextureDrawerNV12ToRGB mYUVDrawer;
    protected int mTextureY;
    protected int mTextureUV;
    protected int mTextureWidth;
    protected int mTextureHeight;
    protected ByteBuffer mBufferY;
    protected ByteBuffer mBufferUV;
    protected int mYSize;
    protected int mUVSize;
    protected int mBufferSize;
    protected SurfaceTexture mSurfaceTexture;
    protected boolean mBufferUpdated = false;
    protected final int[] mBufferUpdateLock = new int[0];

    public CameraGLSurfaceViewWithBuffer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setRenderMode(1);
    }

    @Override
    protected void onRelease() {
        super.onRelease();
        if (this.mYUVDrawer != null) {
            this.mYUVDrawer.release();
            this.mYUVDrawer = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mTextureY != 0 || this.mTextureUV != 0) {
            GLES20.glDeleteTextures((int)2, (int[])new int[]{this.mTextureY, this.mTextureUV}, (int)0);
            this.mTextureUV = 0;
            this.mTextureY = 0;
            this.mTextureWidth = 0;
            this.mTextureHeight = 0;
        }
    }

    protected void resizeTextures() {
        if (this.mTextureY == 0 || this.mTextureUV == 0) {
            int[] textures = new int[2];
            GLES20.glGenTextures((int)2, (int[])textures, (int)0);
            this.mTextureY = textures[0];
            this.mTextureUV = textures[1];
            GLES20.glBindTexture((int)3553, (int)this.mTextureY);
            Common.texParamHelper(3553, 9729, 33071);
            GLES20.glBindTexture((int)3553, (int)this.mTextureUV);
            Common.texParamHelper(3553, 9729, 33071);
        }
        int width = this.cameraInstance().previewWidth();
        int height = this.cameraInstance().previewHeight();
        if (this.mTextureWidth != width || this.mTextureHeight != height) {
            this.mTextureWidth = width;
            this.mTextureHeight = height;
            GLES20.glBindTexture((int)3553, (int)this.mTextureY);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this.mTextureWidth, (int)this.mTextureHeight, (int)0, (int)6409, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)this.mTextureUV);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6410, (int)(this.mTextureWidth / 2), (int)(this.mTextureHeight / 2), (int)0, (int)6410, (int)5121, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTextures() {
        if (this.mBufferUpdated) {
            int[] nArray = this.mBufferUpdateLock;
            synchronized (this.mBufferUpdateLock) {
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)this.mTextureY);
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mTextureWidth, (int)this.mTextureHeight, (int)6409, (int)5121, (Buffer)this.mBufferY.position(0));
                GLES20.glActiveTexture((int)33985);
                GLES20.glBindTexture((int)3553, (int)this.mTextureUV);
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)(this.mTextureWidth / 2), (int)(this.mTextureHeight / 2), (int)6410, (int)5121, (Buffer)this.mBufferUV.position(0));
                this.mBufferUpdated = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mTextureY);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)this.mTextureUV);
        }
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        super.onSurfaceCreated(gl, config);
        this.mYUVDrawer = TextureDrawerNV12ToRGB.create();
        this.mYUVDrawer.setFlipScale(1.0f, 1.0f);
        this.mYUVDrawer.setRotation(1.5707964f);
        this.mSurfaceTexture = new SurfaceTexture(0);
    }

    @Override
    public void resumePreview() {
        if (this.mYUVDrawer == null) {
            return;
        }
        if (!this.cameraInstance().isCameraOpened()) {
            int facing = this.mIsCameraBackForward ? 0 : 1;
            this.cameraInstance().tryOpenCamera(new CameraInstance.CameraOpenCallback(){

                @Override
                public void cameraReady() {
                    Log.i((String)"libCGE_java", (String)"tryOpenCamera OK...");
                }
            }, facing);
        }
        if (!this.cameraInstance().isPreviewing()) {
            Camera camera = this.cameraInstance().getCameraDevice();
            Camera.Parameters parameters = camera.getParameters();
            parameters.getPreviewFormat();
            Camera.Size sz = parameters.getPreviewSize();
            int format = parameters.getPreviewFormat();
            if (format != 17) {
                try {
                    parameters.setPreviewFormat(17);
                    camera.setParameters(parameters);
                    format = 17;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            this.mYSize = sz.width * sz.height;
            int newBufferSize = this.mYSize * ImageFormat.getBitsPerPixel((int)format) / 8;
            if (this.mBufferSize != newBufferSize) {
                this.mBufferSize = newBufferSize;
                this.mUVSize = this.mBufferSize - this.mYSize;
                this.mBufferY = ByteBuffer.allocateDirect(this.mYSize).order(ByteOrder.nativeOrder());
                this.mBufferUV = ByteBuffer.allocateDirect(this.mUVSize).order(ByteOrder.nativeOrder());
                this.mPreviewBuffer0 = new byte[this.mBufferSize];
                this.mPreviewBuffer1 = new byte[this.mBufferSize];
            }
            camera.addCallbackBuffer(this.mPreviewBuffer0);
            camera.addCallbackBuffer(this.mPreviewBuffer1);
            this.cameraInstance().startPreview(this.mSurfaceTexture, this);
        }
        if (this.mIsCameraBackForward) {
            this.mYUVDrawer.setFlipScale(-1.0f, 1.0f);
            this.mYUVDrawer.setRotation(1.5707964f);
        } else {
            this.mYUVDrawer.setFlipScale(1.0f, 1.0f);
            this.mYUVDrawer.setRotation(1.5707964f);
        }
        this.resizeTextures();
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
        if (!this.cameraInstance().isPreviewing()) {
            this.resumePreview();
        }
    }

    public void drawCurrentFrame() {
        if (this.mYUVDrawer == null) {
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glViewport((int)this.mDrawViewport.x, (int)this.mDrawViewport.y, (int)this.mDrawViewport.width, (int)this.mDrawViewport.height);
        this.updateTextures();
        this.mYUVDrawer.drawTextures();
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        this.drawCurrentFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        int[] nArray = this.mBufferUpdateLock;
        synchronized (this.mBufferUpdateLock) {
            this.mBufferY.position(0);
            this.mBufferUV.position(0);
            this.mBufferY.put(data, 0, this.mYSize);
            this.mBufferUV.put(data, this.mYSize, this.mUVSize);
            this.mBufferUpdated = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            camera.addCallbackBuffer(data);
            return;
        }
    }
}

