/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.gpuCodec;

import android.opengl.GLES20;
import android.util.Log;
import org.wysaid.gpuCodec.TextureDrawerCodec;

public class TextureDrawerI420ToRGB
extends TextureDrawerCodec {
    protected static final String fshI420ToRGB = "precision mediump float;\nvarying vec2 texCoord;\nuniform sampler2D textureY;\nuniform sampler2D textureU;\nuniform sampler2D textureV;\nuniform mat3 colorConversion;\nvoid main()\n{\n    vec3 yuv;\n    yuv.x = texture2D(textureY, texCoord).r;\n    yuv.y = texture2D(textureU, texCoord).r - 0.5;\n    yuv.z = texture2D(textureV, texCoord).r - 0.5;\n    vec3 rgb = colorConversion * yuv;\n    gl_FragColor = vec4(rgb, 1.0);\n}";

    public static TextureDrawerI420ToRGB create() {
        TextureDrawerI420ToRGB drawer = new TextureDrawerI420ToRGB();
        if (!drawer.init("attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   texCoord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n}", fshI420ToRGB)) {
            Log.e((String)"libCGE_java", (String)"TextureDrawerI420ToRGB create failed!");
            drawer.release();
            drawer = null;
        }
        return drawer;
    }

    @Override
    protected boolean init(String vsh, String fsh) {
        if (super.init(vsh, fsh)) {
            this.mProgram.bind();
            this.mProgram.sendUniformi("textureU", 1);
            this.mProgram.sendUniformi("textureV", 2);
            this.mProgram.sendUniformMat3("colorConversion", 1, false, MATRIX_YUV2RGB);
            return true;
        }
        return false;
    }

    public void drawTextures() {
        this.mProgram.bind();
        GLES20.glBindBuffer((int)34962, (int)this.mVertBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    public void drawTextures(int texY, int texU, int texV) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)texY);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)texU);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)texV);
        this.drawTextures();
    }
}

