/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import java.nio.ByteBuffer;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.view.CameraGLSurfaceViewWithBuffer;

public class TrackingCameraGLSurfaceView
extends CameraGLSurfaceViewWithBuffer {
    protected TrackingProc mTrackingProc;

    public TrackingCameraGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TrackingProc getTrackingProc() {
        return this.mTrackingProc;
    }

    public boolean setTrackingProc(TrackingProc proc) {
        if (this.mTrackingProc != null) {
            this.mTrackingProc.release();
            this.mTrackingProc = null;
        }
        if (proc == null) {
            return true;
        }
        if (!proc.setup(this.mRecordWidth, this.mRecordHeight)) {
            Log.e((String)"libCGE_java", (String)"setup proc failed!");
            proc.release();
            return false;
        }
        this.mTrackingProc = proc;
        return true;
    }

    @Override
    protected void onRelease() {
        super.onRelease();
        if (this.mTrackingProc != null) {
            this.mTrackingProc.release();
            this.mTrackingProc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.mSurfaceTexture == null) return;
        if (!this.cameraInstance().isPreviewing()) {
            return;
        }
        if (this.mBufferUpdated && this.mTrackingProc != null) {
            int[] nArray = this.mBufferUpdateLock;
            // MONITORENTER : this.mBufferUpdateLock
            this.mTrackingProc.processTracking(this.mBufferY);
            // MONITOREXIT : nArray
        }
        if (this.mTrackingProc == null) {
            super.onDrawFrame(gl);
            return;
        }
        this.mTrackingProc.render(this);
    }

    public static interface TrackingProc {
        public boolean setup(int var1, int var2);

        public void resize(int var1, int var2);

        public void processTracking(ByteBuffer var1);

        public void render(TrackingCameraGLSurfaceView var1);

        public void release();
    }
}

