/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.texUtils;

import android.opengl.GLES20;
import org.wysaid.texUtils.TextureRenderer;

public class TextureRendererDrawOrigin
extends TextureRenderer {
    private static final String fshDrawOrigin = "precision mediump float;\nvarying vec2 texCoord;\nuniform %s inputImageTexture;\nvoid main()\n{\n   gl_FragColor = texture2D(inputImageTexture, texCoord);\n}";

    protected TextureRendererDrawOrigin() {
        this.defaultInitialize();
    }

    protected TextureRendererDrawOrigin(boolean noDefaultInitialize) {
        if (!noDefaultInitialize) {
            this.defaultInitialize();
        }
    }

    public static TextureRendererDrawOrigin create(boolean isExternalOES) {
        TextureRendererDrawOrigin renderer = new TextureRendererDrawOrigin();
        if (!renderer.init(isExternalOES)) {
            renderer.release();
            return null;
        }
        return renderer;
    }

    @Override
    public boolean init(boolean isExternalOES) {
        return this.setProgramDefault(this.getVertexShaderString(), this.getFragmentShaderString(), isExternalOES);
    }

    @Override
    public void renderTexture(int texID, TextureRenderer.Viewport viewport) {
        if (viewport != null) {
            GLES20.glViewport((int)viewport.x, (int)viewport.y, (int)viewport.width, (int)viewport.height);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.TEXTURE_2D_BINDABLE, (int)texID);
        GLES20.glBindBuffer((int)34962, (int)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        this.mProgram.bind();
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    @Override
    public void setTextureSize(int w, int h) {
        this.mTextureWidth = w;
        this.mTextureHeight = h;
    }

    @Override
    public String getVertexShaderString() {
        return "attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat4 transform;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   vec2 coord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n   texCoord = (transform * vec4(coord, 0.0, 1.0)).xy;\n}";
    }

    @Override
    public String getFragmentShaderString() {
        return fshDrawOrigin;
    }
}

