/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import org.wysaid.nativePort.NativeLibraryLoader;

public class CGEFrameRenderer {
    protected long mNativeAddress;

    public CGEFrameRenderer() {
        this.mNativeAddress = this.nativeCreateRenderer();
    }

    protected CGEFrameRenderer(int dummy) {
    }

    public boolean init(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        if (this.mNativeAddress != 0L) {
            return this.nativeInit(this.mNativeAddress, srcWidth, srcHeight, dstWidth, dstHeight);
        }
        return false;
    }

    public void update(int externalTexture, float[] transformMatrix) {
        if (this.mNativeAddress != 0L) {
            this.nativeUpdate(this.mNativeAddress, externalTexture, transformMatrix);
        }
    }

    public void runProc() {
        if (this.mNativeAddress != 0L) {
            this.nativeRunProc(this.mNativeAddress);
        }
    }

    public void render(int x, int y, int width, int height) {
        if (this.mNativeAddress != 0L) {
            this.nativeRender(this.mNativeAddress, x, y, width, height);
        }
    }

    public void drawCache() {
        if (this.mNativeAddress != 0L) {
            this.nativeDrawCache(this.mNativeAddress);
        }
    }

    public void setSrcRotation(float rad) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetSrcRotation(this.mNativeAddress, rad);
        }
    }

    public void setSrcFlipScale(float x, float y) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetSrcFlipScale(this.mNativeAddress, x, y);
        }
    }

    public void setRenderRotation(float rad) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetRenderRotation(this.mNativeAddress, rad);
        }
    }

    public void setRenderFlipScale(float x, float y) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetRenderFlipScale(this.mNativeAddress, x, y);
        }
    }

    public void setFilterWidthConfig(String config) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetFilterWithConfig(this.mNativeAddress, config);
        }
    }

    public void setMaskRotation(float rot) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetMaskRotation(this.mNativeAddress, rot);
        }
    }

    public void setMaskFlipScale(float x, float y) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetMaskFlipScale(this.mNativeAddress, x, y);
        }
    }

    public void setFilterIntensity(float value) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetFilterIntensity(this.mNativeAddress, value);
        }
    }

    public void srcResize(int width, int height) {
        if (this.mNativeAddress != 0L) {
            this.nativeSrcResize(this.mNativeAddress, width, height);
        }
    }

    public void release() {
        if (this.mNativeAddress != 0L) {
            this.nativeRelease(this.mNativeAddress);
            this.mNativeAddress = 0L;
        }
    }

    public void setMaskTexture(int texID, float aspectRatio) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetMaskTexture(this.mNativeAddress, texID, aspectRatio);
        }
    }

    public void setMaskTextureRatio(float aspectRatio) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetMaskTextureRatio(this.mNativeAddress, aspectRatio);
        }
    }

    public int queryBufferTexture() {
        if (this.mNativeAddress != 0L) {
            return this.nativeQueryBufferTexture(this.mNativeAddress);
        }
        return 0;
    }

    public long getImageHandler() {
        return this.nativeGetImageHandler(this.mNativeAddress);
    }

    public void bindImageFBO() {
        this.nativeBindImageFBO(this.mNativeAddress);
    }

    public void swapImageFBO() {
        this.nativeSwapBufferFBO(this.mNativeAddress);
    }

    public void processWithFilter(long nativeFilter) {
        this.nativeProcessWithFilter(this.mNativeAddress, nativeFilter);
    }

    public void setNativeFilter(long nativeFilter) {
        this.nativeSetFilterWithAddr(this.mNativeAddress, nativeFilter);
    }

    protected native long nativeCreateRenderer();

    protected native boolean nativeInit(long var1, int var3, int var4, int var5, int var6);

    protected native void nativeUpdate(long var1, int var3, float[] var4);

    protected native void nativeRunProc(long var1);

    protected native void nativeRender(long var1, int var3, int var4, int var5, int var6);

    protected native void nativeDrawCache(long var1);

    protected native void nativeSetSrcRotation(long var1, float var3);

    protected native void nativeSetSrcFlipScale(long var1, float var3, float var4);

    protected native void nativeSetRenderRotation(long var1, float var3);

    protected native void nativeSetRenderFlipScale(long var1, float var3, float var4);

    protected native void nativeSetFilterWithConfig(long var1, String var3);

    protected native void nativeSetFilterIntensity(long var1, float var3);

    protected native void nativeSetMaskRotation(long var1, float var3);

    protected native void nativeSetMaskFlipScale(long var1, float var3, float var4);

    protected native void nativeSrcResize(long var1, int var3, int var4);

    protected native void nativeSetMaskTexture(long var1, int var3, float var4);

    protected native void nativeSetMaskTextureRatio(long var1, float var3);

    protected native void nativeRelease(long var1);

    protected native int nativeQueryBufferTexture(long var1);

    protected native long nativeGetImageHandler(long var1);

    protected native void nativeBindImageFBO(long var1);

    protected native void nativeSwapBufferFBO(long var1);

    protected native void nativeProcessWithFilter(long var1, long var3);

    protected native void nativeSetFilterWithAddr(long var1, long var3);

    static {
        NativeLibraryLoader.load();
    }
}

