/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import android.graphics.Bitmap;
import android.graphics.PointF;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class CGEFaceTracker {
    protected static boolean sIsTrackerSetup;
    protected long mNativeAddress;
    protected FaceResult mFaceResult = new FaceResult();

    public static boolean isTrackerSetup() {
        return sIsTrackerSetup;
    }

    private CGEFaceTracker() {
        this.mNativeAddress = this.nativeCreateFaceTracker();
    }

    public static CGEFaceTracker createFaceTracker() {
        if (!sIsTrackerSetup) {
            CGEFaceTracker.nativeSetupTracker(null, null, null);
            sIsTrackerSetup = true;
        }
        return new CGEFaceTracker();
    }

    public void release() {
        if (this.mNativeAddress != 0L) {
            this.nativeRelease(this.mNativeAddress);
            this.mNativeAddress = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public FaceResultSimple detectFaceWithSimpleResult(Bitmap bmp, boolean drawFeature) {
        float[] result = this.nativeDetectFaceWithSimpleResult(this.mNativeAddress, bmp, drawFeature);
        if (result == null) {
            return null;
        }
        FaceResultSimple faceResultSimple = new FaceResultSimple();
        faceResultSimple.leftEyePos = new PointF(result[0], result[1]);
        faceResultSimple.rightEyepos = new PointF(result[2], result[3]);
        faceResultSimple.nosePos = new PointF(result[4], result[5]);
        faceResultSimple.mouthPos = new PointF(result[6], result[7]);
        faceResultSimple.jawPos = new PointF(result[8], result[9]);
        return faceResultSimple;
    }

    public FaceResult getFaceResult() {
        return this.mFaceResult;
    }

    public boolean detectFaceWithGrayBuffer(ByteBuffer buffer, int width, int height, int bytesPerRow) {
        return this.nativeDetectFaceWithBuffer(this.mNativeAddress, buffer, width, height, 1, bytesPerRow, this.mFaceResult.faceKeyPoints);
    }

    public boolean detectFaceWithBGRABuffer(ByteBuffer buffer, int width, int height, int bytesPerRow) {
        return this.nativeDetectFaceWithBuffer(this.mNativeAddress, buffer, width, height, 4, bytesPerRow, this.mFaceResult.faceKeyPoints);
    }

    public boolean detectFaceWithBGRBuffer(ByteBuffer buffer, int width, int height, int bytesPerRow) {
        return this.nativeDetectFaceWithBuffer(this.mNativeAddress, buffer, width, height, 3, bytesPerRow, this.mFaceResult.faceKeyPoints);
    }

    private static native void nativeSetupTracker(String var0, String var1, String var2);

    protected native long nativeCreateFaceTracker();

    protected native void nativeRelease(long var1);

    protected native float[] nativeDetectFaceWithSimpleResult(long var1, Bitmap var3, boolean var4);

    protected native boolean nativeDetectFaceWithBuffer(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7, FloatBuffer var8);

    static {
        System.loadLibrary("FaceTracker");
        sIsTrackerSetup = false;
    }

    public static class FaceResult {
        public FloatBuffer faceKeyPoints = ByteBuffer.allocateDirect(528).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static class FaceResultSimple {
        public PointF leftEyePos;
        public PointF rightEyepos;
        public PointF nosePos;
        public PointF mouthPos;
        public PointF jawPos;
    }
}

