/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.opengl.GLES20;
import android.util.AttributeSet;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.camera.CameraInstance;
import org.wysaid.common.Common;
import org.wysaid.common.FrameBufferObject;
import org.wysaid.nativePort.CGEFrameRenderer;
import org.wysaid.nativePort.CGENativeLibrary;
import org.wysaid.view.CameraGLSurfaceView;

public class CameraGLSurfaceViewWithTexture
extends CameraGLSurfaceView
implements SurfaceTexture.OnFrameAvailableListener {
    protected SurfaceTexture mSurfaceTexture;
    protected int mTextureID;
    protected boolean mIsTransformMatrixSet = false;
    protected CGEFrameRenderer mFrameRenderer;
    protected float[] mTransformMatrix = new float[16];

    public CGEFrameRenderer getRecorder() {
        return this.mFrameRenderer;
    }

    public synchronized void setFilterWithConfig(final String config) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraGLSurfaceViewWithTexture.this.mFrameRenderer != null) {
                    CameraGLSurfaceViewWithTexture.this.mFrameRenderer.setFilterWidthConfig(config);
                } else {
                    Log.e((String)"libCGE_java", (String)"setFilterWithConfig after release!!");
                }
            }
        });
    }

    public void setFilterIntensity(final float intensity) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraGLSurfaceViewWithTexture.this.mFrameRenderer != null) {
                    CameraGLSurfaceViewWithTexture.this.mFrameRenderer.setFilterIntensity(intensity);
                } else {
                    Log.e((String)"libCGE_java", (String)"setFilterIntensity after release!!");
                }
            }
        });
    }

    @Override
    public void setOnCreateCallback(final CameraGLSurfaceView.OnCreateCallback callback) {
        if (this.mFrameRenderer == null || callback == null) {
            this.mOnCreateCallback = callback;
        } else {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    callback.createOver();
                }
            });
        }
    }

    public CameraGLSurfaceViewWithTexture(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mFrameRenderer = new CGEFrameRenderer();
        this.mIsTransformMatrixSet = false;
        if (!this.mFrameRenderer.init(this.mRecordWidth, this.mRecordHeight, this.mRecordWidth, this.mRecordHeight)) {
            Log.e((String)"libCGE_java", (String)"Frame Recorder init failed!");
        }
        this.mFrameRenderer.setSrcRotation(1.5707964f);
        this.mFrameRenderer.setSrcFlipScale(1.0f, -1.0f);
        this.mFrameRenderer.setRenderFlipScale(1.0f, -1.0f);
        this.mTextureID = Common.genSurfaceTextureID();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureID);
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        super.onSurfaceCreated(gl, config);
    }

    @Override
    protected void onRelease() {
        super.onRelease();
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mTextureID != 0) {
            Common.deleteTextureID(this.mTextureID);
            this.mTextureID = 0;
        }
        if (this.mFrameRenderer != null) {
            this.mFrameRenderer.release();
            this.mFrameRenderer = null;
        }
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
        if (!this.cameraInstance().isPreviewing()) {
            this.resumePreview();
        }
    }

    @Override
    public void resumePreview() {
        if (this.mFrameRenderer == null) {
            Log.e((String)"libCGE_java", (String)"resumePreview after release!!");
            return;
        }
        if (!this.cameraInstance().isCameraOpened()) {
            int facing = this.mIsCameraBackForward ? 0 : 1;
            this.cameraInstance().tryOpenCamera(new CameraInstance.CameraOpenCallback(){

                @Override
                public void cameraReady() {
                    Log.i((String)"libCGE_java", (String)"tryOpenCamera OK...");
                }
            }, facing);
        }
        if (!this.cameraInstance().isPreviewing()) {
            this.cameraInstance().startPreview(this.mSurfaceTexture);
            this.mFrameRenderer.srcResize(this.cameraInstance().previewHeight(), this.cameraInstance().previewWidth());
        }
        this.requestRender();
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.mSurfaceTexture == null || !this.cameraInstance().isPreviewing()) {
            return;
        }
        this.mSurfaceTexture.updateTexImage();
        this.mSurfaceTexture.getTransformMatrix(this.mTransformMatrix);
        this.mFrameRenderer.update(this.mTextureID, this.mTransformMatrix);
        this.mFrameRenderer.runProc();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        this.mFrameRenderer.render(this.mDrawViewport.x, this.mDrawViewport.y, this.mDrawViewport.width, this.mDrawViewport.height);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.requestRender();
    }

    @Override
    protected void onSwitchCamera() {
        super.onSwitchCamera();
        if (this.mFrameRenderer != null) {
            this.mFrameRenderer.setSrcRotation(1.5707964f);
            this.mFrameRenderer.setRenderFlipScale(1.0f, -1.0f);
        }
    }

    @Override
    public void takeShot(final CameraGLSurfaceView.TakePictureCallback callback) {
        assert (callback != null) : "callback must not be null!";
        if (this.mFrameRenderer == null) {
            Log.e((String)"libCGE_java", (String)"Recorder not initialized!");
            callback.takePictureOK(null);
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                FrameBufferObject frameBufferObject = new FrameBufferObject();
                int bufferTexID = Common.genBlankTextureID(CameraGLSurfaceViewWithTexture.this.mRecordWidth, CameraGLSurfaceViewWithTexture.this.mRecordHeight);
                frameBufferObject.bindTexture(bufferTexID);
                GLES20.glViewport((int)0, (int)0, (int)CameraGLSurfaceViewWithTexture.this.mRecordWidth, (int)CameraGLSurfaceViewWithTexture.this.mRecordHeight);
                CameraGLSurfaceViewWithTexture.this.mFrameRenderer.drawCache();
                IntBuffer buffer = IntBuffer.allocate(CameraGLSurfaceViewWithTexture.this.mRecordWidth * CameraGLSurfaceViewWithTexture.this.mRecordHeight);
                GLES20.glReadPixels((int)0, (int)0, (int)CameraGLSurfaceViewWithTexture.this.mRecordWidth, (int)CameraGLSurfaceViewWithTexture.this.mRecordHeight, (int)6408, (int)5121, (Buffer)buffer);
                Bitmap bmp = Bitmap.createBitmap((int)CameraGLSurfaceViewWithTexture.this.mRecordWidth, (int)CameraGLSurfaceViewWithTexture.this.mRecordHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)buffer);
                Log.i((String)"libCGE_java", (String)String.format("w: %d, h: %d", CameraGLSurfaceViewWithTexture.this.mRecordWidth, CameraGLSurfaceViewWithTexture.this.mRecordHeight));
                frameBufferObject.release();
                GLES20.glDeleteTextures((int)1, (int[])new int[]{bufferTexID}, (int)0);
                callback.takePictureOK(bmp);
            }
        });
    }

    @Override
    public void setPictureSize(int width, int height, boolean isBigger) {
        this.cameraInstance().setPictureSize(height, width, isBigger);
    }

    public synchronized void takePicture(final CameraGLSurfaceView.TakePictureCallback photoCallback, Camera.ShutterCallback shutterCallback, final String config, final float intensity, final boolean isFrontMirror) {
        Camera.Parameters params = this.cameraInstance().getParams();
        if (photoCallback == null || params == null) {
            Log.e((String)"libCGE_java", (String)"takePicture after release!");
            if (photoCallback != null) {
                photoCallback.takePictureOK(null);
            }
            return;
        }
        try {
            params.setRotation(90);
            this.cameraInstance().setParams(params);
        }
        catch (Exception e) {
            Log.e((String)"libCGE_java", (String)("Error when takePicture: " + e.toString()));
            if (photoCallback != null) {
                photoCallback.takePictureOK(null);
            }
            return;
        }
        this.cameraInstance().getCameraDevice().takePicture(shutterCallback, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                Matrix mat;
                Canvas canvas;
                Bitmap bmp2;
                boolean shouldRotate;
                int height;
                int width;
                Bitmap bmp;
                Camera.Parameters params = camera.getParameters();
                Camera.Size sz = params.getPictureSize();
                if (sz.width != sz.height) {
                    bmp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    width = bmp.getWidth();
                    height = bmp.getHeight();
                    shouldRotate = sz.width > sz.height && width > height || sz.width < sz.height && width < height;
                } else {
                    Log.i((String)"libCGE_java", (String)"Cache image to get exif.");
                    try {
                        String tmpFilename = CameraGLSurfaceViewWithTexture.this.getContext().getExternalCacheDir() + "/picture_cache000.jpg";
                        FileOutputStream fileout = new FileOutputStream(tmpFilename);
                        BufferedOutputStream bufferOutStream = new BufferedOutputStream(fileout);
                        bufferOutStream.write(data);
                        bufferOutStream.flush();
                        bufferOutStream.close();
                        ExifInterface exifInterface = new ExifInterface(tmpFilename);
                        int orientation = exifInterface.getAttributeInt("Orientation", 1);
                        switch (orientation) {
                            case 6: {
                                shouldRotate = true;
                                break;
                            }
                            default: {
                                shouldRotate = false;
                            }
                        }
                        bmp = BitmapFactory.decodeFile((String)tmpFilename);
                        width = bmp.getWidth();
                        height = bmp.getHeight();
                    }
                    catch (IOException e) {
                        Log.e((String)"libCGE_java", (String)"Err when saving bitmap...");
                        e.printStackTrace();
                        return;
                    }
                }
                if (width > CameraGLSurfaceViewWithTexture.this.mMaxTextureSize || height > CameraGLSurfaceViewWithTexture.this.mMaxTextureSize) {
                    float scaling = Math.max((float)width / (float)CameraGLSurfaceViewWithTexture.this.mMaxTextureSize, (float)height / (float)CameraGLSurfaceViewWithTexture.this.mMaxTextureSize);
                    Log.i((String)"libCGE_java", (String)String.format("\u76ee\u6807\u5c3a\u5bf8(%d x %d)\u8d85\u8fc7\u5f53\u524d\u8bbe\u5907OpenGL \u80fd\u591f\u5904\u7406\u7684\u6700\u5927\u8303\u56f4(%d x %d)\uff0c \u73b0\u5728\u5c06\u56fe\u7247\u538b\u7f29\u81f3\u5408\u7406\u5927\u5c0f!", width, height, CameraGLSurfaceViewWithTexture.this.mMaxTextureSize, CameraGLSurfaceViewWithTexture.this.mMaxTextureSize));
                    bmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)((int)((float)width / scaling)), (int)((int)((float)height / scaling)), (boolean)false);
                    width = bmp.getWidth();
                    height = bmp.getHeight();
                }
                if (shouldRotate) {
                    bmp2 = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    canvas = new Canvas(bmp2);
                    if (CameraGLSurfaceViewWithTexture.this.cameraInstance().getFacing() == 0) {
                        mat = new Matrix();
                        int halfLen = Math.min(width, height) / 2;
                        mat.setRotate(90.0f, (float)halfLen, (float)halfLen);
                        canvas.drawBitmap(bmp, mat, null);
                    } else {
                        mat = new Matrix();
                        if (isFrontMirror) {
                            mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                            mat.postScale(-1.0f, 1.0f);
                            mat.postTranslate((float)(width / 2), (float)(height / 2));
                            int halfLen = Math.min(width, height) / 2;
                            mat.postRotate(90.0f, (float)halfLen, (float)halfLen);
                        } else {
                            int halfLen = Math.max(width, height) / 2;
                            mat.postRotate(-90.0f, (float)halfLen, (float)halfLen);
                        }
                        canvas.drawBitmap(bmp, mat, null);
                    }
                    bmp.recycle();
                } else if (CameraGLSurfaceViewWithTexture.this.cameraInstance().getFacing() == 0) {
                    bmp2 = bmp;
                } else {
                    bmp2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    canvas = new Canvas(bmp2);
                    mat = new Matrix();
                    if (isFrontMirror) {
                        mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                        mat.postScale(1.0f, -1.0f);
                        mat.postTranslate((float)(width / 2), (float)(height / 2));
                    } else {
                        mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                        mat.postScale(-1.0f, -1.0f);
                        mat.postTranslate((float)(width / 2), (float)(height / 2));
                    }
                    canvas.drawBitmap(bmp, mat, null);
                }
                if (config != null) {
                    CGENativeLibrary.filterImage_MultipleEffectsWriteBack(bmp2, config, intensity);
                }
                photoCallback.takePictureOK(bmp2);
                CameraGLSurfaceViewWithTexture.this.cameraInstance().getCameraDevice().startPreview();
            }
        });
    }
}

