/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import android.util.Log;
import org.wysaid.nativePort.NativeLibraryLoader;

public class CGEDeformFilterWrapper {
    protected long mNativeAddress;

    private CGEDeformFilterWrapper(int w, int h, float stride) {
        this.mNativeAddress = this.nativeCreate(w, h, stride);
    }

    public static CGEDeformFilterWrapper create(int w, int h, float stride) {
        CGEDeformFilterWrapper wrapper = new CGEDeformFilterWrapper(w, h, stride);
        if (wrapper.mNativeAddress == 0L) {
            wrapper.release(true);
            wrapper = null;
            Log.e((String)"libCGE_java", (String)"CGEDeformFilterWrapper.create failed!");
        }
        return wrapper;
    }

    public void release(boolean shouldDeleteNativeFilter) {
        if (this.mNativeAddress != 0L) {
            if (shouldDeleteNativeFilter) {
                this.nativeRelease(this.mNativeAddress);
            }
            this.mNativeAddress = 0L;
        }
    }

    public void restore() {
        this.nativeRestore(this.mNativeAddress);
    }

    public void restoreWithIntensity(float intensity) {
        this.nativeRestoreWithIntensity(this.mNativeAddress, intensity);
    }

    public void forwardDeform(float startX, float startY, float endX, float endY, float w, float h, float radius, float intensity) {
        this.nativeForwardDeform(this.mNativeAddress, startX, startY, endX, endY, w, h, radius, intensity);
    }

    public void restoreWithPoint(float x, float y, float w, float h, float radius, float intensity) {
        this.nativeRestoreWithPoint(this.mNativeAddress, x, y, w, h, radius, intensity);
    }

    public void bloatDeform(float x, float y, float w, float h, float radius, float intensity) {
        this.nativeBloatDeform(this.mNativeAddress, x, y, w, h, radius, intensity);
    }

    public void wrinkleDeform(float x, float y, float w, float h, float radius, float intensity) {
        this.nativeWrinkleDeform(this.mNativeAddress, x, y, w, h, radius, intensity);
    }

    public void setUndoSteps(int undoSteps) {
        this.nativeSetUndoSteps(this.mNativeAddress, undoSteps);
    }

    public boolean canUndo() {
        return this.nativeCanUndo(this.mNativeAddress);
    }

    public boolean canRedo() {
        return this.nativeCanRedo(this.mNativeAddress);
    }

    public boolean undo() {
        return this.nativeUndo(this.mNativeAddress);
    }

    public boolean redo() {
        return this.nativeRedo(this.mNativeAddress);
    }

    public boolean pushDeformStep() {
        return this.nativePushDeformStep(this.mNativeAddress);
    }

    public void showMesh(boolean show) {
        this.nativeShowMesh(this.mNativeAddress, show);
    }

    public long getNativeAddress() {
        return this.mNativeAddress;
    }

    protected native long nativeCreate(int var1, int var2, float var3);

    protected native void nativeRelease(long var1);

    protected native void nativeRestore(long var1);

    protected native void nativeRestoreWithIntensity(long var1, float var3);

    protected native void nativeForwardDeform(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    protected native void nativeRestoreWithPoint(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void nativeBloatDeform(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void nativeWrinkleDeform(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void nativeSetUndoSteps(long var1, int var3);

    protected native boolean nativeCanUndo(long var1);

    protected native boolean nativeCanRedo(long var1);

    protected native boolean nativeUndo(long var1);

    protected native boolean nativeRedo(long var1);

    protected native boolean nativePushDeformStep(long var1);

    protected native void nativeShowMesh(long var1, boolean var3);

    static {
        NativeLibraryLoader.load();
    }
}

