/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.nativePort.CGEImageHandler;
import org.wysaid.texUtils.TextureRenderer;

public class ImageGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    public static final String LOG_TAG = "libCGE_java";
    protected CGEImageHandler mImageHandler;
    protected float mFilterIntensity = 1.0f;
    protected TextureRenderer.Viewport mRenderViewport = new TextureRenderer.Viewport();
    protected int mImageWidth;
    protected int mImageHeight;
    protected int mViewWidth;
    protected int mViewHeight;
    protected DisplayMode mDisplayMode = DisplayMode.DISPLAY_SCALE_TO_FILL;
    protected final Object mSettingIntensityLock = new Object();
    protected int mSettingIntensityCount = 1;
    protected OnSurfaceCreatedCallback mSurfaceCreatedCallback;

    public CGEImageHandler getImageHandler() {
        return this.mImageHandler;
    }

    public TextureRenderer.Viewport getRenderViewport() {
        return this.mRenderViewport;
    }

    public int getImageWidth() {
        return this.mImageWidth;
    }

    public int getImageheight() {
        return this.mImageHeight;
    }

    public DisplayMode getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mDisplayMode = displayMode;
        this.calcViewport();
        this.requestRender();
    }

    public void setFilterWithConfig(final String config) {
        if (this.mImageHandler == null) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"set config after release!!");
                    return;
                }
                ImageGLSurfaceView.this.mImageHandler.setFilterWithConfig(config);
                ImageGLSurfaceView.this.requestRender();
            }
        });
    }

    public void setFilterIntensityForIndex(float intensity, int index) {
        this.setFilterIntensityForIndex(intensity, index, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterIntensityForIndex(float intensity, final int index, final boolean shouldProcess) {
        if (this.mImageHandler == null) {
            return;
        }
        this.mFilterIntensity = intensity;
        Object object = this.mSettingIntensityLock;
        synchronized (object) {
            if (this.mSettingIntensityCount <= 0) {
                Log.i((String)LOG_TAG, (String)"Too fast, skipping...");
                return;
            }
            --this.mSettingIntensityCount;
        }
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"set intensity after release!!");
                } else {
                    ImageGLSurfaceView.this.mImageHandler.setFilterIntensityAtIndex(ImageGLSurfaceView.this.mFilterIntensity, index, shouldProcess);
                    if (shouldProcess) {
                        ImageGLSurfaceView.this.requestRender();
                    }
                }
                Object object = ImageGLSurfaceView.this.mSettingIntensityLock;
                synchronized (object) {
                    ++ImageGLSurfaceView.this.mSettingIntensityCount;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterIntensity(float intensity) {
        if (this.mImageHandler == null) {
            return;
        }
        this.mFilterIntensity = intensity;
        Object object = this.mSettingIntensityLock;
        synchronized (object) {
            if (this.mSettingIntensityCount <= 0) {
                Log.i((String)LOG_TAG, (String)"Too fast, skipping...");
                return;
            }
            --this.mSettingIntensityCount;
        }
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"set intensity after release!!");
                } else {
                    ImageGLSurfaceView.this.mImageHandler.setFilterIntensity(ImageGLSurfaceView.this.mFilterIntensity, true);
                    ImageGLSurfaceView.this.requestRender();
                }
                Object object = ImageGLSurfaceView.this.mSettingIntensityLock;
                synchronized (object) {
                    ++ImageGLSurfaceView.this.mSettingIntensityCount;
                }
            }
        });
    }

    public void flush(final boolean runFilter, final Runnable runnable) {
        if (this.mImageHandler == null || runnable == null) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"flush after release!!");
                } else {
                    runnable.run();
                    if (runFilter) {
                        ImageGLSurfaceView.this.mImageHandler.revertImage();
                        ImageGLSurfaceView.this.mImageHandler.processFilters();
                    }
                    ImageGLSurfaceView.this.requestRender();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyFlush(final boolean runFilter, final Runnable runnable) {
        if (this.mImageHandler == null || runnable == null) {
            return;
        }
        Object object = this.mSettingIntensityLock;
        synchronized (object) {
            if (this.mSettingIntensityCount <= 0) {
                Log.i((String)LOG_TAG, (String)"Too fast, skipping...");
                return;
            }
            --this.mSettingIntensityCount;
        }
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"flush after release!!");
                } else {
                    if (runFilter) {
                        ImageGLSurfaceView.this.mImageHandler.revertImage();
                        ImageGLSurfaceView.this.mImageHandler.processFilters();
                    }
                    runnable.run();
                    ImageGLSurfaceView.this.requestRender();
                }
                Object object = ImageGLSurfaceView.this.mSettingIntensityLock;
                synchronized (object) {
                    ++ImageGLSurfaceView.this.mSettingIntensityCount;
                }
            }
        });
    }

    public void setImageBitmap(final Bitmap bmp) {
        if (bmp == null) {
            return;
        }
        if (this.mImageHandler == null) {
            Log.e((String)LOG_TAG, (String)"Handler not initialized!");
            return;
        }
        this.mImageWidth = bmp.getWidth();
        this.mImageHeight = bmp.getHeight();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (ImageGLSurfaceView.this.mImageHandler == null) {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"set image after release!!");
                    return;
                }
                if (ImageGLSurfaceView.this.mImageHandler.initWithBitmap(bmp)) {
                    ImageGLSurfaceView.this.calcViewport();
                    ImageGLSurfaceView.this.requestRender();
                } else {
                    Log.e((String)ImageGLSurfaceView.LOG_TAG, (String)"setImageBitmap: init handler failed!");
                }
            }
        });
    }

    public void getResultBitmap(final QueryResultBitmapCallback callback) {
        if (callback == null) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Bitmap bmp = ImageGLSurfaceView.this.mImageHandler.getResultBitmap();
                callback.get(bmp);
            }
        });
    }

    public ImageGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 8, 0);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        Log.i((String)LOG_TAG, (String)"ImageGLSurfaceView Construct...");
    }

    public void setSurfaceCreatedCallback(OnSurfaceCreatedCallback callback) {
        this.mSurfaceCreatedCallback = callback;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)LOG_TAG, (String)"ImageGLSurfaceView onSurfaceCreated...");
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2960);
        this.mImageHandler = new CGEImageHandler();
        this.mImageHandler.setDrawerFlipScale(1.0f, -1.0f);
        if (this.mSurfaceCreatedCallback != null) {
            this.mSurfaceCreatedCallback.surfaceCreated();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.calcViewport();
    }

    public void onDrawFrame(GL10 gl) {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClear((int)16384);
        if (this.mImageHandler == null) {
            return;
        }
        GLES20.glViewport((int)this.mRenderViewport.x, (int)this.mRenderViewport.y, (int)this.mRenderViewport.width, (int)this.mRenderViewport.height);
        this.mImageHandler.drawResult();
    }

    public void release() {
        if (this.mImageHandler != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)ImageGLSurfaceView.LOG_TAG, (String)"ImageGLSurfaceView release...");
                    if (ImageGLSurfaceView.this.mImageHandler != null) {
                        ImageGLSurfaceView.this.mImageHandler.release();
                        ImageGLSurfaceView.this.mImageHandler = null;
                    }
                }
            });
        }
    }

    protected void calcViewport() {
        int h;
        int w;
        if (this.mDisplayMode == DisplayMode.DISPLAY_SCALE_TO_FILL) {
            this.mRenderViewport.x = 0;
            this.mRenderViewport.y = 0;
            this.mRenderViewport.width = this.mViewWidth;
            this.mRenderViewport.height = this.mViewHeight;
            return;
        }
        float scaling = (float)this.mImageWidth / (float)this.mImageHeight;
        float viewRatio = (float)this.mViewWidth / (float)this.mViewHeight;
        float s = scaling / viewRatio;
        switch (this.mDisplayMode) {
            case DISPLAY_ASPECT_FILL: {
                if ((double)s > 1.0) {
                    w = (int)((float)this.mViewHeight * scaling);
                    h = this.mViewHeight;
                    break;
                }
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
                break;
            }
            case DISPLAY_ASPECT_FIT: {
                if ((double)s < 1.0) {
                    w = (int)((float)this.mViewHeight * scaling);
                    h = this.mViewHeight;
                    break;
                }
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
                break;
            }
            default: {
                Log.i((String)LOG_TAG, (String)"Error occured, please check the code...");
                return;
            }
        }
        this.mRenderViewport.width = w;
        this.mRenderViewport.height = h;
        this.mRenderViewport.x = (this.mViewWidth - w) / 2;
        this.mRenderViewport.y = (this.mViewHeight - h) / 2;
        Log.i((String)LOG_TAG, (String)String.format("View port: %d, %d, %d, %d", this.mRenderViewport.x, this.mRenderViewport.y, this.mRenderViewport.width, this.mRenderViewport.height));
    }

    public static interface OnSurfaceCreatedCallback {
        public void surfaceCreated();
    }

    public static interface QueryResultBitmapCallback {
        public void get(Bitmap var1);
    }

    public static enum DisplayMode {
        DISPLAY_SCALE_TO_FILL,
        DISPLAY_ASPECT_FILL,
        DISPLAY_ASPECT_FIT;

    }
}

