/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.camera.CameraInstance;

public class CameraGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    public static final String LOG_TAG = "libCGE_java";
    public int mMaxTextureSize = 0;
    protected int mViewWidth;
    protected int mViewHeight;
    protected int mRecordWidth = 480;
    protected int mRecordHeight = 640;
    protected int mMaxPreviewWidth = 1280;
    protected int mMaxPreviewHeight = 1280;
    protected Viewport mDrawViewport = new Viewport();
    protected boolean mFitFullView = false;
    protected boolean mIsCameraBackForward = true;
    protected OnCreateCallback mOnCreateCallback;

    public CameraGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 0, 0);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    public void setPictureSize(int width, int height, boolean isBigger) {
        this.cameraInstance().setPictureSize(height, width, isBigger);
    }

    public synchronized boolean setFlashLightMode(String mode) {
        if (!this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash")) {
            Log.e((String)LOG_TAG, (String)"No flash light is supported by current device!");
            return false;
        }
        if (!this.mIsCameraBackForward) {
            return false;
        }
        Camera.Parameters parameters = this.cameraInstance().getParams();
        if (parameters == null) {
            return false;
        }
        try {
            if (!parameters.getSupportedFlashModes().contains(mode)) {
                Log.e((String)LOG_TAG, (String)"Invalid Flash Light Mode!!!");
                return false;
            }
            parameters.setFlashMode(mode);
            this.cameraInstance().setParams(parameters);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Switch flash light failed, check if you're using front camera.");
            return false;
        }
        return true;
    }

    public Viewport getDrawViewport() {
        return this.mDrawViewport;
    }

    void setMaxPreviewSize(int w, int h) {
        this.mMaxPreviewWidth = w;
        this.mMaxPreviewHeight = h;
    }

    public void setFitFullView(boolean fit) {
        this.mFitFullView = fit;
        this.calcViewport();
    }

    public boolean isCameraBackForward() {
        return this.mIsCameraBackForward;
    }

    public CameraInstance cameraInstance() {
        return CameraInstance.getInstance();
    }

    public void presetCameraForward(boolean isBackForward) {
        this.mIsCameraBackForward = isBackForward;
    }

    public void presetRecordingSize(int width, int height) {
        if (width > this.mMaxPreviewWidth || height > this.mMaxPreviewHeight) {
            float scaling = Math.min((float)this.mMaxPreviewWidth / (float)width, (float)this.mMaxPreviewHeight / (float)height);
            width = (int)((float)width * scaling);
            height = (int)((float)height * scaling);
        }
        this.mRecordWidth = width;
        this.mRecordHeight = height;
        this.cameraInstance().setPreferPreviewSize(width, height);
    }

    public void resumePreview() {
    }

    public void stopPreview() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CameraGLSurfaceView.this.cameraInstance().stopPreview();
            }
        });
    }

    protected void onSwitchCamera() {
    }

    public final void switchCamera() {
        this.mIsCameraBackForward = !this.mIsCameraBackForward;
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CameraGLSurfaceView.this.cameraInstance().stopCamera();
                CameraGLSurfaceView.this.onSwitchCamera();
                int facing = CameraGLSurfaceView.this.mIsCameraBackForward ? 0 : 1;
                CameraGLSurfaceView.this.cameraInstance().tryOpenCamera(new CameraInstance.CameraOpenCallback(){

                    @Override
                    public void cameraReady() {
                        CameraGLSurfaceView.this.resumePreview();
                    }
                }, facing);
                CameraGLSurfaceView.this.requestRender();
            }
        });
    }

    public void focusAtPoint(float x, float y, Camera.AutoFocusCallback focusCallback) {
        this.cameraInstance().focusAtPoint(y, 1.0f - x, focusCallback);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        super.surfaceDestroyed(holder);
        this.cameraInstance().stopCamera();
    }

    public void setOnCreateCallback(OnCreateCallback callback) {
        this.mOnCreateCallback = callback;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)LOG_TAG, (String)"onSurfaceCreated...");
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2960);
        GLES20.glBlendFunc((int)770, (int)771);
        int[] texSize = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])texSize, (int)0);
        this.mMaxTextureSize = texSize[0];
        if (this.mOnCreateCallback != null) {
            this.mOnCreateCallback.createOver();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log.i((String)LOG_TAG, (String)String.format("onSurfaceChanged: %d x %d", width, height));
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.calcViewport();
    }

    public void onDrawFrame(GL10 gl) {
    }

    public void onResume() {
        super.onResume();
        Log.i((String)LOG_TAG, (String)"glsurfaceview onResume...");
    }

    public void onPause() {
        Log.i((String)LOG_TAG, (String)"glsurfaceview onPause in...");
        this.cameraInstance().stopCamera();
        super.onPause();
        Log.i((String)LOG_TAG, (String)"glsurfaceview onPause out...");
    }

    protected void onRelease() {
    }

    public final void release(final ReleaseOKCallback callback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CameraGLSurfaceView.this.onRelease();
                Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)"GLSurfaceview release...");
                if (callback != null) {
                    callback.releaseOK();
                }
            }
        });
    }

    public void takeShot(TakePictureCallback callback) {
    }

    protected void calcViewport() {
        int h;
        int w;
        float scaling = (float)this.mRecordWidth / (float)this.mRecordHeight;
        float viewRatio = (float)this.mViewWidth / (float)this.mViewHeight;
        float s = scaling / viewRatio;
        if (this.mFitFullView) {
            if ((double)s > 1.0) {
                w = (int)((float)this.mViewHeight * scaling);
                h = this.mViewHeight;
            } else {
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
            }
        } else if ((double)s > 1.0) {
            w = this.mViewWidth;
            h = (int)((float)this.mViewWidth / scaling);
        } else {
            h = this.mViewHeight;
            w = (int)((float)this.mViewHeight * scaling);
        }
        this.mDrawViewport.width = w;
        this.mDrawViewport.height = h;
        this.mDrawViewport.x = (this.mViewWidth - this.mDrawViewport.width) / 2;
        this.mDrawViewport.y = (this.mViewHeight - this.mDrawViewport.height) / 2;
        Log.i((String)LOG_TAG, (String)String.format("View port: %d, %d, %d, %d", this.mDrawViewport.x, this.mDrawViewport.y, this.mDrawViewport.width, this.mDrawViewport.height));
    }

    public static interface TakePictureCallback {
        public void takePictureOK(Bitmap var1);
    }

    public static interface ReleaseOKCallback {
        public void releaseOK();
    }

    public static interface OnCreateCallback {
        public void createOver();
    }

    public static class Viewport {
        public int x;
        public int y;
        public int width;
        public int height;
    }
}

