/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import org.wysaid.common.Common;
import org.wysaid.nativePort.NativeLibraryLoader;

public class CGENativeLibrary {
    static LoadImageCallback loadImageCallback;
    static Object callbackArg;

    public static void setLoadImageCallback(LoadImageCallback callback, Object arg) {
        loadImageCallback = callback;
        callbackArg = arg;
    }

    public static TextureResult loadTextureByName(String sourceName) {
        if (loadImageCallback == null) {
            Log.i((String)"libCGE_java", (String)"The loading callback is not set!");
            return null;
        }
        Bitmap bmp = loadImageCallback.loadImage(sourceName, callbackArg);
        if (bmp == null) {
            return null;
        }
        TextureResult result = CGENativeLibrary.loadTextureByBitmap(bmp);
        loadImageCallback.loadImageOK(bmp, callbackArg);
        return result;
    }

    public static TextureResult loadTextureByBitmap(Bitmap bmp) {
        if (bmp == null) {
            return null;
        }
        TextureResult result = new TextureResult();
        result.texID = Common.genNormalTextureID(bmp);
        result.width = bmp.getWidth();
        result.height = bmp.getHeight();
        return result;
    }

    public static TextureResult loadTextureByFile(String fileName) {
        Bitmap bmp = BitmapFactory.decodeFile((String)fileName);
        TextureResult result = CGENativeLibrary.loadTextureByBitmap(bmp);
        bmp.recycle();
        return result;
    }

    public static Bitmap filterImage_MultipleEffects(Bitmap bmp, String config, float intensity) {
        if (config == null || config.length() == 0) {
            return bmp;
        }
        return CGENativeLibrary.cgeFilterImage_MultipleEffects(bmp, config, intensity);
    }

    public static void filterImage_MultipleEffectsWriteBack(Bitmap bmp, String config, float intensity) {
        if (config != null && config.length() != 0) {
            CGENativeLibrary.cgeFilterImage_MultipleEffectsWriteBack(bmp, config, intensity);
        }
    }

    public static long createBlendFilter(TextureBlendMode blendMode, int texID, int texWidth, int texHeight, BlendFilterType blendFilterType, float intensity) {
        return CGENativeLibrary.cgeCreateBlendFilter(blendMode.ordinal(), texID, texWidth, texHeight, blendFilterType.ordinal(), intensity);
    }

    public static native Bitmap cgeFilterImage_MultipleEffects(Bitmap var0, String var1, float var2);

    public static native void cgeFilterImage_MultipleEffectsWriteBack(Bitmap var0, String var1, float var2);

    public static native long cgeCreateFilterWithConfig(String var0, float var1);

    public static native void cgeDeleteFilterWithAddress(long var0);

    public static native long cgeCreateBlendFilter(int var0, int var1, int var2, int var3, int var4, float var5);

    public static native Bitmap cgeFilterImageWithCustomFilter(Bitmap var0, int var1, float var2, boolean var3, boolean var4);

    public static native long cgeCreateCustomNativeFilter(int var0, float var1, boolean var2);

    public static native int cgeGetCustomFilterNum();

    static {
        NativeLibraryLoader.load();
    }

    public static enum BlendFilterType {
        BLEND_NORMAL,
        BLEND_KEEP_RATIO,
        BLEND_TILE;

    }

    public static class TextureResult {
        int texID;
        int width;
        int height;
    }

    public static interface LoadImageCallback {
        public Bitmap loadImage(String var1, Object var2);

        public void loadImageOK(Bitmap var1, Object var2);
    }

    public static enum TextureBlendMode {
        CGE_BLEND_MIX,
        CGE_BLEND_DISSOLVE,
        CGE_BLEND_DARKEN,
        CGE_BLEND_MULTIPLY,
        CGE_BLEND_COLORBURN,
        CGE_BLEND_LINEARBURN,
        CGE_BLEND_DARKER_COLOR,
        CGE_BLEND_LIGHTEN,
        CGE_BLEND_SCREEN,
        CGE_BLEND_COLORDODGE,
        CGE_BLEND_LINEARDODGE,
        CGE_BLEND_LIGHTERCOLOR,
        CGE_BLEND_OVERLAY,
        CGE_BLEND_SOFTLIGHT,
        CGE_BLEND_HARDLIGHT,
        CGE_BLEND_VIVIDLIGHT,
        CGE_BLEND_LINEARLIGHT,
        CGE_BLEND_PINLIGHT,
        CGE_BLEND_HARDMIX,
        CGE_BLEND_DIFFERENCE,
        CGE_BLEND_EXCLUDE,
        CGE_BLEND_SUBTRACT,
        CGE_BLEND_DIVIDE,
        CGE_BLEND_HUE,
        CGE_BLEND_SATURATION,
        CGE_BLEND_COLOR,
        CGE_BLEND_LUMINOSITY,
        CGE_BLEND_ADD,
        CGE_BLEND_ADDREV,
        CGE_BLEND_COLORBW,
        CGE_BLEND_TYPE_MAX_NUM;

    }
}

