/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.texUtils;

import android.opengl.GLES20;
import android.util.Log;
import org.wysaid.common.FrameBufferObject;
import org.wysaid.common.ProgramObject;
import org.wysaid.texUtils.TextureRenderer;
import org.wysaid.texUtils.TextureRendererDrawOrigin;

public class TextureRendererBlur
extends TextureRendererDrawOrigin {
    private static final String vshBlur = "attribute vec2 vPosition;\nvarying vec2 texCoord;\nuniform mat4 transform;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   vec2 coord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n   texCoord = (transform * vec4(coord, 0.0, 1.0)).xy;\n}";
    private static final String vshBlurCache = "attribute vec2 vPosition;\nvarying vec2 texCoord;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   texCoord = vPosition / 2.0 + 0.5;\n}";
    private static final String fshBlur = "precision highp float;\nvarying vec2 texCoord;\nuniform %s inputImageTexture;\nuniform vec2 samplerSteps;\nconst int samplerRadius = 5;\nconst float samplerRadiusFloat = 5.0;\nfloat random(vec2 seed)\n{\n  return fract(sin(dot(seed ,vec2(12.9898,78.233))) * 43758.5453);\n}\nvoid main()\n{\n  vec3 resultColor = vec3(0.0);\n  float blurPixels = 0.0;\n  float offset = random(texCoord) - 0.5;\n  \n  for(int i = -samplerRadius; i <= samplerRadius; ++i)\n  {\n    float percent = (float(i) + offset) / samplerRadiusFloat;\n    float weight = 1.0 - abs(percent);\n    vec2 coord = texCoord + samplerSteps * percent;\n    resultColor += texture2D(inputImageTexture, coord).rgb * weight;\n    blurPixels += weight;\n  }\n  gl_FragColor = vec4(resultColor / blurPixels, 1.0);\n}";
    protected int mTexCache = 0;
    protected FrameBufferObject mFBO;
    protected int mCacheTexWidth;
    protected int mCacheTexHeight;
    private static final String SAMPLER_STEPS = "samplerSteps";
    private int mStepsLoc = 0;
    private int mStepsLocCache = 0;
    private float mSamplerScale = 1.0f;
    private ProgramObject mProgramDrawCache;

    public static TextureRendererBlur create(boolean isExternalOES) {
        TextureRendererBlur renderer = new TextureRendererBlur();
        if (!renderer.init(isExternalOES)) {
            renderer.release();
            return null;
        }
        return renderer;
    }

    public void setSamplerRadius(float radius) {
        this.mSamplerScale = radius / 4.0f;
    }

    @Override
    public boolean init(boolean isExternalOES) {
        this.TEXTURE_2D_BINDABLE = isExternalOES ? 36197 : 3553;
        String fshBlurExtOES = (isExternalOES ? "#extension GL_OES_EGL_image_external : require\n" : "") + String.format(fshBlur, isExternalOES ? "samplerExternalOES" : "sampler2D");
        String fshBlurTex2D = String.format(fshBlur, "sampler2D");
        this.mFBO = new FrameBufferObject();
        this.mProgramDrawCache = new ProgramObject();
        this.mProgramDrawCache.bindAttribLocation("vPosition", 0);
        if (!this.mProgramDrawCache.init(vshBlurCache, fshBlurExtOES)) {
            Log.e((String)"libCGE_java", (String)"blur filter program init failed - 1...");
            return false;
        }
        this.mProgramDrawCache.bind();
        this.mStepsLocCache = this.mProgramDrawCache.getUniformLoc(SAMPLER_STEPS);
        this.mProgram = new ProgramObject();
        this.mProgram.bindAttribLocation("vPosition", 0);
        if (!this.mProgram.init(vshBlur, fshBlurTex2D)) {
            Log.e((String)"libCGE_java", (String)"blur filter program init failed - 2...");
            return false;
        }
        this.mProgram.bind();
        this.mStepsLoc = this.mProgram.getUniformLoc(SAMPLER_STEPS);
        this.setRotation(0.0f);
        return true;
    }

    @Override
    public void release() {
        if (this.mProgramDrawCache != this.mProgram) {
            this.mProgramDrawCache.release();
        }
        super.release();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        this.mFBO.release();
        this.mFBO = null;
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTexCache}, (int)0);
        this.mTexCache = 0;
        this.mProgramDrawCache = null;
    }

    @Override
    public void renderTexture(int texID, TextureRenderer.Viewport viewport) {
        if (this.mTexCache == 0 || this.mCacheTexWidth != this.mTextureWidth || this.mCacheTexHeight != this.mTextureHeight) {
            this.resetCacheTexture();
        }
        this.mFBO.bind();
        GLES20.glViewport((int)0, (int)0, (int)this.mCacheTexWidth, (int)this.mCacheTexHeight);
        GLES20.glBindBuffer((int)34962, (int)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.TEXTURE_2D_BINDABLE, (int)texID);
        this.mProgramDrawCache.bind();
        GLES20.glUniform2f((int)this.mStepsLocCache, (float)(1.0f / (float)this.mTextureWidth * this.mSamplerScale), (float)0.0f);
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
        if (viewport != null) {
            GLES20.glViewport((int)viewport.x, (int)viewport.y, (int)viewport.width, (int)viewport.height);
        }
        this.mProgram.bind();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.mTexCache);
        GLES20.glUniform2f((int)this.mStepsLoc, (float)0.0f, (float)(1.0f / (float)this.mCacheTexWidth * this.mSamplerScale));
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    @Override
    public void setTextureSize(int w, int h) {
        super.setTextureSize(w, h);
    }

    @Override
    public String getVertexShaderString() {
        return vshBlur;
    }

    @Override
    public String getFragmentShaderString() {
        return fshBlur;
    }

    protected void resetCacheTexture() {
        Log.i((String)"libCGE_java", (String)"resetCacheTexture...");
        this.mCacheTexWidth = this.mTextureWidth;
        this.mCacheTexHeight = this.mTextureHeight;
        if (this.mTexCache == 0) {
            int[] texCache = new int[1];
            GLES20.glGenTextures((int)1, (int[])texCache, (int)0);
            this.mTexCache = texCache[0];
        }
        GLES20.glBindTexture((int)3553, (int)this.mTexCache);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mCacheTexWidth, (int)this.mCacheTexHeight, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        this.mFBO.bindTexture(this.mTexCache);
    }
}

