/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.common;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Common {
    public static final boolean DEBUG = true;
    public static final String LOG_TAG = "libCGE_java";
    public static final float[] FULLSCREEN_VERTICES = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};

    public static void checkGLError(String tag) {
        int err = GLES20.glGetError();
        for (int loopCnt = 0; loopCnt < 32 && err != 0; ++loopCnt) {
            String msg;
            switch (err) {
                case 1280: {
                    msg = "invalid enum";
                    break;
                }
                case 1286: {
                    msg = "invalid framebuffer operation";
                    break;
                }
                case 1282: {
                    msg = "invalid operation";
                    break;
                }
                case 1281: {
                    msg = "invalid value";
                    break;
                }
                case 1285: {
                    msg = "out of memory";
                    break;
                }
                default: {
                    msg = "unknown error";
                }
            }
            Log.e((String)LOG_TAG, (String)String.format("After tag \"%s\" glGetError %s(0x%x) ", tag, msg, err));
            err = GLES20.glGetError();
        }
    }

    private static void _texParamHelper(int type, int filter, int wrap) {
        GLES20.glTexParameterf((int)type, (int)10241, (float)filter);
        GLES20.glTexParameterf((int)type, (int)10240, (float)filter);
        GLES20.glTexParameteri((int)type, (int)10242, (int)wrap);
        GLES20.glTexParameteri((int)type, (int)10243, (int)wrap);
    }

    public static int genBlankTextureID(int width, int height) {
        return Common.genBlankTextureID(width, height, 9729, 33071);
    }

    public static int genBlankTextureID(int width, int height, int filter, int wrap) {
        int[] texID = new int[1];
        GLES20.glGenTextures((int)1, (int[])texID, (int)0);
        GLES20.glBindTexture((int)3553, (int)texID[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        Common._texParamHelper(3553, filter, wrap);
        return texID[0];
    }

    public static int genNormalTextureID(Bitmap bmp) {
        return Common.genNormalTextureID(bmp, 9729, 33071);
    }

    public static int genNormalTextureID(Bitmap bmp, int filter, int wrap) {
        int[] texID = new int[1];
        GLES20.glGenTextures((int)1, (int[])texID, (int)0);
        GLES20.glBindTexture((int)3553, (int)texID[0]);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bmp, (int)0);
        Common._texParamHelper(3553, filter, wrap);
        return texID[0];
    }

    public static int genSurfaceTextureID() {
        int[] texID = new int[1];
        GLES20.glGenTextures((int)1, (int[])texID, (int)0);
        GLES20.glBindTexture((int)36197, (int)texID[0]);
        Common._texParamHelper(36197, 9729, 33071);
        return texID[0];
    }

    public static void deleteTextureID(int texID) {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{texID}, (int)0);
    }

    public static int genFullscreenVertexArrayBuffer() {
        int[] vertexBuffer = new int[1];
        GLES20.glGenBuffers((int)1, (int[])vertexBuffer, (int)0);
        if (vertexBuffer[0] == 0) {
            Log.e((String)LOG_TAG, (String)"Invalid VertexBuffer! You must call this within an OpenGL thread!");
            return 0;
        }
        GLES20.glBindBuffer((int)34962, (int)vertexBuffer[0]);
        FloatBuffer buffer = FloatBuffer.allocate(FULLSCREEN_VERTICES.length);
        buffer.put(FULLSCREEN_VERTICES).position(0);
        GLES20.glBufferData((int)34962, (int)32, (Buffer)buffer, (int)35044);
        return vertexBuffer[0];
    }
}

