/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import android.graphics.Bitmap;
import android.graphics.PointF;

public class CGEFaceTracker {
    protected static boolean sIsTrackerSetup;
    protected long mNativeAddress = this.nativeCreateFaceTracker();

    public static boolean isTrackerSetup() {
        return sIsTrackerSetup;
    }

    private CGEFaceTracker() {
    }

    public static CGEFaceTracker createFaceTracker() {
        if (!sIsTrackerSetup) {
            CGEFaceTracker.nativeSetupTracker(null, null, null);
            sIsTrackerSetup = true;
        }
        return new CGEFaceTracker();
    }

    public void release() {
        if (this.mNativeAddress != 0L) {
            this.nativeRelease(this.mNativeAddress);
            this.mNativeAddress = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public FaceResultSimple detectFaceWithSimpleResult(Bitmap bmp, boolean drawFeature) {
        float[] result = this.nativeDetectFaceWithSimpleResult(this.mNativeAddress, bmp, drawFeature);
        if (result == null) {
            return null;
        }
        FaceResultSimple faceResultSimple = new FaceResultSimple();
        faceResultSimple.leftEyePos = new PointF(result[0], result[1]);
        faceResultSimple.rightEyepos = new PointF(result[2], result[3]);
        faceResultSimple.nosePos = new PointF(result[4], result[5]);
        faceResultSimple.mouthPos = new PointF(result[6], result[7]);
        faceResultSimple.jawPos = new PointF(result[8], result[9]);
        return faceResultSimple;
    }

    private static native void nativeSetupTracker(String var0, String var1, String var2);

    protected native long nativeCreateFaceTracker();

    protected native void nativeRelease(long var1);

    protected native float[] nativeDetectFaceWithSimpleResult(long var1, Bitmap var3, boolean var4);

    static {
        System.loadLibrary("FaceTracker");
        sIsTrackerSetup = false;
    }

    public static class FaceResultSimple {
        public PointF leftEyePos;
        public PointF rightEyepos;
        public PointF nosePos;
        public PointF mouthPos;
        public PointF jawPos;
    }
}

