/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.myUtils;

import android.graphics.Bitmap;
import android.media.FaceDetector;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.wysaid.myUtils.FileUtil;

public class ImageUtil
extends FileUtil {
    public static String saveBitmap(Bitmap bmp) {
        String path = ImageUtil.getPath();
        long currentTime = System.currentTimeMillis();
        String filename = path + "/" + currentTime + ".jpg";
        return ImageUtil.saveBitmap(bmp, filename);
    }

    public static String saveBitmap(Bitmap bmp, String filename) {
        Log.i((String)"libCGE_java", (String)("saving Bitmap : " + filename));
        try {
            FileOutputStream fileout = new FileOutputStream(filename);
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(fileout);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferOutStream);
            bufferOutStream.flush();
            bufferOutStream.close();
        }
        catch (IOException e) {
            Log.e((String)"libCGE_java", (String)"Err when saving bitmap...");
            e.printStackTrace();
            return null;
        }
        Log.i((String)"libCGE_java", (String)("Bitmap " + filename + " saved!"));
        return filename;
    }

    public static FaceRects findFaceByBitmap(Bitmap bmp) {
        return ImageUtil.findFaceByBitmap(bmp, 1);
    }

    public static FaceRects findFaceByBitmap(Bitmap bmp, int maxFaces) {
        if (bmp == null) {
            Log.e((String)"libCGE_java", (String)"Invalid Bitmap for Face Detection!");
            return null;
        }
        Bitmap newBitmap = bmp;
        if (newBitmap.getConfig() != Bitmap.Config.RGB_565) {
            newBitmap = newBitmap.copy(Bitmap.Config.RGB_565, false);
        }
        FaceRects rects = new FaceRects();
        rects.faces = new FaceDetector.Face[maxFaces];
        try {
            FaceDetector detector = new FaceDetector(newBitmap.getWidth(), newBitmap.getHeight(), maxFaces);
            rects.numOfFaces = detector.findFaces(newBitmap, rects.faces);
        }
        catch (Exception e) {
            Log.e((String)"libCGE_java", (String)("findFaceByBitmap error: " + e.getMessage()));
            return null;
        }
        if (newBitmap != bmp) {
            newBitmap.recycle();
        }
        return rects;
    }

    public static class FaceRects {
        public int numOfFaces;
        public FaceDetector.Face[] faces;
    }
}

