/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.camera;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CameraInstance {
    public static final String LOG_TAG = "libCGE_java";
    private static final String ASSERT_MSG = "\u68c0\u6d4b\u5230CameraDevice \u4e3a null! \u8bf7\u68c0\u67e5";
    private Camera mCameraDevice;
    private Camera.Parameters mParams;
    public static final int DEFAULT_PREVIEW_RATE = 30;
    private boolean mIsPreviewing = false;
    private int mDefaultCameraID = -1;
    private static CameraInstance mThisInstance;
    private int mPreviewWidth;
    private int mPreviewHeight;
    private int mPictureWidth = 1000;
    private int mPictureHeight = 1000;
    private int mPreferPreviewWidth = 640;
    private int mPreferPreviewHeight = 640;
    private int mFacing = 0;
    private Comparator<Camera.Size> comparatorBigger = new Comparator<Camera.Size>(){

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int w = rhs.width - lhs.width;
            if (w == 0) {
                return rhs.height - lhs.height;
            }
            return w;
        }
    };
    private Comparator<Camera.Size> comparatorSmaller = new Comparator<Camera.Size>(){

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int w = lhs.width - rhs.width;
            if (w == 0) {
                return lhs.height - rhs.height;
            }
            return w;
        }
    };

    private CameraInstance() {
    }

    public static synchronized CameraInstance getInstance() {
        if (mThisInstance == null) {
            mThisInstance = new CameraInstance();
        }
        return mThisInstance;
    }

    public boolean isPreviewing() {
        return this.mIsPreviewing;
    }

    public int previewWidth() {
        return this.mPreviewWidth;
    }

    public int previewHeight() {
        return this.mPreviewHeight;
    }

    public int pictureWidth() {
        return this.mPictureWidth;
    }

    public int pictureHeight() {
        return this.mPictureHeight;
    }

    public void setPreferPreviewSize(int w, int h) {
        this.mPreferPreviewHeight = w;
        this.mPreferPreviewWidth = h;
    }

    public boolean tryOpenCamera(CameraOpenCallback callback) {
        return this.tryOpenCamera(callback, 0);
    }

    public int getFacing() {
        return this.mFacing;
    }

    public synchronized boolean tryOpenCamera(CameraOpenCallback callback, int facing) {
        Log.i((String)LOG_TAG, (String)"try open camera...");
        try {
            if (Build.VERSION.SDK_INT > 8) {
                int numberOfCameras = Camera.getNumberOfCameras();
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                for (int i = 0; i < numberOfCameras; ++i) {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != facing) continue;
                    this.mDefaultCameraID = i;
                    this.mFacing = facing;
                }
            }
            this.stopPreview();
            if (this.mCameraDevice != null) {
                this.mCameraDevice.release();
            }
            if (this.mDefaultCameraID >= 0) {
                this.mCameraDevice = Camera.open((int)this.mDefaultCameraID);
            } else {
                this.mCameraDevice = Camera.open();
                this.mFacing = 0;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Open Camera Failed!");
            e.printStackTrace();
            this.mCameraDevice = null;
            return false;
        }
        if (this.mCameraDevice != null) {
            Log.i((String)LOG_TAG, (String)"Camera opened!");
            try {
                this.initCamera(30);
            }
            catch (Exception e) {
                this.mCameraDevice.release();
                this.mCameraDevice = null;
                return false;
            }
            if (callback != null) {
                callback.cameraReady();
            }
            return true;
        }
        return false;
    }

    public synchronized void stopCamera() {
        if (this.mCameraDevice != null) {
            this.mIsPreviewing = false;
            this.mCameraDevice.stopPreview();
            this.mCameraDevice.setPreviewCallback(null);
            this.mCameraDevice.release();
            this.mCameraDevice = null;
        }
    }

    public boolean isCameraOpened() {
        return this.mCameraDevice != null;
    }

    public synchronized void startPreview(SurfaceTexture texture) {
        Log.i((String)LOG_TAG, (String)"Camera startPreview...");
        if (this.mIsPreviewing) {
            Log.e((String)LOG_TAG, (String)"Err: camera is previewing...");
            return;
        }
        if (this.mCameraDevice != null) {
            try {
                this.mCameraDevice.setPreviewTexture(texture);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mCameraDevice.startPreview();
            this.mIsPreviewing = true;
        }
    }

    public synchronized void stopPreview() {
        if (this.mIsPreviewing && this.mCameraDevice != null) {
            Log.i((String)LOG_TAG, (String)"Camera stopPreview...");
            this.mIsPreviewing = false;
            this.mCameraDevice.stopPreview();
        }
    }

    public synchronized Camera.Parameters getParams() {
        if (this.mCameraDevice != null) {
            return this.mCameraDevice.getParameters();
        }
        assert (this.mCameraDevice != null) : "\u68c0\u6d4b\u5230CameraDevice \u4e3a null! \u8bf7\u68c0\u67e5";
        return null;
    }

    public synchronized void setParams(Camera.Parameters param) {
        if (this.mCameraDevice != null) {
            this.mParams = param;
            this.mCameraDevice.setParameters(this.mParams);
        }
        assert (this.mCameraDevice != null) : "\u68c0\u6d4b\u5230CameraDevice \u4e3a null! \u8bf7\u68c0\u67e5";
    }

    public Camera getCameraDevice() {
        return this.mCameraDevice;
    }

    public void initCamera(int previewRate) {
        if (this.mCameraDevice == null) {
            Log.e((String)LOG_TAG, (String)"initCamera: Camera is not opened!");
            return;
        }
        this.mParams = this.mCameraDevice.getParameters();
        List supportedPictureFormats = this.mParams.getSupportedPictureFormats();
        Iterator iterator = supportedPictureFormats.iterator();
        while (iterator.hasNext()) {
            int fmt = (Integer)iterator.next();
            Log.i((String)LOG_TAG, (String)String.format("Picture Format: %x", fmt));
        }
        this.mParams.setPictureFormat(256);
        List picSizes = this.mParams.getSupportedPictureSizes();
        Camera.Size picSz = null;
        Collections.sort(picSizes, this.comparatorBigger);
        for (Camera.Size sz : picSizes) {
            Log.i((String)LOG_TAG, (String)String.format("Supported picture size: %d x %d", sz.width, sz.height));
            if (picSz != null && (sz.width < this.mPictureWidth || sz.height < this.mPictureHeight)) continue;
            picSz = sz;
        }
        List prevSizes = this.mParams.getSupportedPreviewSizes();
        Camera.Size prevSz = null;
        Collections.sort(prevSizes, this.comparatorBigger);
        for (Camera.Size sz : prevSizes) {
            Log.i((String)LOG_TAG, (String)String.format("Supported preview size: %d x %d", sz.width, sz.height));
            if (prevSz != null && (sz.width < this.mPreferPreviewWidth || sz.height < this.mPreferPreviewHeight)) continue;
            prevSz = sz;
        }
        List frameRates = this.mParams.getSupportedPreviewFrameRates();
        int fpsMax = 0;
        for (Integer n : frameRates) {
            Log.i((String)LOG_TAG, (String)("Supported frame rate: " + n));
            if (fpsMax >= n) continue;
            fpsMax = n;
        }
        this.mParams.setPreviewSize(prevSz.width, prevSz.height);
        this.mParams.setPictureSize(picSz.width, picSz.height);
        List focusModes = this.mParams.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            this.mParams.setFocusMode("continuous-video");
        }
        previewRate = fpsMax;
        this.mParams.setPreviewFrameRate(previewRate);
        try {
            this.mCameraDevice.setParameters(this.mParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mParams = this.mCameraDevice.getParameters();
        Camera.Size szPic = this.mParams.getPictureSize();
        Camera.Size szPrev = this.mParams.getPreviewSize();
        this.mPreviewWidth = szPrev.width;
        this.mPreviewHeight = szPrev.height;
        this.mPictureWidth = szPic.width;
        this.mPictureHeight = szPic.height;
        Log.i((String)LOG_TAG, (String)String.format("Camera Picture Size: %d x %d", szPic.width, szPic.height));
        Log.i((String)LOG_TAG, (String)String.format("Camera Preview Size: %d x %d", szPrev.width, szPrev.height));
    }

    public synchronized void setFocusMode(String focusMode) {
        if (this.mCameraDevice == null) {
            return;
        }
        this.mParams = this.mCameraDevice.getParameters();
        List focusModes = this.mParams.getSupportedFocusModes();
        if (focusModes.contains(focusMode)) {
            this.mParams.setFocusMode(focusMode);
        }
    }

    public synchronized void setPictureSize(int width, int height, boolean isBigger) {
        if (this.mCameraDevice == null) {
            this.mPictureWidth = width;
            this.mPictureHeight = height;
            return;
        }
        this.mParams = this.mCameraDevice.getParameters();
        List picSizes = this.mParams.getSupportedPictureSizes();
        Camera.Size picSz = null;
        if (isBigger) {
            Collections.sort(picSizes, this.comparatorBigger);
            for (Camera.Size sz : picSizes) {
                if (picSz != null && (sz.width < width || sz.height < height)) continue;
                picSz = sz;
            }
        } else {
            Collections.sort(picSizes, this.comparatorSmaller);
            for (Camera.Size sz : picSizes) {
                if (picSz != null && (sz.width > width || sz.height > height)) continue;
                picSz = sz;
            }
        }
        this.mPictureWidth = picSz.width;
        this.mPictureHeight = picSz.height;
        try {
            this.mParams.setPictureSize(this.mPictureWidth, this.mPictureHeight);
            this.mCameraDevice.setParameters(this.mParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void focusAtPoint(float x, float y, Camera.AutoFocusCallback callback) {
        this.focusAtPoint(x, y, 0.2f, callback);
    }

    public synchronized void focusAtPoint(float x, float y, float radius, Camera.AutoFocusCallback callback) {
        if (this.mCameraDevice == null) {
            Log.e((String)LOG_TAG, (String)"Error: focus after release.");
            return;
        }
        this.mParams = this.mCameraDevice.getParameters();
        if (this.mParams.getMaxNumMeteringAreas() > 0) {
            int focusRadius = (int)(radius * 1000.0f);
            int left = (int)(x * 2000.0f - 1000.0f) - focusRadius;
            int top = (int)(y * 2000.0f - 1000.0f) - focusRadius;
            Rect focusArea = new Rect();
            focusArea.left = Math.max(left, -1000);
            focusArea.top = Math.max(top, -1000);
            focusArea.right = Math.min(left + focusRadius, 1000);
            focusArea.bottom = Math.min(top + focusRadius, 1000);
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(focusArea, 800));
            try {
                this.mCameraDevice.cancelAutoFocus();
                this.mParams.setFocusMode("auto");
                this.mParams.setFocusAreas(meteringAreas);
                this.mCameraDevice.setParameters(this.mParams);
                this.mCameraDevice.autoFocus(callback);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Error: focusAtPoint failed: " + e.toString()));
            }
        } else {
            Log.i((String)LOG_TAG, (String)"The device does not support metering areas...");
            try {
                this.mCameraDevice.autoFocus(callback);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Error: focusAtPoint failed: " + e.toString()));
            }
        }
    }

    public static interface CameraOpenCallback {
        public void cameraReady();
    }
}

