/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.nativePort;

import java.nio.ShortBuffer;
import org.wysaid.nativePort.CGEFrameRenderer;
import org.wysaid.nativePort.NativeLibraryLoader;

public class CGEFrameRecorder
extends CGEFrameRenderer {
    public CGEFrameRecorder() {
        super(0);
        this.mNativeAddress = this.nativeCreateRecorder();
    }

    public boolean startRecording(int fps, String filename) {
        return this.startRecording(fps, 1650000, filename);
    }

    public boolean startRecording(int fps, int bitRate, String filename) {
        if (this.mNativeAddress != 0L) {
            return this.nativeStartRecording(this.mNativeAddress, fps, filename, bitRate);
        }
        return false;
    }

    public boolean isRecordingStarted() {
        if (this.mNativeAddress != 0L) {
            return this.nativeIsRecordingStarted(this.mNativeAddress);
        }
        return false;
    }

    public boolean endRecording(boolean shouldSave) {
        if (this.mNativeAddress != 0L) {
            return this.nativeEndRecording(this.mNativeAddress, shouldSave);
        }
        return false;
    }

    public void pauseRecording() {
        if (this.mNativeAddress != 0L) {
            this.nativePauseRecording(this.mNativeAddress);
        }
    }

    public double getTimestamp() {
        if (this.mNativeAddress != 0L) {
            return this.nativeGetTimestamp(this.mNativeAddress);
        }
        return 0.0;
    }

    public double getVideoStreamtime() {
        if (this.mNativeAddress != 0L) {
            return this.nativeGetVideoStreamtime(this.mNativeAddress);
        }
        return 0.0;
    }

    public double getAudioStreamtime() {
        if (this.mNativeAddress != 0L) {
            return this.nativeGetAudioStreamtime(this.mNativeAddress);
        }
        return 0.0;
    }

    public void setTempDir(String dir) {
        if (this.mNativeAddress != 0L) {
            this.nativeSetTempDir(this.mNativeAddress, dir);
        }
    }

    public void recordImageFrame() {
        if (this.mNativeAddress != 0L) {
            this.nativeRecordImageFrame(this.mNativeAddress);
        }
    }

    public void recordAudioFrame(ShortBuffer audioBuffer, int bufferLen) {
        if (this.mNativeAddress != 0L) {
            this.nativeRecordAudioFrame(this.mNativeAddress, audioBuffer, bufferLen);
        }
    }

    private native long nativeCreateRecorder();

    private native boolean nativeStartRecording(long var1, int var3, String var4, int var5);

    private native boolean nativeIsRecordingStarted(long var1);

    private native boolean nativeEndRecording(long var1, boolean var3);

    private native void nativePauseRecording(long var1);

    private native double nativeGetTimestamp(long var1);

    private native double nativeGetVideoStreamtime(long var1);

    private native double nativeGetAudioStreamtime(long var1);

    private native void nativeSetTempDir(long var1, String var3);

    private native void nativeRecordImageFrame(long var1);

    private native void nativeRecordAudioFrame(long var1, ShortBuffer var3, int var4);

    static {
        NativeLibraryLoader.load();
    }
}

