/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.myUtils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileUtil {
    public static final String LOG_TAG = "libCGE_java";
    public static final File externalStorageDirectory = Environment.getExternalStorageDirectory();
    public static String packageFilesDirectory = null;
    public static String storagePath = null;
    private static String mDefaultFolder = "libCGE";

    public static void setDefaultFolder(String defaultFolder) {
        mDefaultFolder = defaultFolder;
    }

    public static String getPath() {
        return FileUtil.getPath(null);
    }

    public static String getPath(Context context) {
        File file;
        if (storagePath == null && !(file = new File(storagePath = externalStorageDirectory.getAbsolutePath() + "/" + mDefaultFolder)).exists() && !file.mkdirs()) {
            storagePath = FileUtil.getPathInPackage(context, true);
        }
        return storagePath;
    }

    public static String getPathInPackage(Context context, boolean grantPermissions) {
        if (context == null || packageFilesDirectory != null) {
            return packageFilesDirectory;
        }
        String path = context.getFilesDir() + "/" + mDefaultFolder;
        File file = new File(path);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                Log.e((String)LOG_TAG, (String)"\u5728pakage\u76ee\u5f55\u521b\u5efaCGE\u4e34\u65f6\u76ee\u5f55\u5931\u8d25!");
                return null;
            }
            if (grantPermissions) {
                if (file.setExecutable(true, false)) {
                    Log.i((String)LOG_TAG, (String)"Package folder is executable");
                }
                if (file.setReadable(true, false)) {
                    Log.i((String)LOG_TAG, (String)"Package folder is readable");
                }
                if (file.setWritable(true, false)) {
                    Log.i((String)LOG_TAG, (String)"Package folder is writable");
                }
            }
        }
        packageFilesDirectory = path;
        return packageFilesDirectory;
    }

    public static void saveTextContent(String text, String filename) {
        Log.i((String)LOG_TAG, (String)("Saving text : " + filename));
        try {
            FileOutputStream fileout = new FileOutputStream(filename);
            fileout.write(text.getBytes());
            fileout.flush();
            fileout.close();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error: " + e.getMessage()));
        }
    }

    public static String getTextContent(String filename) {
        Log.i((String)LOG_TAG, (String)("Reading text : " + filename));
        if (filename == null) {
            return null;
        }
        String content = "";
        byte[] buffer = new byte[256];
        try {
            int len;
            FileInputStream filein = new FileInputStream(filename);
            while ((len = filein.read(buffer)) > 0) {
                content = content + new String(buffer, 0, len);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error: " + e.getMessage()));
            return null;
        }
        return content;
    }
}

