/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.wysaid.camera.CameraInstance;
import org.wysaid.common.Common;
import org.wysaid.common.FrameBufferObject;
import org.wysaid.nativePort.CGEFrameRenderer;
import org.wysaid.nativePort.CGENativeLibrary;
import org.wysaid.texUtils.TextureRenderer;

public class CameraGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    public static final String LOG_TAG = "libCGE_java";
    public int mMaxTextureSize = 0;
    public int mViewWidth;
    public int mViewHeight;
    protected int mRecordWidth = 480;
    protected int mRecordHeight = 640;
    protected SurfaceTexture mSurfaceTexture;
    protected int mTextureID;
    protected CGEFrameRenderer mFrameRecorder;
    public int mMaxPreviewWidth = 1280;
    public int mMaxPreviewHeight = 1280;
    public ClearColor mClearColor;
    protected TextureRenderer.Viewport mDrawViewport = new TextureRenderer.Viewport();
    protected boolean mIsUsingMask = false;
    protected boolean mFitFullView = false;
    protected boolean mIsTransformMatrixSet = false;
    protected float mMaskAspectRatio = 1.0f;
    protected boolean mIsCameraBackForward = true;
    protected OnCreateCallback mOnCreateCallback;
    private float[] _transformMatrix = new float[16];
    protected long mTimeCount2 = 0L;
    protected long mFramesCount2 = 0L;
    protected long mLastTimestamp2 = 0L;

    public CGEFrameRenderer getRecorder() {
        return this.mFrameRecorder;
    }

    void setMaxPreviewSize(int w, int h) {
        this.mMaxPreviewWidth = w;
        this.mMaxPreviewHeight = h;
    }

    public void setFitFullView(boolean fit) {
        this.mFitFullView = fit;
        if (this.mFrameRecorder != null) {
            this.calcViewport();
        }
    }

    public boolean isUsingMask() {
        return this.mIsUsingMask;
    }

    public boolean isCameraBackForward() {
        return this.mIsCameraBackForward;
    }

    public void setClearColor(float r, float g, float b, float a) {
        this.mClearColor.r = r;
        this.mClearColor.g = g;
        this.mClearColor.b = b;
        this.mClearColor.a = a;
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20.glClearColor((float)CameraGLSurfaceView.this.mClearColor.r, (float)CameraGLSurfaceView.this.mClearColor.g, (float)CameraGLSurfaceView.this.mClearColor.b, (float)CameraGLSurfaceView.this.mClearColor.a);
                GLES20.glClear((int)16640);
            }
        });
    }

    public CameraInstance cameraInstance() {
        return CameraInstance.getInstance();
    }

    public void presetCameraForward(boolean isBackForward) {
        this.mIsCameraBackForward = isBackForward;
    }

    public void presetRecordingSize(int width, int height) {
        if (width > this.mMaxPreviewWidth || height > this.mMaxPreviewHeight) {
            float scaling = Math.min((float)this.mMaxPreviewWidth / (float)width, (float)this.mMaxPreviewHeight / (float)height);
            width = (int)((float)width * scaling);
            height = (int)((float)height * scaling);
        }
        this.mRecordWidth = width;
        this.mRecordHeight = height;
        this.cameraInstance().setPreferPreviewSize(width, height);
    }

    public synchronized void switchCamera() {
        boolean bl = this.mIsCameraBackForward = !this.mIsCameraBackForward;
        if (this.mFrameRecorder != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (CameraGLSurfaceView.this.mFrameRecorder == null) {
                        Log.e((String)CameraGLSurfaceView.LOG_TAG, (String)"Error: switchCamera after release!!");
                        return;
                    }
                    CameraGLSurfaceView.this.cameraInstance().stopCamera();
                    int facing = CameraGLSurfaceView.this.mIsCameraBackForward ? 0 : 1;
                    CameraGLSurfaceView.this.mFrameRecorder.setSrcRotation(1.5707964f);
                    CameraGLSurfaceView.this.mFrameRecorder.setRenderFlipScale(1.0f, -1.0f);
                    if (CameraGLSurfaceView.this.mIsUsingMask) {
                        CameraGLSurfaceView.this.mFrameRecorder.setMaskTextureRatio(CameraGLSurfaceView.this.mMaskAspectRatio);
                    }
                    CameraGLSurfaceView.this.cameraInstance().tryOpenCamera(new CameraInstance.CameraOpenCallback(){

                        @Override
                        public void cameraReady() {
                            if (!CameraGLSurfaceView.this.cameraInstance().isPreviewing()) {
                                Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)"## switch camera -- start preview...");
                                CameraGLSurfaceView.this.cameraInstance().startPreview(CameraGLSurfaceView.this.mSurfaceTexture);
                                CameraGLSurfaceView.this.mFrameRecorder.srcResize(CameraGLSurfaceView.this.cameraInstance().previewHeight(), CameraGLSurfaceView.this.cameraInstance().previewWidth());
                            }
                        }
                    }, facing);
                    CameraGLSurfaceView.this.requestRender();
                }
            });
        }
    }

    public void focusAtPoint(float x, float y, Camera.AutoFocusCallback focusCallback) {
        this.cameraInstance().focusAtPoint(y, 1.0f - x, focusCallback);
    }

    public synchronized boolean setFlashLightMode(String mode) {
        if (!this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash")) {
            Log.e((String)LOG_TAG, (String)"No flash light is supported by current device!");
            return false;
        }
        if (!this.mIsCameraBackForward) {
            return false;
        }
        Camera.Parameters parameters = this.cameraInstance().getParams();
        if (parameters == null) {
            return false;
        }
        try {
            if (!parameters.getSupportedFlashModes().contains(mode)) {
                Log.e((String)LOG_TAG, (String)"Invalid Flash Light Mode!!!");
                return false;
            }
            parameters.setFlashMode(mode);
            this.cameraInstance().setParams(parameters);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Switch flash light failed, check if you're using front camera.");
            return false;
        }
        return true;
    }

    public synchronized void setFilterWithConfig(final String config) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraGLSurfaceView.this.mFrameRecorder != null) {
                    CameraGLSurfaceView.this.mFrameRecorder.setFilterWidthConfig(config);
                } else {
                    Log.e((String)CameraGLSurfaceView.LOG_TAG, (String)"setFilterWithConfig after release!!");
                }
            }
        });
    }

    public void setFilterIntensity(final float intensity) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraGLSurfaceView.this.mFrameRecorder != null) {
                    CameraGLSurfaceView.this.mFrameRecorder.setFilterIntensity(intensity);
                } else {
                    Log.e((String)CameraGLSurfaceView.LOG_TAG, (String)"setFilterIntensity after release!!");
                }
            }
        });
    }

    public void setMaskBitmap(Bitmap bmp, boolean shouldRecycle) {
        this.setMaskBitmap(bmp, shouldRecycle, null);
    }

    public void setMaskBitmap(final Bitmap bmp, final boolean shouldRecycle, final SetMaskBitmapCallback callback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraGLSurfaceView.this.mFrameRecorder == null) {
                    Log.e((String)CameraGLSurfaceView.LOG_TAG, (String)"setMaskBitmap after release!!");
                    return;
                }
                if (bmp == null) {
                    CameraGLSurfaceView.this.mFrameRecorder.setMaskTexture(0, 1.0f);
                    CameraGLSurfaceView.this.mIsUsingMask = false;
                    CameraGLSurfaceView.this.calcViewport();
                    return;
                }
                int texID = Common.genNormalTextureID(bmp, 9728, 33071);
                CameraGLSurfaceView.this.mFrameRecorder.setMaskTexture(texID, (float)bmp.getWidth() / (float)bmp.getHeight());
                CameraGLSurfaceView.this.mIsUsingMask = true;
                CameraGLSurfaceView.this.mMaskAspectRatio = (float)bmp.getWidth() / (float)bmp.getHeight();
                if (callback != null) {
                    callback.setMaskOK(CameraGLSurfaceView.this.mFrameRecorder);
                }
                if (shouldRecycle) {
                    bmp.recycle();
                }
                CameraGLSurfaceView.this.calcViewport();
            }
        });
    }

    public void setOnCreateCallback(final OnCreateCallback callback) {
        assert (callback != null) : "Invalid Operation!";
        if (this.mFrameRecorder == null) {
            this.mOnCreateCallback = callback;
        } else {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    callback.createOver(CameraGLSurfaceView.this.cameraInstance().getCameraDevice() != null);
                }
            });
        }
    }

    public CameraGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Log.i((String)LOG_TAG, (String)"MyGLSurfaceView Construct...");
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 8, 0);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.mClearColor = new ClearColor();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)LOG_TAG, (String)"onSurfaceCreated...");
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2960);
        GLES20.glBlendFunc((int)770, (int)771);
        int[] texSize = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])texSize, (int)0);
        this.mMaxTextureSize = texSize[0];
        this.mTextureID = Common.genSurfaceTextureID();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureID);
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mFrameRecorder = new CGEFrameRenderer();
        this.mIsTransformMatrixSet = false;
        if (!this.mFrameRecorder.init(this.mRecordWidth, this.mRecordHeight, this.mRecordWidth, this.mRecordHeight)) {
            Log.e((String)LOG_TAG, (String)"Frame Recorder init failed!");
        }
        this.mFrameRecorder.setSrcRotation(1.5707964f);
        this.mFrameRecorder.setSrcFlipScale(1.0f, -1.0f);
        this.mFrameRecorder.setRenderFlipScale(1.0f, -1.0f);
        this.requestRender();
        if (!this.cameraInstance().isCameraOpened()) {
            int facing;
            int n = facing = this.mIsCameraBackForward ? 0 : 1;
            if (!this.cameraInstance().tryOpenCamera(null, facing)) {
                Log.e((String)LOG_TAG, (String)"\u76f8\u673a\u542f\u52a8\u5931\u8d25!!");
            }
        }
        if (this.mOnCreateCallback != null) {
            this.mOnCreateCallback.createOver(this.cameraInstance().getCameraDevice() != null);
        }
    }

    protected void calcViewport() {
        int h;
        int w;
        float scaling = this.mIsUsingMask ? this.mMaskAspectRatio : (float)this.mRecordWidth / (float)this.mRecordHeight;
        float viewRatio = (float)this.mViewWidth / (float)this.mViewHeight;
        float s = scaling / viewRatio;
        if (this.mFitFullView) {
            if ((double)s > 1.0) {
                w = (int)((float)this.mViewHeight * scaling);
                h = this.mViewHeight;
            } else {
                w = this.mViewWidth;
                h = (int)((float)this.mViewWidth / scaling);
            }
        } else if ((double)s > 1.0) {
            w = this.mViewWidth;
            h = (int)((float)this.mViewWidth / scaling);
        } else {
            h = this.mViewHeight;
            w = (int)((float)this.mViewHeight * scaling);
        }
        this.mDrawViewport.width = w;
        this.mDrawViewport.height = h;
        this.mDrawViewport.x = (this.mViewWidth - this.mDrawViewport.width) / 2;
        this.mDrawViewport.y = (this.mViewHeight - this.mDrawViewport.height) / 2;
        Log.i((String)LOG_TAG, (String)String.format("View port: %d, %d, %d, %d", this.mDrawViewport.x, this.mDrawViewport.y, this.mDrawViewport.width, this.mDrawViewport.height));
    }

    public synchronized void release(final ReleaseOKCallback callback) {
        if (this.mFrameRecorder != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (CameraGLSurfaceView.this.mFrameRecorder != null) {
                        CameraGLSurfaceView.this.mFrameRecorder.release();
                        CameraGLSurfaceView.this.mFrameRecorder = null;
                        GLES20.glDeleteTextures((int)1, (int[])new int[]{CameraGLSurfaceView.this.mTextureID}, (int)0);
                        CameraGLSurfaceView.this.mTextureID = 0;
                        CameraGLSurfaceView.this.mSurfaceTexture.release();
                        CameraGLSurfaceView.this.mSurfaceTexture = null;
                        Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)"GLSurfaceview release...");
                        if (callback != null) {
                            callback.releaseOK();
                        }
                    }
                }
            });
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log.i((String)LOG_TAG, (String)String.format("onSurfaceChanged: %d x %d", width, height));
        GLES20.glClearColor((float)this.mClearColor.r, (float)this.mClearColor.g, (float)this.mClearColor.b, (float)this.mClearColor.a);
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.calcViewport();
        if (!this.cameraInstance().isPreviewing()) {
            this.cameraInstance().startPreview(this.mSurfaceTexture);
            this.mFrameRecorder.srcResize(this.cameraInstance().previewHeight(), this.cameraInstance().previewWidth());
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        super.surfaceDestroyed(holder);
        this.cameraInstance().stopCamera();
    }

    public void stopPreview() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                CameraGLSurfaceView.this.cameraInstance().stopPreview();
            }
        });
    }

    public synchronized void resumePreview() {
        if (this.mFrameRecorder == null) {
            Log.e((String)LOG_TAG, (String)"resumePreview after release!!");
            return;
        }
        if (!this.cameraInstance().isCameraOpened()) {
            int facing = this.mIsCameraBackForward ? 0 : 1;
            this.cameraInstance().tryOpenCamera(new CameraInstance.CameraOpenCallback(){

                @Override
                public void cameraReady() {
                    Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)"tryOpenCamera OK...");
                }
            }, facing);
        }
        if (!this.cameraInstance().isPreviewing()) {
            this.cameraInstance().startPreview(this.mSurfaceTexture);
            this.mFrameRecorder.srcResize(this.cameraInstance().previewHeight(), this.cameraInstance().previewWidth());
        }
        this.requestRender();
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mSurfaceTexture == null || !this.cameraInstance().isPreviewing()) {
            return;
        }
        this.mSurfaceTexture.updateTexImage();
        this.mSurfaceTexture.getTransformMatrix(this._transformMatrix);
        this.mFrameRecorder.update(this.mTextureID, this._transformMatrix);
        this.mFrameRecorder.runProc();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glClear((int)16384);
        GLES20.glEnable((int)3042);
        this.mFrameRecorder.render(this.mDrawViewport.x, this.mDrawViewport.y, this.mDrawViewport.width, this.mDrawViewport.height);
        GLES20.glDisable((int)3042);
    }

    public void onResume() {
        super.onResume();
        Log.i((String)LOG_TAG, (String)"glsurfaceview onResume...");
    }

    public void onPause() {
        Log.i((String)LOG_TAG, (String)"glsurfaceview onPause in...");
        this.cameraInstance().stopCamera();
        super.onPause();
        Log.i((String)LOG_TAG, (String)"glsurfaceview onPause out...");
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.requestRender();
        if (this.mLastTimestamp2 == 0L) {
            this.mLastTimestamp2 = System.currentTimeMillis();
        }
        long currentTimestamp = System.currentTimeMillis();
        ++this.mFramesCount2;
        this.mTimeCount2 += currentTimestamp - this.mLastTimestamp2;
        this.mLastTimestamp2 = currentTimestamp;
        if (this.mTimeCount2 >= 1000L) {
            Log.i((String)LOG_TAG, (String)String.format("camera sample rate: %d", this.mFramesCount2));
            this.mTimeCount2 %= 1000L;
            this.mFramesCount2 = 0L;
        }
    }

    public void takeShot(TakePictureCallback callback) {
        this.takeShot(callback, true);
    }

    public synchronized void takeShot(final TakePictureCallback callback, final boolean noMask) {
        assert (callback != null) : "callback must not be null!";
        if (this.mFrameRecorder == null) {
            Log.e((String)LOG_TAG, (String)"Recorder not initialized!");
            callback.takePictureOK(null);
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Bitmap bmp;
                int bufferTexID;
                FrameBufferObject frameBufferObject = new FrameBufferObject();
                if (noMask || !CameraGLSurfaceView.this.mIsUsingMask) {
                    bufferTexID = Common.genBlankTextureID(CameraGLSurfaceView.this.mRecordWidth, CameraGLSurfaceView.this.mRecordHeight);
                    frameBufferObject.bindTexture(bufferTexID);
                    GLES20.glViewport((int)0, (int)0, (int)CameraGLSurfaceView.this.mRecordWidth, (int)CameraGLSurfaceView.this.mRecordHeight);
                    CameraGLSurfaceView.this.mFrameRecorder.drawCache();
                    IntBuffer buffer = IntBuffer.allocate(CameraGLSurfaceView.this.mRecordWidth * CameraGLSurfaceView.this.mRecordHeight);
                    GLES20.glReadPixels((int)0, (int)0, (int)CameraGLSurfaceView.this.mRecordWidth, (int)CameraGLSurfaceView.this.mRecordHeight, (int)6408, (int)5121, (Buffer)buffer);
                    bmp = Bitmap.createBitmap((int)CameraGLSurfaceView.this.mRecordWidth, (int)CameraGLSurfaceView.this.mRecordHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bmp.copyPixelsFromBuffer((Buffer)buffer);
                    Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)String.format("w: %d, h: %d", CameraGLSurfaceView.this.mRecordWidth, CameraGLSurfaceView.this.mRecordHeight));
                } else {
                    bufferTexID = Common.genBlankTextureID(CameraGLSurfaceView.this.mDrawViewport.width, CameraGLSurfaceView.this.mDrawViewport.height);
                    frameBufferObject.bindTexture(bufferTexID);
                    int w = Math.min(CameraGLSurfaceView.this.mDrawViewport.width, CameraGLSurfaceView.this.mViewWidth);
                    int h = Math.min(CameraGLSurfaceView.this.mDrawViewport.height, CameraGLSurfaceView.this.mViewHeight);
                    CameraGLSurfaceView.this.mFrameRecorder.setRenderFlipScale(1.0f, 1.0f);
                    CameraGLSurfaceView.this.mFrameRecorder.setMaskTextureRatio(CameraGLSurfaceView.this.mMaskAspectRatio);
                    CameraGLSurfaceView.this.mFrameRecorder.render(0, 0, w, h);
                    CameraGLSurfaceView.this.mFrameRecorder.setRenderFlipScale(1.0f, -1.0f);
                    CameraGLSurfaceView.this.mFrameRecorder.setMaskTextureRatio(CameraGLSurfaceView.this.mMaskAspectRatio);
                    Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)String.format("w: %d, h: %d", w, h));
                    IntBuffer buffer = IntBuffer.allocate(w * h);
                    GLES20.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)buffer);
                    bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bmp.copyPixelsFromBuffer((Buffer)buffer);
                }
                frameBufferObject.release();
                GLES20.glDeleteTextures((int)1, (int[])new int[]{bufferTexID}, (int)0);
                callback.takePictureOK(bmp);
            }
        });
    }

    public void setPictureSize(int width, int height, boolean isBigger) {
        this.cameraInstance().setPictureSize(height, width, isBigger);
    }

    public synchronized void takePicture(final TakePictureCallback photoCallback, Camera.ShutterCallback shutterCallback, final String config, final float intensity, final boolean isFrontMirror) {
        Camera.Parameters params = this.cameraInstance().getParams();
        if (photoCallback == null || params == null) {
            Log.e((String)LOG_TAG, (String)"takePicture after release!");
            if (photoCallback != null) {
                photoCallback.takePictureOK(null);
            }
            return;
        }
        try {
            params.setRotation(90);
            this.cameraInstance().setParams(params);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error when takePicture: " + e.toString()));
            if (photoCallback != null) {
                photoCallback.takePictureOK(null);
            }
            return;
        }
        this.cameraInstance().getCameraDevice().takePicture(shutterCallback, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                Matrix mat;
                Canvas canvas;
                Bitmap bmp2;
                boolean shouldRotate;
                int height;
                int width;
                Bitmap bmp;
                Camera.Parameters params = camera.getParameters();
                Camera.Size sz = params.getPictureSize();
                if (sz.width != sz.height) {
                    bmp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    width = bmp.getWidth();
                    height = bmp.getHeight();
                    shouldRotate = sz.width > sz.height && width > height || sz.width < sz.height && width < height;
                } else {
                    Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)"Cache image to get exif.");
                    try {
                        String tmpFilename = CameraGLSurfaceView.this.getContext().getExternalCacheDir() + "/picture_cache000.jpg";
                        FileOutputStream fileout = new FileOutputStream(tmpFilename);
                        BufferedOutputStream bufferOutStream = new BufferedOutputStream(fileout);
                        bufferOutStream.write(data);
                        bufferOutStream.flush();
                        bufferOutStream.close();
                        ExifInterface exifInterface = new ExifInterface(tmpFilename);
                        int orientation = exifInterface.getAttributeInt("Orientation", 1);
                        switch (orientation) {
                            case 6: {
                                shouldRotate = true;
                                break;
                            }
                            default: {
                                shouldRotate = false;
                            }
                        }
                        bmp = BitmapFactory.decodeFile((String)tmpFilename);
                        width = bmp.getWidth();
                        height = bmp.getHeight();
                    }
                    catch (IOException e) {
                        Log.e((String)CameraGLSurfaceView.LOG_TAG, (String)"Err when saving bitmap...");
                        e.printStackTrace();
                        return;
                    }
                }
                if (width > CameraGLSurfaceView.this.mMaxTextureSize || height > CameraGLSurfaceView.this.mMaxTextureSize) {
                    float scaling = Math.max((float)width / (float)CameraGLSurfaceView.this.mMaxTextureSize, (float)height / (float)CameraGLSurfaceView.this.mMaxTextureSize);
                    Log.i((String)CameraGLSurfaceView.LOG_TAG, (String)String.format("\u76ee\u6807\u5c3a\u5bf8(%d x %d)\u8d85\u8fc7\u5f53\u524d\u8bbe\u5907OpenGL \u80fd\u591f\u5904\u7406\u7684\u6700\u5927\u8303\u56f4(%d x %d)\uff0c \u73b0\u5728\u5c06\u56fe\u7247\u538b\u7f29\u81f3\u5408\u7406\u5927\u5c0f!", width, height, CameraGLSurfaceView.this.mMaxTextureSize, CameraGLSurfaceView.this.mMaxTextureSize));
                    bmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)((int)((float)width / scaling)), (int)((int)((float)height / scaling)), (boolean)false);
                    width = bmp.getWidth();
                    height = bmp.getHeight();
                }
                if (shouldRotate) {
                    bmp2 = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    canvas = new Canvas(bmp2);
                    if (CameraGLSurfaceView.this.cameraInstance().getFacing() == 0) {
                        mat = new Matrix();
                        int halfLen = Math.min(width, height) / 2;
                        mat.setRotate(90.0f, (float)halfLen, (float)halfLen);
                        canvas.drawBitmap(bmp, mat, null);
                    } else {
                        mat = new Matrix();
                        if (isFrontMirror) {
                            mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                            mat.postScale(-1.0f, 1.0f);
                            mat.postTranslate((float)(width / 2), (float)(height / 2));
                            int halfLen = Math.min(width, height) / 2;
                            mat.postRotate(90.0f, (float)halfLen, (float)halfLen);
                        } else {
                            int halfLen = Math.max(width, height) / 2;
                            mat.postRotate(-90.0f, (float)halfLen, (float)halfLen);
                        }
                        canvas.drawBitmap(bmp, mat, null);
                    }
                    bmp.recycle();
                } else if (CameraGLSurfaceView.this.cameraInstance().getFacing() == 0) {
                    bmp2 = bmp;
                } else {
                    bmp2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    canvas = new Canvas(bmp2);
                    mat = new Matrix();
                    if (isFrontMirror) {
                        mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                        mat.postScale(1.0f, -1.0f);
                        mat.postTranslate((float)(width / 2), (float)(height / 2));
                    } else {
                        mat.postTranslate((float)(-width / 2), (float)(-height / 2));
                        mat.postScale(-1.0f, -1.0f);
                        mat.postTranslate((float)(width / 2), (float)(height / 2));
                    }
                    canvas.drawBitmap(bmp, mat, null);
                }
                if (config != null) {
                    CGENativeLibrary.filterImage_MultipleEffectsWriteBack(bmp2, config, intensity);
                }
                photoCallback.takePictureOK(bmp2);
                CameraGLSurfaceView.this.cameraInstance().getCameraDevice().startPreview();
            }
        });
    }

    public static interface TakePictureCallback {
        public void takePictureOK(Bitmap var1);
    }

    public static interface ReleaseOKCallback {
        public void releaseOK();
    }

    public static interface OnCreateCallback {
        public void createOver(boolean var1);
    }

    public static interface SetMaskBitmapCallback {
        public void setMaskOK(CGEFrameRenderer var1);
    }

    public class ClearColor {
        public float r;
        public float g;
        public float b;
        public float a;
    }
}

