/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.texUtils;

import android.opengl.GLES20;
import org.wysaid.texUtils.TextureRenderer;
import org.wysaid.texUtils.TextureRendererDrawOrigin;

public class TextureRendererMask
extends TextureRendererDrawOrigin {
    private static final String vshMask = "attribute vec2 vPosition;\nvarying vec2 texCoord;\nvarying vec2 maskCoord;\nuniform mat2 rotation;\nuniform vec2 flipScale;\nuniform mat2 maskRotation;\nuniform vec2 maskFlipScale;\nuniform mat4 transform;\nvoid main()\n{\n   gl_Position = vec4(vPosition, 0.0, 1.0);\n   vec2 coord = flipScale * (vPosition / 2.0 * rotation) + 0.5;\n   texCoord = (transform * vec4(coord, 0.0, 1.0)).xy;\n   maskCoord = maskFlipScale * (vPosition / 2.0 * maskRotation) + 0.5;\n}";
    private static final String fshMask = "precision mediump float;\nvarying vec2 texCoord;\nvarying vec2 maskCoord;\nuniform %s inputImageTexture;\nuniform sampler2D maskTexture;\nvoid main()\n{\n   gl_FragColor = texture2D(inputImageTexture, texCoord);\n   vec4 maskColor = texture2D(maskTexture, maskCoord);\n   gl_FragColor *= maskColor;\n}";
    protected static final String MASK_ROTATION_NAME = "maskRotation";
    protected static final String MASK_FLIPSCALE_NAME = "maskFlipScale";
    protected static final String MASK_TEXTURE_NAME = "maskTexture";
    protected int mMaskRotLoc;
    protected int mMaskFlipscaleLoc;
    protected int mMaskTexture;

    public static TextureRendererMask create(boolean isExternalOES) {
        TextureRendererMask renderer = new TextureRendererMask();
        if (!renderer.init(isExternalOES)) {
            renderer.release();
            return null;
        }
        return renderer;
    }

    @Override
    public boolean init(boolean isExternalOES) {
        if (this.setProgramDefault(this.getVertexShaderString(), this.getFragmentShaderString(), isExternalOES)) {
            this.mProgram.bind();
            this.mMaskRotLoc = this.mProgram.getUniformLoc(MASK_ROTATION_NAME);
            this.mMaskFlipscaleLoc = this.mProgram.getUniformLoc(MASK_FLIPSCALE_NAME);
            this.mProgram.sendUniformi(MASK_TEXTURE_NAME, 1);
            this.setMaskRotation(0.0f);
            this.setMaskFlipscale(1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void setMaskRotation(float rad) {
        float cosRad = (float)Math.cos(rad);
        float sinRad = (float)Math.sin(rad);
        float[] rot = new float[]{cosRad, sinRad, -sinRad, cosRad};
        assert (this.mProgram != null) : "setRotation must not be called before init!";
        this.mProgram.bind();
        GLES20.glUniformMatrix2fv((int)this.mMaskRotLoc, (int)1, (boolean)false, (float[])rot, (int)0);
    }

    public void setMaskFlipscale(float x, float y) {
        this.mProgram.bind();
        GLES20.glUniform2f((int)this.mMaskFlipscaleLoc, (float)x, (float)y);
    }

    public void setMaskTexture(int texID) {
        if (texID == this.mMaskTexture) {
            return;
        }
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mMaskTexture}, (int)0);
        this.mMaskTexture = texID;
    }

    @Override
    public void renderTexture(int texID, TextureRenderer.Viewport viewport) {
        if (viewport != null) {
            GLES20.glViewport((int)viewport.x, (int)viewport.y, (int)viewport.width, (int)viewport.height);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.TEXTURE_2D_BINDABLE, (int)texID);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mMaskTexture);
        GLES20.glBindBuffer((int)34962, (int)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        this.mProgram.bind();
        GLES20.glDrawArrays((int)6, (int)0, (int)4);
    }

    @Override
    public String getVertexShaderString() {
        return vshMask;
    }

    @Override
    public String getFragmentShaderString() {
        return fshMask;
    }

    @Override
    public void release() {
        super.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mMaskTexture}, (int)0);
    }
}

