/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.view;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import android.util.AttributeSet;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.wysaid.view.CameraGLSurfaceView;

public class CameraRecordGLSurfaceView
extends CameraGLSurfaceView {
    private boolean mShouldRecord = false;
    private final Object mRecordStateLock = new Object();
    private AudioRecordRunnable mAudioRecordRunnable;
    private Thread mAudioThread;

    public CameraRecordGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public synchronized boolean isRecording() {
        return this.mShouldRecord;
    }

    public void startRecording(String filename) {
        this.startRecording(filename, null);
    }

    public void startRecording(final String filename, final StartRecordingCallback recordingCallback) {
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CameraRecordGLSurfaceView.this.mFrameRecorder == null) {
                    Log.e((String)"libCGE_java", (String)"Error: startRecording after release!!");
                    if (recordingCallback != null) {
                        recordingCallback.startRecordingOver(false);
                    }
                    return;
                }
                if (!CameraRecordGLSurfaceView.this.mFrameRecorder.startRecording(30, filename)) {
                    Log.e((String)"libCGE_java", (String)"start recording failed!");
                    if (recordingCallback != null) {
                        recordingCallback.startRecordingOver(false);
                    }
                    return;
                }
                Log.i((String)"libCGE_java", (String)("glSurfaceView recording, file: " + filename));
                Object object = CameraRecordGLSurfaceView.this.mRecordStateLock;
                synchronized (object) {
                    CameraRecordGLSurfaceView.this.mShouldRecord = true;
                    CameraRecordGLSurfaceView.this.mAudioRecordRunnable = new AudioRecordRunnable(recordingCallback);
                    if (((CameraRecordGLSurfaceView)CameraRecordGLSurfaceView.this).mAudioRecordRunnable.audioRecord != null) {
                        CameraRecordGLSurfaceView.this.mAudioThread = new Thread(CameraRecordGLSurfaceView.this.mAudioRecordRunnable);
                        CameraRecordGLSurfaceView.this.mAudioThread.start();
                    }
                }
            }
        });
    }

    public void endRecording() {
        this.endRecording(null, true);
    }

    public void endRecording(EndRecordingCallback callback) {
        this.endRecording(callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRecording(final EndRecordingCallback callback, final boolean shouldSave) {
        Log.i((String)"libCGE_java", (String)"notify quit...");
        Object object = this.mRecordStateLock;
        synchronized (object) {
            this.mShouldRecord = false;
        }
        if (this.mFrameRecorder == null) {
            Log.e((String)"libCGE_java", (String)"Error: endRecording after release!!");
            return;
        }
        this.joinAudioRecording();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (CameraRecordGLSurfaceView.this.mFrameRecorder != null) {
                    CameraRecordGLSurfaceView.this.mFrameRecorder.endRecording(shouldSave);
                }
                if (callback != null) {
                    callback.endRecordingOK();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(CameraGLSurfaceView.ReleaseOKCallback callback) {
        Object object = this.mRecordStateLock;
        synchronized (object) {
            this.mShouldRecord = false;
        }
        this.joinAudioRecording();
        super.release(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPreview() {
        Object object = this.mRecordStateLock;
        synchronized (object) {
            if (this.mShouldRecord) {
                Log.e((String)"libCGE_java", (String)"The camera is recording! cannot stop!");
                return;
            }
        }
        super.stopPreview();
    }

    public void joinAudioRecording() {
        if (this.mAudioThread != null) {
            try {
                this.mAudioThread.join();
                this.mAudioThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AudioRecordRunnable
    implements Runnable {
        int bufferSize;
        int bufferReadResult;
        public AudioRecord audioRecord;
        public volatile boolean isInitialized;
        private static final int sampleRate = 44100;
        ByteBuffer audioBufferRef;
        ShortBuffer audioBuffer;
        StartRecordingCallback recordingCallback;

        private AudioRecordRunnable(StartRecordingCallback callback) {
            block3: {
                this.recordingCallback = callback;
                try {
                    this.bufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
                    Log.i((String)"libCGE_java", (String)("audio min buffer size: " + this.bufferSize));
                    this.audioRecord = new AudioRecord(1, 44100, 16, 2, this.bufferSize);
                    this.audioBufferRef = ByteBuffer.allocateDirect(this.bufferSize * 2).order(ByteOrder.nativeOrder());
                    this.audioBuffer = this.audioBufferRef.asShortBuffer();
                }
                catch (Exception e) {
                    if (this.audioRecord == null) break block3;
                    this.audioRecord.release();
                    this.audioRecord = null;
                }
            }
            if (this.audioRecord == null && this.recordingCallback != null) {
                this.recordingCallback.startRecordingOver(false);
                this.recordingCallback = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            this.isInitialized = false;
            if (this.audioRecord == null) {
                this.recordingCallback.startRecordingOver(false);
                this.recordingCallback = null;
                return;
            }
            while (this.audioRecord.getState() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException localInterruptedException) {
                    localInterruptedException.printStackTrace();
                }
            }
            this.isInitialized = true;
            try {
                this.audioRecord.startRecording();
            }
            catch (Exception e) {
                if (this.recordingCallback != null) {
                    this.recordingCallback.startRecordingOver(false);
                    this.recordingCallback = null;
                }
                return;
            }
            if (this.audioRecord.getRecordingState() != 3) {
                if (this.recordingCallback != null) {
                    this.recordingCallback.startRecordingOver(false);
                    this.recordingCallback = null;
                }
                return;
            }
            if (this.recordingCallback != null) {
                this.recordingCallback.startRecordingOver(true);
                this.recordingCallback = null;
            }
            while (true) {
                Object object = CameraRecordGLSurfaceView.this.mRecordStateLock;
                synchronized (object) {
                    if (!CameraRecordGLSurfaceView.this.mShouldRecord) {
                        break;
                    }
                }
                this.audioBufferRef.position(0);
                this.bufferReadResult = this.audioRecord.read(this.audioBufferRef, this.bufferSize * 2);
                if (!CameraRecordGLSurfaceView.this.mShouldRecord || this.bufferReadResult <= 0 || CameraRecordGLSurfaceView.this.mFrameRecorder == null || !(CameraRecordGLSurfaceView.this.mFrameRecorder.getTimestamp() > CameraRecordGLSurfaceView.this.mFrameRecorder.getAudioStreamtime())) continue;
                this.audioBuffer.position(0);
                CameraRecordGLSurfaceView.this.mFrameRecorder.recordAudioFrame(this.audioBuffer, this.bufferReadResult / 2);
            }
            this.audioRecord.stop();
            this.audioRecord.release();
            Log.i((String)"libCGE_java", (String)"Audio thread end!");
        }
    }

    public static interface EndRecordingCallback {
        public void endRecordingOK();
    }

    public static interface StartRecordingCallback {
        public void startRecordingOver(boolean var1);
    }
}

