/*
 * Decompiled with CFR 0.152.
 */
package org.wysaid.common;

import android.opengl.GLES20;
import android.util.Log;
import org.wysaid.common.Common;

public class ProgramObject {
    public static final String LOG_TAG = "libCGE_java";
    private int mProgramID;
    private ShaderObject mVertexShader;
    private ShaderObject mFragmentShader;

    public ProgramObject() {
        this.mProgramID = GLES20.glCreateProgram();
    }

    public ProgramObject(String vsh, String fsh) {
        this.init(vsh, fsh);
    }

    public int programID() {
        return this.mProgramID;
    }

    public final void release() {
        if (this.mProgramID != 0) {
            GLES20.glDeleteProgram((int)this.mProgramID);
            this.mProgramID = 0;
        }
    }

    public boolean init(String vsh, String fsh) {
        return this.init(vsh, fsh, this.mProgramID);
    }

    public boolean init(String vsh, String fsh, int programID) {
        if (programID == 0 && (programID = GLES20.glCreateProgram()) == 0) {
            Log.e((String)LOG_TAG, (String)"Invalid Program ID! Check if the context is bound!");
            return false;
        }
        if (this.mVertexShader != null) {
            this.mVertexShader.release();
        }
        if (this.mFragmentShader != null) {
            this.mFragmentShader.release();
        }
        this.mVertexShader = new ShaderObject(vsh, 35633);
        this.mFragmentShader = new ShaderObject(fsh, 35632);
        GLES20.glAttachShader((int)programID, (int)this.mVertexShader.shaderID());
        GLES20.glAttachShader((int)programID, (int)this.mFragmentShader.shaderID());
        Common.checkGLError("AttachShaders...");
        GLES20.glLinkProgram((int)programID);
        int[] programStatus = new int[]{0};
        GLES20.glGetProgramiv((int)programID, (int)35714, (int[])programStatus, (int)0);
        this.mVertexShader.release();
        this.mFragmentShader.release();
        this.mVertexShader = null;
        this.mFragmentShader = null;
        if (programStatus[0] != 1) {
            String msg = GLES20.glGetProgramInfoLog((int)programID);
            Log.e((String)LOG_TAG, (String)msg);
            return false;
        }
        if (this.mProgramID != programID && this.mProgramID != 0) {
            GLES20.glDeleteProgram((int)this.mProgramID);
        }
        this.mProgramID = programID;
        return true;
    }

    public void bind() {
        GLES20.glUseProgram((int)this.mProgramID);
    }

    public int getUniformLoc(String name) {
        int uniform = GLES20.glGetUniformLocation((int)this.mProgramID, (String)name);
        if (uniform < 0) {
            Log.e((String)LOG_TAG, (String)String.format("uniform name %s does not exist", name));
        }
        return uniform;
    }

    public void sendUniformf(String name, float x) {
        GLES20.glUniform1f((int)this.getUniformLoc(name), (float)x);
    }

    public void sendUniformf(String name, float x, float y) {
        GLES20.glUniform2f((int)this.getUniformLoc(name), (float)x, (float)y);
    }

    public void sendUniformf(String name, float x, float y, float z) {
        GLES20.glUniform3f((int)this.getUniformLoc(name), (float)x, (float)y, (float)z);
    }

    public void sendUniformf(String name, float x, float y, float z, float w) {
        GLES20.glUniform4f((int)this.getUniformLoc(name), (float)x, (float)y, (float)z, (float)w);
    }

    public void sendUniformi(String name, int x) {
        GLES20.glUniform1i((int)this.getUniformLoc(name), (int)x);
    }

    public void sendUniformi(String name, int x, int y) {
        GLES20.glUniform2i((int)this.getUniformLoc(name), (int)x, (int)y);
    }

    public void sendUniformi(String name, int x, int y, int z) {
        GLES20.glUniform3i((int)this.getUniformLoc(name), (int)x, (int)y, (int)z);
    }

    public void sendUniformi(String name, int x, int y, int z, int w) {
        GLES20.glUniform4i((int)this.getUniformLoc(name), (int)x, (int)y, (int)z, (int)w);
    }

    public void sendUniformMat2(String name, int count, boolean transpose, float[] matrix) {
        GLES20.glUniformMatrix2fv((int)this.getUniformLoc(name), (int)count, (boolean)transpose, (float[])matrix, (int)0);
    }

    public void sendUniformMat3(String name, int count, boolean transpose, float[] matrix) {
        GLES20.glUniformMatrix3fv((int)this.getUniformLoc(name), (int)count, (boolean)transpose, (float[])matrix, (int)0);
    }

    public void sendUniformMat4(String name, int count, boolean transpose, float[] matrix) {
        GLES20.glUniformMatrix4fv((int)this.getUniformLoc(name), (int)count, (boolean)transpose, (float[])matrix, (int)0);
    }

    public int attributeLocation(String name) {
        return GLES20.glGetAttribLocation((int)this.mProgramID, (String)name);
    }

    public void bindAttribLocation(String name, int index) {
        GLES20.glBindAttribLocation((int)this.mProgramID, (int)index, (String)name);
    }

    public static class ShaderObject {
        private int mShaderType;
        private int mShaderID;

        public int shaderID() {
            return this.mShaderID;
        }

        public ShaderObject() {
            this.mShaderType = 0;
            this.mShaderID = 0;
        }

        public ShaderObject(String shaderCode, int shaderType) {
            this.init(shaderCode, shaderType);
        }

        public boolean init(String shaderCode, int shaderType) {
            this.mShaderType = shaderType;
            this.mShaderID = ShaderObject.loadShader(shaderType, shaderCode);
            assert (this.mShaderID != 0) : "Shader Create Failed!";
            if (this.mShaderID == 0) {
                Log.e((String)ProgramObject.LOG_TAG, (String)"glCreateShader Failed!...");
                return false;
            }
            return true;
        }

        public final void release() {
            if (this.mShaderID == 0) {
                return;
            }
            GLES20.glDeleteShader((int)this.mShaderID);
            this.mShaderID = 0;
        }

        public static int loadShader(int type, String code) {
            int shaderID = GLES20.glCreateShader((int)type);
            if (shaderID != 0) {
                GLES20.glShaderSource((int)shaderID, (String)code);
                GLES20.glCompileShader((int)shaderID);
                int[] compiled = new int[]{0};
                GLES20.glGetShaderiv((int)shaderID, (int)35713, (int[])compiled, (int)0);
                if (compiled[0] != 1) {
                    String errMsg = GLES20.glGetShaderInfoLog((int)shaderID);
                    Log.e((String)ProgramObject.LOG_TAG, (String)errMsg);
                    GLES20.glDeleteShader((int)shaderID);
                    return 0;
                }
            }
            return shaderID;
        }
    }
}

