/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.sql.analyzer;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.sql.SQLErrorCode$InvalidArgument$;
import wvlet.airframe.sql.SQLErrorCode$SyntaxError$;
import wvlet.airframe.sql.analyzer.AnalyzerContext;
import wvlet.airframe.sql.analyzer.RewriteRule;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveAggregationIndexes$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveAggregationKeys$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveCTETableRef$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveColumns$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveJoinUsing$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveRegularRelation$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveSortItemIndexes$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveSortItems$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveSubquery$;
import wvlet.airframe.sql.analyzer.TypeResolver$resolveTableRef$;
import wvlet.airframe.sql.model.Attribute;
import wvlet.airframe.sql.model.ColumnPath;
import wvlet.airframe.sql.model.ColumnPath$;
import wvlet.airframe.sql.model.Expression;
import wvlet.airframe.sql.model.LogicalPlan;
import wvlet.airframe.sql.model.NodeLocation;
import wvlet.airframe.sql.model.ResolvedAttribute;
import wvlet.airframe.sql.model.SourceColumn;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TypeResolver$
implements LogSupport {
    public static final TypeResolver$ MODULE$ = new TypeResolver$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        TypeResolver$ typeResolver$ = this;
        synchronized (typeResolver$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public List<RewriteRule> typerRules() {
        TypeResolver$resolveCTETableRef$ typeResolver$resolveCTETableRef$ = TypeResolver$resolveCTETableRef$.MODULE$;
        TypeResolver$resolveTableRef$ typeResolver$resolveTableRef$ = TypeResolver$resolveTableRef$.MODULE$;
        TypeResolver$resolveJoinUsing$ typeResolver$resolveJoinUsing$ = TypeResolver$resolveJoinUsing$.MODULE$;
        TypeResolver$resolveSubquery$ typeResolver$resolveSubquery$ = TypeResolver$resolveSubquery$.MODULE$;
        TypeResolver$resolveRegularRelation$ typeResolver$resolveRegularRelation$ = TypeResolver$resolveRegularRelation$.MODULE$;
        TypeResolver$resolveColumns$ typeResolver$resolveColumns$ = TypeResolver$resolveColumns$.MODULE$;
        TypeResolver$resolveAggregationIndexes$ typeResolver$resolveAggregationIndexes$ = TypeResolver$resolveAggregationIndexes$.MODULE$;
        TypeResolver$resolveAggregationKeys$ typeResolver$resolveAggregationKeys$ = TypeResolver$resolveAggregationKeys$.MODULE$;
        TypeResolver$resolveSortItemIndexes$ typeResolver$resolveSortItemIndexes$ = TypeResolver$resolveSortItemIndexes$.MODULE$;
        TypeResolver$resolveSortItems$ typeResolver$resolveSortItems$ = TypeResolver$resolveSortItems$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)typeResolver$resolveSortItems$).$colon$colon((Object)typeResolver$resolveSortItemIndexes$).$colon$colon((Object)typeResolver$resolveAggregationKeys$).$colon$colon((Object)typeResolver$resolveAggregationIndexes$).$colon$colon((Object)typeResolver$resolveColumns$).$colon$colon((Object)typeResolver$resolveRegularRelation$).$colon$colon((Object)typeResolver$resolveSubquery$).$colon$colon((Object)typeResolver$resolveJoinUsing$).$colon$colon((Object)typeResolver$resolveTableRef$).$colon$colon((Object)typeResolver$resolveCTETableRef$);
    }

    public LogicalPlan resolve(AnalyzerContext analyzerContext, LogicalPlan plan) {
        return this.resolve(analyzerContext, plan, this.typerRules());
    }

    public LogicalPlan resolve(AnalyzerContext analyzerContext, LogicalPlan plan, List<RewriteRule> rules) {
        LogicalPlan resolvedPlan = (LogicalPlan)rules.foldLeft((Object)plan, (Function2 & Serializable)(targetPlan, rule) -> rule.transform((LogicalPlan)targetPlan, analyzerContext));
        return resolvedPlan;
    }

    public LogicalPlan.Relation resolveRelation(AnalyzerContext analyzerContext, LogicalPlan plan) {
        LogicalPlan resolvedPlan = this.resolve(analyzerContext, plan);
        LogicalPlan logicalPlan = resolvedPlan;
        if (logicalPlan instanceof LogicalPlan.Relation) {
            LogicalPlan.Relation relation = (LogicalPlan.Relation)logicalPlan;
            return relation;
        }
        throw SQLErrorCode$InvalidArgument$.MODULE$.newException(new StringBuilder(17).append(plan).append(" isn't a relation").toString(), plan.nodeLocation());
    }

    public Seq<Attribute> wvlet$airframe$sql$analyzer$TypeResolver$$resolveOutputColumns(AnalyzerContext context, Seq<Attribute> inputAttributes, Seq<Attribute> outputColumns) {
        Builder resolvedColumns = package$.MODULE$.Seq().newBuilder();
        outputColumns.map((Function1 & Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (attribute instanceof Expression.Alias) {
                Expression resolved;
                Expression.Alias alias = (Expression.Alias)attribute;
                Expression expr = alias.expr();
                if (expr == (resolved = MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$resolveExpression(context, expr, inputAttributes))) {
                    return (Builder)resolvedColumns.$plus$eq((Object)alias);
                }
                Expression x$1 = resolved;
                Option<String> x$2 = alias.copy$default$1();
                String x$3 = alias.copy$default$2();
                Option<NodeLocation> x$4 = alias.copy$default$4();
                return (Builder)resolvedColumns.$plus$eq((Object)alias.copy(x$2, x$3, x$1, x$4));
            }
            if (attribute instanceof Expression.SingleColumn) {
                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                Expression expr = singleColumn.expr();
                Option<String> qualifier = singleColumn.qualifier();
                Expression expression = MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$resolveExpression(context, expr, inputAttributes);
                if (expression instanceof Attribute) {
                    Attribute attribute2 = (Attribute)expression;
                    return (Builder)resolvedColumns.$plus$eq((Object)attribute2.setQualifierIfEmpty(qualifier));
                }
                return (Builder)resolvedColumns.$plus$eq((Object)singleColumn.copy(expression, singleColumn.copy$default$2(), singleColumn.copy$default$3()));
            }
            return (Builder)resolvedColumns.$plus$eq((Object)attribute);
        });
        Seq output = (Seq)((IterableOps)resolvedColumns.result()).map((Function1 & Serializable)attribute -> MODULE$.resolveAttribute((Attribute)attribute));
        return output;
    }

    public Attribute resolveAttribute(Attribute attribute) {
        Expression.Alias alias;
        Expression attr;
        Attribute attribute2 = attribute;
        if (attribute2 instanceof Expression.Alias && (attr = (alias = (Expression.Alias)attribute2).expr()) instanceof Attribute) {
            Attribute attribute3 = (Attribute)attr;
            Attribute resolved = this.resolveAttribute(attribute3);
            if (attribute3 == resolved) {
                return alias;
            }
            Attribute x$1 = resolved;
            Option<String> x$2 = alias.copy$default$1();
            String x$3 = alias.copy$default$2();
            Option<NodeLocation> x$4 = alias.copy$default$4();
            return alias.copy(x$2, x$3, x$1, x$4);
        }
        if (attribute2 instanceof Expression.SingleColumn) {
            Attribute attribute4;
            Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute2;
            Expression a = singleColumn.expr();
            Option<String> qualifier = singleColumn.qualifier();
            if (a instanceof Attribute && (attribute4 = (Attribute)a).resolved()) {
                return attribute4.setQualifierIfEmpty(qualifier);
            }
        }
        if (attribute2 instanceof Expression.MultiSourceColumn) {
            Expression.MultiSourceColumn multiSourceColumn = (Expression.MultiSourceColumn)attribute2;
            BooleanRef changed = BooleanRef.create((boolean)false);
            Seq resolvedInputs = (Seq)multiSourceColumn.inputs().map((Function1 & Serializable)x0$1 -> {
                Expression expression = x0$1;
                if (expression instanceof Attribute) {
                    Attribute attribute = (Attribute)expression;
                    Attribute x = MODULE$.resolveAttribute(attribute);
                    if (x != attribute) {
                        changed$2.elem = true;
                    }
                    return x;
                }
                return expression;
            });
            if (changed.elem) {
                return multiSourceColumn.copy((Seq<Expression>)resolvedInputs, multiSourceColumn.copy$default$2(), multiSourceColumn.copy$default$3());
            }
            return multiSourceColumn;
        }
        return attribute2;
    }

    public Attribute wvlet$airframe$sql$analyzer$TypeResolver$$toResolvedAttribute(String name, Expression expr) {
        Expression expression = expr;
        if (expression instanceof Expression.Alias) {
            Expression.Alias alias = (Expression.Alias)expression;
            return new ResolvedAttribute(alias.name(), alias.expr().dataType(), alias.qualifier(), (Option<SourceColumn>)this.findSourceColumn$1(alias.expr()), alias.nodeLocation());
        }
        if (expression instanceof Expression.SingleColumn) {
            Expression.SingleColumn singleColumn = (Expression.SingleColumn)expression;
            return new ResolvedAttribute(name, singleColumn.dataType(), singleColumn.qualifier(), (Option<SourceColumn>)this.findSourceColumn$1(singleColumn.expr()), singleColumn.nodeLocation());
        }
        if (expression instanceof Attribute) {
            Attribute attribute = (Attribute)expression;
            return attribute;
        }
        return new ResolvedAttribute(name, expression.dataType(), (Option<String>)None$.MODULE$, (Option<SourceColumn>)this.findSourceColumn$1(expr), expression.nodeLocation());
    }

    public List<Expression> wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        BoxedUnit boxedUnit;
        .colon.colon results;
        Expression.AllColumns allColumns;
        Option<Seq<Attribute>> option;
        .colon.colon colon2;
        Seq resolvedAttributes = (Seq)inputAttributes.map((Function1 & Serializable)attribute -> MODULE$.resolveAttribute((Attribute)attribute));
        Expression expression = expr;
        if (expression instanceof Expression.Identifier) {
            Expression.Identifier identifier = (Expression.Identifier)expression;
            colon2 = (List)TypeResolver$.lookup$1(identifier.value(), context, resolvedAttributes).map((Function1 & Serializable)x$5 -> MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$toResolvedAttribute(identifier.value(), (Expression)x$5)).distinct();
        } else if (expression instanceof Expression.UnresolvedAttribute) {
            Expression.UnresolvedAttribute unresolvedAttribute = (Expression.UnresolvedAttribute)expression;
            Option<String> qualifier = unresolvedAttribute.qualifier();
            String name = unresolvedAttribute.name();
            colon2 = (List)TypeResolver$.lookup$1(unresolvedAttribute.fullName(), context, resolvedAttributes).map((Function1 & Serializable)x$6 -> MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$toResolvedAttribute(name, (Expression)x$6).setQualifierIfEmpty(qualifier)).distinct();
        } else if (expression instanceof Expression.AllColumns && None$.MODULE$.equals(option = (allColumns = (Expression.AllColumns)expression).columns())) {
            Seq allColumns2 = (Seq)resolvedAttributes.map((Function1 & Serializable)x0$1 -> {
                Attribute attribute = x0$1;
                if (attribute != null) {
                    Attribute attribute2 = attribute;
                    return attribute2;
                }
                return MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$toResolvedAttribute(attribute.name(), attribute);
            });
            Some x$1 = new Some((Object)allColumns2);
            Option<String> x$2 = allColumns.copy$default$1();
            Option<NodeLocation> x$3 = allColumns.copy$default$3();
            .colon.colon colon3 = new .colon.colon((Object)allColumns.copy(x$2, (Option<Seq<Attribute>>)x$1, x$3), (List)Nil$.MODULE$);
            colon2 = colon3;
        } else {
            colon2 = results = new .colon.colon((Object)expr, (List)Nil$.MODULE$);
        }
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 434, 10), (Object)new StringBuilder(73).append("[findMatchInInputAttributes]\n - input:  ").append(expr).append("\n - output: ").append(results.mkString(", ")).append("\n[inputAttributes]:\n ").append(inputAttributes.mkString("\n ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return results;
    }

    public Expression wvlet$airframe$sql$analyzer$TypeResolver$$resolveExpression(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        List<Expression> list = this.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(context, expr, inputAttributes);
        if (list.length() > 1) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 451, 14), (Object)new StringBuilder(17).append(expr).append(" is ambiguous in ").append(list).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw SQLErrorCode$SyntaxError$.MODULE$.newException(new StringBuilder(13).append(expr.sqlExpr()).append(" is ambiguous").toString(), expr.nodeLocation());
        }
        return (Expression)list.headOption().getOrElse((Function0 & Serializable)() -> expr);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TypeResolver$.class);
    }

    private final Option findSourceColumn$1(Expression e) {
        while (true) {
            Expression expression;
            if ((expression = e) instanceof ResolvedAttribute) {
                ResolvedAttribute resolvedAttribute = (ResolvedAttribute)expression;
                return resolvedAttribute.sourceColumn();
            }
            if (!(expression instanceof Expression.Alias)) break;
            Expression.Alias alias = (Expression.Alias)expression;
            e = alias.expr();
        }
        return None$.MODULE$;
    }

    private static final List lookup$1(String name, AnalyzerContext context$10, Seq resolvedAttributes$1) {
        Builder resolvedExprs = package$.MODULE$.List().newBuilder();
        Option<ColumnPath> option = ColumnPath$.MODULE$.fromQName(context$10.database(), name);
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnPath columnPath = (ColumnPath)some.value();
            resolvedAttributes$1.foreach((Function1 & Serializable)x0$1 -> {
                Attribute attribute = x0$1;
                if (attribute != null) {
                    Attribute attribute2 = attribute;
                    return resolvedExprs.$plus$plus$eq(attribute2.matched(columnPath));
                }
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        return (List)resolvedExprs.result();
    }

    private TypeResolver$() {
    }
}

