/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt;
import scala.runtime.RichLong$;
import scala.runtime.RichShort;
import wvlet.airframe.msgpack.spi.Code$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_EXT_FORMAT$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_TYPE$;
import wvlet.airframe.msgpack.spi.ErrorCode$NEVER_USED_FORMAT$;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.MessageException;
import wvlet.airframe.msgpack.spi.MessageException$;
import wvlet.airframe.msgpack.spi.MessageFormat;
import wvlet.airframe.msgpack.spi.MessageFormat$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY16$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN16$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN8$;
import wvlet.airframe.msgpack.spi.MessageFormat$BOOLEAN$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXARRAY$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT1$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT2$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT4$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXMAP$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXSTR$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP16$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP32$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEGFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEVER_USED$;
import wvlet.airframe.msgpack.spi.MessageFormat$NIL$;
import wvlet.airframe.msgpack.spi.MessageFormat$POSFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR16$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR32$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR8$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT8$;
import wvlet.airframe.msgpack.spi.ReadBuffer;
import wvlet.airframe.msgpack.spi.ReadCursor;
import wvlet.airframe.msgpack.spi.TooLargeMessageException;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.Value$NilValue$;
import wvlet.airframe.msgpack.spi.ValueType;
import wvlet.airframe.msgpack.spi.ValueType$ARRAY$;
import wvlet.airframe.msgpack.spi.ValueType$BINARY$;
import wvlet.airframe.msgpack.spi.ValueType$BOOLEAN$;
import wvlet.airframe.msgpack.spi.ValueType$EXTENSION$;
import wvlet.airframe.msgpack.spi.ValueType$FLOAT$;
import wvlet.airframe.msgpack.spi.ValueType$INTEGER$;
import wvlet.airframe.msgpack.spi.ValueType$MAP$;
import wvlet.airframe.msgpack.spi.ValueType$NIL$;
import wvlet.airframe.msgpack.spi.ValueType$STRING$;
import wvlet.airframe.msgpack.spi.WriteBuffer;

public final class OffsetUnpacker$ {
    public static final OffsetUnpacker$ MODULE$;
    private final String EMPTY_STRING;

    static {
        new OffsetUnpacker$();
    }

    /*
     * WARNING - void declaration
     */
    public MessageFormat peekNextFormat(ReadCursor cursor) {
        void var3_3;
        byte b = cursor.peekByte();
        MessageFormat mf = MessageFormat$.MODULE$.of(b);
        return var3_3;
    }

    public void skipValue(ReadCursor cursor, int skipCount) {
        for (int count = skipCount; count > 0; --count) {
            BoxedUnit boxedUnit;
            byte b = cursor.readByte();
            MessageFormat mf = MessageFormat$.MODULE$.of(b);
            MessageFormat messageFormat = mf;
            boolean bl = MessageFormat$POSFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$NEGFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$BOOLEAN$.MODULE$.equals(messageFormat) ? true : MessageFormat$NIL$.MODULE$.equals(messageFormat)));
            if (bl) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXMAP$.MODULE$.equals(messageFormat)) {
                int mapLen = b & 0xF;
                count += mapLen * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXARRAY$.MODULE$.equals(messageFormat)) {
                int arrayLen = b & 0xF;
                count += arrayLen;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXSTR$.MODULE$.equals(messageFormat)) {
                int strLen = b & 0x1F;
                this.skipPayload(cursor, strLen);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl2 = MessageFormat$INT8$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT8$.MODULE$.equals(messageFormat);
            if (bl2) {
                this.skipPayload(cursor, 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl3 = MessageFormat$INT16$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT16$.MODULE$.equals(messageFormat);
            if (bl3) {
                this.skipPayload(cursor, 2);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl4 = MessageFormat$INT32$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT32$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT32$.MODULE$.equals(messageFormat));
            if (bl4) {
                this.skipPayload(cursor, 4);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl5 = MessageFormat$INT64$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT64$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT64$.MODULE$.equals(messageFormat));
            if (bl5) {
                this.skipPayload(cursor, 8);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl6 = MessageFormat$BIN8$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR8$.MODULE$.equals(messageFormat);
            if (bl6) {
                this.skipPayload(cursor, this.readNextLength8(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl7 = MessageFormat$BIN16$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR16$.MODULE$.equals(messageFormat);
            if (bl7) {
                this.skipPayload(cursor, this.readNextLength16(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl8 = MessageFormat$BIN32$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR32$.MODULE$.equals(messageFormat);
            if (bl8) {
                this.skipPayload(cursor, this.readNextLength32(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT1$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 2);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT2$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 3);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT4$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 5);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 9);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 17);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength8(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength16(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT32$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength32(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$ARRAY16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$ARRAY32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$MAP16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor) * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$MAP32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor) * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$NEVER_USED$.MODULE$.equals(messageFormat)) {
                throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found 0xC1 (NEVER_USED) byte while skipping a value"})).s((Seq)Nil$.MODULE$), MessageException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)messageFormat);
        }
    }

    public int skipValue$default$2() {
        return 1;
    }

    public void skipPayload(ReadCursor cursor, int numBytes) {
        cursor.skipBytes(numBytes);
    }

    public Value unpackValue(ReadCursor cursor) {
        ValueType valueType;
        block13: {
            Value value;
            block5: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        MessageFormat mf;
                                        block6: {
                                            block4: {
                                                byte b = cursor.peekByte();
                                                mf = MessageFormat$.MODULE$.of(b);
                                                valueType = mf.valueType();
                                                if (!ValueType$NIL$.MODULE$.equals(valueType)) break block4;
                                                cursor.skipBytes(1);
                                                value = Value$NilValue$.MODULE$;
                                                break block5;
                                            }
                                            if (!ValueType$BOOLEAN$.MODULE$.equals(valueType)) break block6;
                                            value = new Value.BooleanValue(this.unpackBoolean(cursor));
                                            break block5;
                                        }
                                        if (!ValueType$INTEGER$.MODULE$.equals(valueType)) break block7;
                                        MessageFormat messageFormat = mf;
                                        Product product = MessageFormat$UINT64$.MODULE$.equals(messageFormat) ? new Value.BigIntegerValue(this.unpackBigInteger(cursor)) : new Value.LongValue(this.unpackLong(cursor));
                                        value = product;
                                        break block5;
                                    }
                                    if (!ValueType$FLOAT$.MODULE$.equals(valueType)) break block8;
                                    value = new Value.DoubleValue(this.unpackDouble(cursor));
                                    break block5;
                                }
                                if (!ValueType$STRING$.MODULE$.equals(valueType)) break block9;
                                value = new Value.StringValue(this.unpackString(cursor));
                                break block5;
                            }
                            if (!ValueType$BINARY$.MODULE$.equals(valueType)) break block10;
                            int binaryLength = this.unpackBinaryHeader(cursor);
                            byte[] data = this.readPayload(cursor, binaryLength);
                            value = new Value.BinaryValue(data);
                            break block5;
                        }
                        if (!ValueType$EXTENSION$.MODULE$.equals(valueType)) break block11;
                        ExtTypeHeader extHeader = this.unpackExtTypeHeader(cursor);
                        value = this.unpackExt(extHeader, cursor);
                        break block5;
                    }
                    if (!ValueType$ARRAY$.MODULE$.equals(valueType)) break block12;
                    int arrayLength = this.unpackArrayHeader(cursor);
                    Builder arr = package$.MODULE$.IndexedSeq().newBuilder();
                    arr.sizeHint(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        arr.$plus$eq((Object)this.unpackValue(cursor));
                    }
                    value = new Value.ArrayValue((IndexedSeq<Value>)((IndexedSeq)arr.result()));
                    break block5;
                }
                if (!ValueType$MAP$.MODULE$.equals(valueType)) break block13;
                boolean readLen = false;
                int mapLength = this.unpackMapHeader(cursor);
                Builder map = ListMap$.MODULE$.newBuilder();
                map.sizeHint(mapLength);
                for (int i = 0; i < mapLength; ++i) {
                    Value key = this.unpackValue(cursor);
                    Value value2 = this.unpackValue(cursor);
                    map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value2));
                }
                value = new Value.MapValue((Map<Value, Value>)((Map)map.result()));
            }
            return value;
        }
        throw new MatchError((Object)valueType);
    }

    public Value unpackExt(ExtTypeHeader extHeader, ReadCursor cursor) {
        Product product;
        if (extHeader.extType() == Code$.MODULE$.EXT_TIMESTAMP()) {
            Instant instant = this.unpackTimestamp(extHeader, cursor);
            product = new Value.TimestampValue(instant);
        } else {
            byte[] extData = this.readPayload(cursor, extHeader.byteLength());
            product = new Value.ExtensionValue(extHeader.extType(), extData);
        }
        return product;
    }

    public void unpackNil(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() == by) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$NIL$.MODULE$, by);
    }

    public boolean tryUnpackNil(ReadCursor cursor) {
        boolean bl;
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() == by) {
            bl = true;
        } else {
            cursor.reverseCursor();
            bl = false;
        }
        return bl;
    }

    public boolean unpackBoolean(ReadCursor cursor) {
        byte by;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    by = cursor.readByte();
                    if (Code$.MODULE$.FALSE() != by) break block2;
                    bl = false;
                    break block3;
                }
                if (Code$.MODULE$.TRUE() != by) break block4;
                bl = true;
            }
            return bl;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$BOOLEAN$.MODULE$, by);
    }

    /*
     * WARNING - void declaration
     */
    public byte unpackByte(ReadCursor cursor) {
        void var2_2;
        block18: {
            void var13_12;
            block19: {
                byte by;
                block5: {
                    byte by2;
                    block16: {
                        void var12_11;
                        block17: {
                            block14: {
                                void var11_10;
                                block15: {
                                    block13: {
                                        byte i8;
                                        block11: {
                                            void var8_8;
                                            block12: {
                                                block9: {
                                                    void var7_7;
                                                    block10: {
                                                        block7: {
                                                            void var6_6;
                                                            block8: {
                                                                block6: {
                                                                    block4: {
                                                                        byte b = cursor.readByte();
                                                                        by2 = b;
                                                                        if (!Code$.MODULE$.isFixInt(by2)) break block4;
                                                                        by = by2;
                                                                        break block5;
                                                                    }
                                                                    if (Code$.MODULE$.UINT8() != by2) break block6;
                                                                    byte u8 = cursor.readByte();
                                                                    if (u8 < 0) {
                                                                        throw MessageException$.MODULE$.overflowU8(u8);
                                                                    }
                                                                    by = u8;
                                                                    break block5;
                                                                }
                                                                if (Code$.MODULE$.UINT16() != by2) break block7;
                                                                short u16 = cursor.readShort();
                                                                if (u16 < 0 || !new RichShort(Predef$.MODULE$.shortWrapper(u16)).isValidByte()) break block8;
                                                                by = (byte)u16;
                                                                break block5;
                                                            }
                                                            throw MessageException$.MODULE$.overflowU16((short)var6_6);
                                                        }
                                                        if (Code$.MODULE$.UINT32() != by2) break block9;
                                                        int u32 = cursor.readInt();
                                                        if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidByte()) break block10;
                                                        by = (byte)u32;
                                                        break block5;
                                                    }
                                                    throw MessageException$.MODULE$.overflowU32((int)var7_7);
                                                }
                                                if (Code$.MODULE$.UINT64() != by2) break block11;
                                                long u64 = cursor.readLong();
                                                if (u64 < 0L || !RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(u64))) break block12;
                                                by = (byte)u64;
                                                break block5;
                                            }
                                            throw MessageException$.MODULE$.overflowU64((long)var8_8);
                                        }
                                        if (Code$.MODULE$.INT8() != by2) break block13;
                                        by = i8 = cursor.readByte();
                                        break block5;
                                    }
                                    if (Code$.MODULE$.INT16() != by2) break block14;
                                    short i16 = cursor.readShort();
                                    if (!new RichShort(Predef$.MODULE$.shortWrapper(i16)).isValidByte()) break block15;
                                    by = (byte)i16;
                                    break block5;
                                }
                                throw MessageException$.MODULE$.overflowI16((short)var11_10);
                            }
                            if (Code$.MODULE$.INT32() != by2) break block16;
                            int i32 = cursor.readInt();
                            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidByte()) break block17;
                            by = (byte)i32;
                            break block5;
                        }
                        throw MessageException$.MODULE$.overflowI32((int)var12_11);
                    }
                    if (Code$.MODULE$.INT64() != by2) break block18;
                    long i64 = cursor.readLong();
                    if (!RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(i64))) break block19;
                    by = (byte)i64;
                }
                return by;
            }
            throw MessageException$.MODULE$.overflowI64((long)var13_12);
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public short unpackShort(ReadCursor cursor) {
        void var2_2;
        block16: {
            void var13_12;
            block17: {
                short s;
                block5: {
                    short s2;
                    block14: {
                        void var12_11;
                        block15: {
                            block13: {
                                short i16;
                                block12: {
                                    block10: {
                                        void var8_8;
                                        block11: {
                                            block8: {
                                                void var7_7;
                                                block9: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                short b = cursor.readByte();
                                                                s2 = b;
                                                                if (!Code$.MODULE$.isFixInt((byte)s2)) break block4;
                                                                s = s2;
                                                                break block5;
                                                            }
                                                            if (Code$.MODULE$.UINT8() != s2) break block6;
                                                            byte u8 = cursor.readByte();
                                                            s = (short)(u8 & 0xFF);
                                                            break block5;
                                                        }
                                                        if (Code$.MODULE$.UINT16() != s2) break block7;
                                                        short u16 = cursor.readShort();
                                                        if (u16 < 0) {
                                                            throw MessageException$.MODULE$.overflowU16(u16);
                                                        }
                                                        s = u16;
                                                        break block5;
                                                    }
                                                    if (Code$.MODULE$.UINT32() != s2) break block8;
                                                    int u32 = cursor.readInt();
                                                    if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidShort()) break block9;
                                                    s = (short)u32;
                                                    break block5;
                                                }
                                                throw MessageException$.MODULE$.overflowU32((int)var7_7);
                                            }
                                            if (Code$.MODULE$.UINT64() != s2) break block10;
                                            long u64 = cursor.readLong();
                                            if (u64 < 0L || !RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(u64))) break block11;
                                            s = (short)u64;
                                            break block5;
                                        }
                                        throw MessageException$.MODULE$.overflowU64((long)var8_8);
                                    }
                                    if (Code$.MODULE$.INT8() != s2) break block12;
                                    byte i8 = cursor.readByte();
                                    s = i8;
                                    break block5;
                                }
                                if (Code$.MODULE$.INT16() != s2) break block13;
                                s = i16 = cursor.readShort();
                                break block5;
                            }
                            if (Code$.MODULE$.INT32() != s2) break block14;
                            int i32 = cursor.readInt();
                            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidShort()) break block15;
                            s = (short)i32;
                            break block5;
                        }
                        throw MessageException$.MODULE$.overflowI32((int)var12_11);
                    }
                    if (Code$.MODULE$.INT64() != s2) break block16;
                    long i64 = cursor.readLong();
                    if (!RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(i64))) break block17;
                    s = (short)i64;
                }
                return s;
            }
            throw MessageException$.MODULE$.overflowI64((long)var13_12);
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int unpackInt(ReadCursor cursor) {
        void var2_2;
        block14: {
            void var13_12;
            block15: {
                int n;
                block5: {
                    int n2;
                    block13: {
                        int i32;
                        block12: {
                            block11: {
                                block9: {
                                    void var8_8;
                                    block10: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block4: {
                                                        int b = cursor.readByte();
                                                        n2 = b;
                                                        if (!Code$.MODULE$.isFixInt((byte)n2)) break block4;
                                                        n = n2;
                                                        break block5;
                                                    }
                                                    if (Code$.MODULE$.UINT8() != n2) break block6;
                                                    byte u8 = cursor.readByte();
                                                    n = u8 & 0xFF;
                                                    break block5;
                                                }
                                                if (Code$.MODULE$.UINT16() != n2) break block7;
                                                short u16 = cursor.readShort();
                                                n = u16 & 0xFFFF;
                                                break block5;
                                            }
                                            if (Code$.MODULE$.UINT32() != n2) break block8;
                                            int u32 = cursor.readInt();
                                            if (u32 < 0) {
                                                throw MessageException$.MODULE$.overflowU32(u32);
                                            }
                                            n = u32;
                                            break block5;
                                        }
                                        if (Code$.MODULE$.UINT64() != n2) break block9;
                                        long u64 = cursor.readLong();
                                        if (u64 < 0L || !RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(u64))) break block10;
                                        n = (int)u64;
                                        break block5;
                                    }
                                    throw MessageException$.MODULE$.overflowU64((long)var8_8);
                                }
                                if (Code$.MODULE$.INT8() != n2) break block11;
                                byte i8 = cursor.readByte();
                                n = i8;
                                break block5;
                            }
                            if (Code$.MODULE$.INT16() != n2) break block12;
                            short i16 = cursor.readShort();
                            n = i16;
                            break block5;
                        }
                        if (Code$.MODULE$.INT32() != n2) break block13;
                        n = i32 = cursor.readInt();
                        break block5;
                    }
                    if (Code$.MODULE$.INT64() != n2) break block14;
                    long i64 = cursor.readLong();
                    if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(i64))) break block15;
                    n = (int)i64;
                }
                return n;
            }
            throw MessageException$.MODULE$.overflowI64((long)var13_12);
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public long unpackLong(ReadCursor cursor) {
        void var2_2;
        block13: {
            long l;
            block5: {
                long i64;
                byte by;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                byte b = cursor.readByte();
                                                by = b;
                                                if (!Code$.MODULE$.isFixInt(by)) break block4;
                                                l = by;
                                                break block5;
                                            }
                                            if (Code$.MODULE$.UINT8() != by) break block6;
                                            byte u8 = cursor.readByte();
                                            l = u8 & 0xFF;
                                            break block5;
                                        }
                                        if (Code$.MODULE$.UINT16() != by) break block7;
                                        short u16 = cursor.readShort();
                                        l = u16 & 0xFFFF;
                                        break block5;
                                    }
                                    if (Code$.MODULE$.UINT32() != by) break block8;
                                    int u32 = cursor.readInt();
                                    l = u32 < 0 ? (long)(u32 & Integer.MAX_VALUE) + 0x80000000L : (long)u32;
                                    break block5;
                                }
                                if (Code$.MODULE$.UINT64() != by) break block9;
                                long u64 = cursor.readLong();
                                if (u64 < 0L) {
                                    throw MessageException$.MODULE$.overflowU64(u64);
                                }
                                l = u64;
                                break block5;
                            }
                            if (Code$.MODULE$.INT8() != by) break block10;
                            byte i8 = cursor.readByte();
                            l = i8;
                            break block5;
                        }
                        if (Code$.MODULE$.INT16() != by) break block11;
                        short i16 = cursor.readShort();
                        l = i16;
                        break block5;
                    }
                    if (Code$.MODULE$.INT32() != by) break block12;
                    int i32 = cursor.readInt();
                    l = i32;
                    break block5;
                }
                if (Code$.MODULE$.INT64() != by) break block13;
                l = i64 = cursor.readLong();
            }
            return l;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger unpackBigInteger(ReadCursor cursor) {
        void var2_2;
        block11: {
            BigInteger bigInteger;
            block3: {
                byte by;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                byte b = cursor.readByte();
                                                by = b;
                                                if (!Code$.MODULE$.isFixInt(by)) break block2;
                                                bigInteger = BigInteger.valueOf(by);
                                                break block3;
                                            }
                                            if (Code$.MODULE$.UINT8() != by) break block4;
                                            byte u8 = cursor.readByte();
                                            bigInteger = BigInteger.valueOf(u8 & 0xFF);
                                            break block3;
                                        }
                                        if (Code$.MODULE$.UINT16() != by) break block5;
                                        short u16 = cursor.readShort();
                                        bigInteger = BigInteger.valueOf(u16 & 0xFFFF);
                                        break block3;
                                    }
                                    if (Code$.MODULE$.UINT32() != by) break block6;
                                    int u32 = cursor.readInt();
                                    bigInteger = u32 < 0 ? BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L) : BigInteger.valueOf(u32);
                                    break block3;
                                }
                                if (Code$.MODULE$.UINT64() != by) break block7;
                                long u64 = cursor.readLong();
                                bigInteger = u64 < 0L ? BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63) : BigInteger.valueOf(u64);
                                break block3;
                            }
                            if (Code$.MODULE$.INT8() != by) break block8;
                            byte i8 = cursor.readByte();
                            bigInteger = BigInteger.valueOf(i8);
                            break block3;
                        }
                        if (Code$.MODULE$.INT16() != by) break block9;
                        short i16 = cursor.readShort();
                        bigInteger = BigInteger.valueOf(i16);
                        break block3;
                    }
                    if (Code$.MODULE$.INT32() != by) break block10;
                    int i32 = cursor.readInt();
                    bigInteger = BigInteger.valueOf(i32);
                    break block3;
                }
                if (Code$.MODULE$.INT64() != by) break block11;
                long i64 = cursor.readLong();
                bigInteger = BigInteger.valueOf(i64);
            }
            return bigInteger;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)var2_2);
    }

    public float unpackFloat(ReadCursor cursor) {
        byte by;
        block4: {
            float f;
            block3: {
                block2: {
                    float f2;
                    by = cursor.readByte();
                    if (Code$.MODULE$.FLOAT32() != by) break block2;
                    f = f2 = cursor.readFloat();
                    break block3;
                }
                if (Code$.MODULE$.FLOAT64() != by) break block4;
                double d = cursor.readDouble();
                f = (float)d;
            }
            return f;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
    }

    public double unpackDouble(ReadCursor cursor) {
        byte by;
        block4: {
            double d;
            block3: {
                double d2;
                block2: {
                    by = cursor.readByte();
                    if (Code$.MODULE$.FLOAT32() != by) break block2;
                    float f = cursor.readFloat();
                    d = f;
                    break block3;
                }
                if (Code$.MODULE$.FLOAT64() != by) break block4;
                d = d2 = cursor.readDouble();
            }
            return d;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
    }

    private int readNextLength8(ReadCursor cursor) {
        byte u8 = cursor.readByte();
        return u8 & 0xFF;
    }

    private int readNextLength16(ReadCursor cursor) {
        short u16 = cursor.readShort();
        return u16 & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    private int readNextLength32(ReadCursor cursor) {
        void var2_2;
        int u32 = cursor.readInt();
        if (u32 < 0) {
            cursor.reverseCursor();
            throw MessageException$.MODULE$.overflowU32Size(u32);
        }
        return (int)var2_2;
    }

    private int tryReadStringHeader(byte b, ReadCursor cursor) {
        byte by = b;
        int n = Code$.MODULE$.STR8() == by ? this.readNextLength8(cursor) : (Code$.MODULE$.STR16() == by ? this.readNextLength16(cursor) : (Code$.MODULE$.STR32() == by ? this.readNextLength32(cursor) : -1));
        return n;
    }

    private int tryReadBinaryHeader(byte b, ReadCursor cursor) {
        byte by = b;
        int n = Code$.MODULE$.BIN8() == by ? this.readNextLength8(cursor) : (Code$.MODULE$.BIN16() == by ? this.readNextLength16(cursor) : (Code$.MODULE$.BIN32() == by ? this.readNextLength32(cursor) : -1));
        return n;
    }

    public int unpackRawStringHeader(ReadCursor cursor) {
        byte b;
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        b = cursor.readByte();
                        if (!Code$.MODULE$.isFixedRaw(b)) break block2;
                        n = b & 0x1F;
                        break block3;
                    }
                    int slen = this.tryReadStringHeader(b, cursor);
                    if (slen < 0) break block4;
                    n = slen;
                    break block3;
                }
                int blen = this.tryReadBinaryHeader(b, cursor);
                if (blen < 0) break block5;
                n = blen;
            }
            return n;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$STRING$.MODULE$, b);
    }

    public int unpackBinaryHeader(ReadCursor cursor) {
        byte b;
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        b = cursor.readByte();
                        if (!Code$.MODULE$.isFixedRaw(b)) break block2;
                        n = b & 0x1F;
                        break block3;
                    }
                    int blen = this.tryReadBinaryHeader(b, cursor);
                    if (blen < 0) break block4;
                    n = blen;
                    break block3;
                }
                int slen = this.tryReadStringHeader(b, cursor);
                if (slen < 0) break block5;
                n = slen;
            }
            return n;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$BINARY$.MODULE$, b);
    }

    public String unpackString(ReadCursor cursor) {
        String string;
        int len = this.unpackRawStringHeader(cursor);
        int headerLen = cursor.lastReadLength();
        if (len == 0) {
            string = this.EMPTY_STRING();
        } else {
            if (len >= Integer.MAX_VALUE) {
                cursor.reverseCursor();
                throw new TooLargeMessageException(len);
            }
            byte[] str = cursor.readBytes(len);
            string = new String(str, 0, str.length, StandardCharsets.UTF_8);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public int unpackArrayHeader(ReadCursor cursor) {
        void var2_2;
        block5: {
            int n;
            block3: {
                int len;
                byte by;
                block4: {
                    int len2;
                    block2: {
                        byte b = cursor.readByte();
                        by = b;
                        if (!Code$.MODULE$.isFixedArray(by)) break block2;
                        n = by & 0xF;
                        break block3;
                    }
                    if (Code$.MODULE$.ARRAY16() != by) break block4;
                    n = len2 = this.readNextLength16(cursor);
                    break block3;
                }
                if (Code$.MODULE$.ARRAY32() != by) break block5;
                n = len = this.readNextLength32(cursor);
            }
            return n;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$ARRAY$.MODULE$, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int unpackMapHeader(ReadCursor cursor) {
        void var2_2;
        block5: {
            int n;
            block3: {
                int len;
                byte by;
                block4: {
                    int len2;
                    block2: {
                        byte b = cursor.readByte();
                        by = b;
                        if (!Code$.MODULE$.isFixedMap(by)) break block2;
                        n = by & 0xF;
                        break block3;
                    }
                    if (Code$.MODULE$.MAP16() != by) break block4;
                    n = len2 = this.readNextLength16(cursor);
                    break block3;
                }
                if (Code$.MODULE$.MAP32() != by) break block5;
                n = len = this.readNextLength32(cursor);
            }
            return n;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$MAP$.MODULE$, (byte)var2_2);
    }

    public ExtTypeHeader unpackExtTypeHeader(ReadCursor cursor) {
        byte by;
        block12: {
            ExtTypeHeader extTypeHeader;
            block5: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            by = cursor.readByte();
                                            if (Code$.MODULE$.FIXEXT1() != by) break block4;
                                            byte tpe = cursor.readByte();
                                            extTypeHeader = new ExtTypeHeader(tpe, 1);
                                            break block5;
                                        }
                                        if (Code$.MODULE$.FIXEXT2() != by) break block6;
                                        byte tpe = cursor.readByte();
                                        extTypeHeader = new ExtTypeHeader(tpe, 2);
                                        break block5;
                                    }
                                    if (Code$.MODULE$.FIXEXT4() != by) break block7;
                                    byte tpe = cursor.readByte();
                                    extTypeHeader = new ExtTypeHeader(tpe, 4);
                                    break block5;
                                }
                                if (Code$.MODULE$.FIXEXT8() != by) break block8;
                                byte tpe = cursor.readByte();
                                extTypeHeader = new ExtTypeHeader(tpe, 8);
                                break block5;
                            }
                            if (Code$.MODULE$.FIXEXT16() != by) break block9;
                            byte tpe = cursor.readByte();
                            extTypeHeader = new ExtTypeHeader(tpe, 16);
                            break block5;
                        }
                        if (Code$.MODULE$.EXT8() != by) break block10;
                        byte u8 = cursor.readByte();
                        int len = u8 & 0xFF;
                        byte tpe = cursor.readByte();
                        extTypeHeader = new ExtTypeHeader(tpe, len);
                        break block5;
                    }
                    if (Code$.MODULE$.EXT16() != by) break block11;
                    short u16 = cursor.readShort();
                    int len = u16 & 0xFFFF;
                    byte tpe = cursor.readByte();
                    extTypeHeader = new ExtTypeHeader(tpe, len);
                    break block5;
                }
                if (Code$.MODULE$.EXT32() != by) break block12;
                int u32 = cursor.readInt();
                if (u32 < 0) {
                    cursor.reverseCursor();
                    throw MessageException$.MODULE$.overflowU32Size(u32);
                }
                byte tpe = cursor.readByte();
                extTypeHeader = new ExtTypeHeader(tpe, u32);
            }
            return extTypeHeader;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$EXTENSION$.MODULE$, by);
    }

    /*
     * WARNING - void declaration
     */
    public Instant unpackTimestamp(ReadCursor cursor) {
        void var3_3;
        ExtTypeHeader extTypeHeader = this.unpackExtTypeHeader(cursor);
        Instant instant = this.unpackTimestamp(extTypeHeader, cursor);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Instant unpackTimestamp(ExtTypeHeader extTypeHeader, ReadCursor cursor) {
        void var3_10;
        Instant instant;
        if (extTypeHeader.extType() != Code$.MODULE$.EXT_TIMESTAMP()) {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$EXTENSION$.MODULE$, extTypeHeader.extType());
        }
        int n = extTypeHeader.byteLength();
        switch (n) {
            default: {
                cursor.reverseCursor();
                throw new MessageException(ErrorCode$INVALID_EXT_FORMAT$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp type expects 4, 8, or 12 bytes of payload but got ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), MessageException$.MODULE$.$lessinit$greater$default$3());
            }
            case 12: {
                long nsecU32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                long sec = cursor.readLong();
                instant = Instant.ofEpochSecond(sec, nsecU32);
                break;
            }
            case 8: {
                long d64 = cursor.readLong();
                long sec = d64 & 0x3FFFFFFFFL;
                int nsec = (int)(d64 >>> 34);
                instant = Instant.ofEpochSecond(sec, nsec);
                break;
            }
            case 4: {
                long u32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                instant = Instant.ofEpochSecond(u32);
            }
        }
        Instant instant2 = instant;
        return var3_10;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readPayload(ReadCursor cursor, int length) {
        void var3_3;
        byte[] data = cursor.readBytes(length);
        return var3_3;
    }

    public void readPayload(ReadCursor cursor, int length, byte[] dest, int destOffset) {
        cursor.readBytes(length, dest, destOffset);
    }

    public ReadBuffer readPayload(ReadCursor cursor, int length, WriteBuffer dest, int destIndex) {
        cursor.readBytes(length, dest, destIndex);
        return dest.slice(destIndex, length);
    }

    private String EMPTY_STRING() {
        return this.EMPTY_STRING;
    }

    public Nothing$ unexpected(ValueType expectedCode, byte actual) {
        MessageFormat f;
        MessageFormat messageFormat = f = MessageFormat$.MODULE$.of(actual);
        MessageFormat$NEVER_USED$ messageFormat$NEVER_USED$ = MessageFormat$NEVER_USED$.MODULE$;
        if (!(messageFormat != null ? !messageFormat.equals(messageFormat$NEVER_USED$) : messageFormat$NEVER_USED$ != null)) {
            throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", ", but found 0xC1 (NEVER_USED) byte"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedCode})), MessageException$.MODULE$.$lessinit$greater$default$3());
        }
        String name = f.valueType().name();
        String typeName = new StringBuilder().append((Object)name.substring(0, 1)).append((Object)name.substring(1).toLowerCase()).toString();
        ValueType arg$macro$1 = expectedCode;
        String arg$macro$2 = typeName;
        byte arg$macro$3 = actual;
        throw new MessageException(ErrorCode$INVALID_TYPE$.MODULE$, new StringOps("Expected %s, but got %s (%02x)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToByte((byte)arg$macro$3)})), MessageException$.MODULE$.$lessinit$greater$default$3());
    }

    private OffsetUnpacker$() {
        MODULE$ = this;
        this.EMPTY_STRING = "";
    }
}

