/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import wvlet.airframe.msgpack.spi.Code$;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.Value$NilValue$;
import wvlet.airframe.msgpack.spi.WriteCursor;

public final class OffsetPacker$ {
    public static final OffsetPacker$ MODULE$;
    private final long NANOS_PER_SECOND;

    static {
        new OffsetPacker$();
    }

    public void packValue(WriteCursor cursor, Value v) {
        Value value;
        block13: {
            block3: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        value = v;
                                                        if (!Value$NilValue$.MODULE$.equals(value)) break block2;
                                                        this.packNil(cursor);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(value instanceof Value.BooleanValue)) break block4;
                                                    Value.BooleanValue booleanValue = (Value.BooleanValue)value;
                                                    boolean v2 = booleanValue.v();
                                                    this.packBoolean(cursor, v2);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(value instanceof Value.LongValue)) break block5;
                                                Value.LongValue longValue = (Value.LongValue)value;
                                                long v3 = longValue.v();
                                                this.packLong(cursor, v3);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(value instanceof Value.BigIntegerValue)) break block6;
                                            Value.BigIntegerValue bigIntegerValue = (Value.BigIntegerValue)value;
                                            BigInteger v4 = bigIntegerValue.v();
                                            this.packBigInteger(cursor, v4);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(value instanceof Value.DoubleValue)) break block7;
                                        Value.DoubleValue doubleValue = (Value.DoubleValue)value;
                                        double v5 = doubleValue.v();
                                        this.packDouble(cursor, v5);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(value instanceof Value.StringValue)) break block8;
                                    Value.StringValue stringValue = (Value.StringValue)value;
                                    String v6 = stringValue.v();
                                    this.packString(cursor, v6);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(value instanceof Value.BinaryValue)) break block9;
                                Value.BinaryValue binaryValue = (Value.BinaryValue)value;
                                byte[] v7 = binaryValue.v();
                                this.packBinaryHeader(cursor, v7.length);
                                this.writePayload(cursor, v7);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(value instanceof Value.ExtensionValue)) break block10;
                            Value.ExtensionValue extensionValue = (Value.ExtensionValue)value;
                            byte extType = extensionValue.extType();
                            byte[] v8 = extensionValue.v();
                            this.packExtTypeHeader(cursor, extType, v8.length);
                            this.writePayload(cursor, v8);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(value instanceof Value.TimestampValue)) break block11;
                        Value.TimestampValue timestampValue = (Value.TimestampValue)value;
                        Instant v9 = timestampValue.v();
                        this.packTimestamp(cursor, v9);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(value instanceof Value.ArrayValue)) break block12;
                    Value.ArrayValue arrayValue = (Value.ArrayValue)value;
                    IndexedSeq<Value> elems = arrayValue.elems();
                    this.packArrayHeader(cursor, arrayValue.size());
                    elems.foreach((Function1)new Serializable(cursor){
                        public static final long serialVersionUID = 0L;
                        private final WriteCursor cursor$1;

                        public final void apply(Value x$1) {
                            OffsetPacker$.MODULE$.packValue(this.cursor$1, x$1);
                        }
                        {
                            this.cursor$1 = cursor$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(value instanceof Value.MapValue)) break block13;
                Value.MapValue mapValue = (Value.MapValue)value;
                Map<Value, Value> entries = mapValue.entries();
                this.packMapHeader(cursor, mapValue.size());
                entries.toIndexedSeq().foreach((Function1)new Serializable(cursor){
                    public static final long serialVersionUID = 0L;
                    private final WriteCursor cursor$1;

                    public final void apply(Tuple2<Value, Value> x) {
                        OffsetPacker$.MODULE$.packValue(this.cursor$1, (Value)x._1());
                        OffsetPacker$.MODULE$.packValue(this.cursor$1, (Value)x._2());
                    }
                    {
                        this.cursor$1 = cursor$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    public void packNil(WriteCursor cursor) {
        cursor.writeByte(Code$.MODULE$.NIL());
    }

    public void packBoolean(WriteCursor cursor, boolean v) {
        cursor.writeByte(v ? Code$.MODULE$.TRUE() : Code$.MODULE$.FALSE());
    }

    public void packFIXNUM(WriteCursor cursor, byte v) {
        cursor.writeByte(v);
    }

    public void packINT8(WriteCursor cursor, byte v) {
        cursor.writeByteAndByte(Code$.MODULE$.INT8(), v);
    }

    public void packINT16(WriteCursor cursor, short v) {
        cursor.writeByteAndShort(Code$.MODULE$.INT16(), v);
    }

    public void packINT32(WriteCursor cursor, int v) {
        cursor.writeByteAndInt(Code$.MODULE$.INT32(), v);
    }

    public void packINT64(WriteCursor cursor, long v) {
        cursor.writeByteAndLong(Code$.MODULE$.INT64(), v);
    }

    public void packUINT8(WriteCursor cursor, byte v) {
        cursor.writeByteAndByte(Code$.MODULE$.UINT8(), v);
    }

    public void packUINT16(WriteCursor cursor, short v) {
        cursor.writeByteAndShort(Code$.MODULE$.UINT16(), v);
    }

    public void packUINT32(WriteCursor cursor, int v) {
        cursor.writeByteAndInt(Code$.MODULE$.UINT32(), v);
    }

    public void packUINT64(WriteCursor cursor, long v) {
        cursor.writeByteAndLong(Code$.MODULE$.UINT64(), v);
    }

    public void packFLOAT32(WriteCursor cursor, float v) {
        cursor.writeByteAndFloat(Code$.MODULE$.FLOAT32(), v);
    }

    public void packFLOAT64(WriteCursor cursor, double v) {
        cursor.writeByteAndDouble(Code$.MODULE$.FLOAT64(), v);
    }

    public void packByte(WriteCursor cursor, byte v) {
        if (v < -32) {
            this.packINT8(cursor, v);
        } else {
            this.packFIXNUM(cursor, v);
        }
    }

    public void packShort(WriteCursor cursor, short v) {
        if (v < -32) {
            if (v < -128) {
                this.packINT16(cursor, v);
            } else {
                this.packINT8(cursor, (byte)v);
            }
        } else if (v < 128) {
            cursor.writeByte((byte)v);
        } else if (v < 256) {
            this.packUINT8(cursor, (byte)v);
        } else {
            this.packUINT16(cursor, v);
        }
    }

    public void packInt(WriteCursor cursor, int r) {
        if (r < -32) {
            if (r < -32768) {
                this.packINT32(cursor, r);
            } else if (r < -128) {
                this.packINT16(cursor, (short)r);
            } else {
                this.packINT8(cursor, (byte)r);
            }
        } else if (r < 128) {
            this.packFIXNUM(cursor, (byte)r);
        } else if (r < 256) {
            this.packUINT8(cursor, (byte)r);
        } else if (r < 65536) {
            this.packUINT16(cursor, (short)r);
        } else {
            this.packUINT32(cursor, r);
        }
    }

    public void packLong(WriteCursor cursor, long v) {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < -0x80000000L) {
                    this.packINT64(cursor, v);
                } else {
                    this.packINT32(cursor, (int)v);
                }
            } else if (v < (long)(-128)) {
                this.packINT16(cursor, (short)v);
            } else {
                this.packINT8(cursor, (byte)v);
            }
        } else if (v < 128L) {
            this.packFIXNUM(cursor, (byte)v);
        } else if (v < 65536L) {
            if (v < 256L) {
                this.packUINT8(cursor, (byte)v);
            } else {
                this.packUINT16(cursor, (short)v);
            }
        } else if (v < 0x100000000L) {
            this.packUINT32(cursor, (int)v);
        } else {
            this.packUINT64(cursor, v);
        }
    }

    public void packBigInteger(WriteCursor cursor, BigInteger bi) {
        block4: {
            block3: {
                block2: {
                    if (bi.bitLength() > 63) break block2;
                    this.packLong(cursor, bi.longValue());
                    break block3;
                }
                if (bi.bitLength() != 64 || bi.signum() != 1) break block4;
                this.packUINT64(cursor, bi.longValue());
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MessagePack cannot serialize BigInteger larger than 2^64-1: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bi})));
    }

    public void packFloat(WriteCursor cursor, float v) {
        this.packFLOAT32(cursor, v);
    }

    public void packDouble(WriteCursor cursor, double v) {
        this.packFLOAT64(cursor, v);
    }

    public void packString(WriteCursor cursor, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.packRawStringHeader(cursor, bytes.length);
        this.writePayload(cursor, bytes);
    }

    public void packTimestamp(WriteCursor cursor, Instant v) {
        this.packTimestampEpochSecond(cursor, v.getEpochSecond(), v.getNano());
    }

    private long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public void packTimestampEpochSecond(WriteCursor cursor, long epochSecond, int nanoAdjustment) {
        long sec = Math.addExact(epochSecond, Math.floorDiv((long)nanoAdjustment, this.NANOS_PER_SECOND()));
        long nsec = Math.floorMod((long)nanoAdjustment, this.NANOS_PER_SECOND());
        if (sec >>> 34 == 0L) {
            long data64 = nsec << 34 | sec;
            if ((data64 & 0xFFFFFFFF00000000L) == 0L) {
                this.packTimestamp32(cursor, (int)sec);
            } else {
                this.packTimestamp64(cursor, data64);
            }
        } else {
            this.packTimestamp96(cursor, sec, (int)nsec);
        }
    }

    public void packTimestamp32(WriteCursor cursor, int sec) {
        cursor.ensureCapacity(6);
        cursor.writeByte(Code$.MODULE$.FIXEXT4());
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeInt(sec);
    }

    public void packTimestamp64(WriteCursor cursor, long data64) {
        cursor.ensureCapacity(10);
        cursor.writeByte(Code$.MODULE$.FIXEXT8());
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeLong(data64);
    }

    public void packTimestamp96(WriteCursor cursor, long sec, int nsec) {
        cursor.ensureCapacity(15);
        cursor.writeByte(Code$.MODULE$.EXT8());
        cursor.writeByte((byte)12);
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeInt(nsec);
        cursor.writeLong(sec);
    }

    public void packRawStringHeader(WriteCursor cursor, int len) {
        if (len < 32) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXSTR_PREFIX() | len));
        } else if (len < 256) {
            cursor.writeByteAndByte(Code$.MODULE$.STR8(), (byte)len);
        } else if (len < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.STR16(), (short)len);
        } else {
            cursor.writeByteAndInt(Code$.MODULE$.STR32(), len);
        }
    }

    public void packArrayHeader(WriteCursor cursor, int arraySize) {
        if (arraySize < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (arraySize < 16) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXARRAY_PREFIX() | arraySize));
        } else if (arraySize < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.ARRAY16(), (short)arraySize);
        } else {
            cursor.writeByteAndInt(Code$.MODULE$.ARRAY32(), arraySize);
        }
    }

    public void packArray32Header(WriteCursor cursor, int arraySize) {
        cursor.writeByteAndInt(Code$.MODULE$.ARRAY32(), arraySize);
    }

    public void packMapHeader(WriteCursor cursor, int mapSize) {
        if (mapSize < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (mapSize < 16) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXMAP_PREFIX() | mapSize));
        } else if (mapSize < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.MAP16(), (short)mapSize);
        } else {
            cursor.writeByteAndInt(Code$.MODULE$.MAP32(), mapSize);
        }
    }

    public void packMap32Header(WriteCursor cursor, int mapSize) {
        cursor.writeByteAndInt(Code$.MODULE$.MAP32(), mapSize);
    }

    public void packExtTypeHeader(WriteCursor cursor, ExtTypeHeader extTypeHeader) {
        this.packExtTypeHeader(cursor, extTypeHeader.extType(), extTypeHeader.byteLength());
    }

    public void packExtTypeHeader(WriteCursor cursor, byte extType, int payloadLen) {
        if (payloadLen < 256) {
            if (payloadLen > 0 && (payloadLen & payloadLen - 1) == 0) {
                if (payloadLen == 1) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT1(), extType);
                } else if (payloadLen == 2) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT2(), extType);
                } else if (payloadLen == 4) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT4(), extType);
                } else if (payloadLen == 8) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT8(), extType);
                } else if (payloadLen == 16) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT16(), extType);
                } else {
                    cursor.writeByteAndByte(Code$.MODULE$.EXT8(), (byte)payloadLen);
                    cursor.writeByte(extType);
                }
            } else {
                cursor.writeByteAndByte(Code$.MODULE$.EXT8(), (byte)payloadLen);
                cursor.writeByte(extType);
            }
        } else if (payloadLen < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.EXT16(), (short)payloadLen);
            cursor.writeByte(extType);
        } else {
            cursor.writeByteAndInt(Code$.MODULE$.EXT32(), payloadLen);
            cursor.writeByte(extType);
        }
    }

    public void packBinaryHeader(WriteCursor cursor, int len) {
        if (len < 256) {
            cursor.writeByteAndByte(Code$.MODULE$.BIN8(), (byte)len);
        } else if (len < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.BIN16(), (short)len);
        } else {
            cursor.writeByteAndInt(Code$.MODULE$.BIN32(), len);
        }
    }

    public void writePayload(WriteCursor cursor, byte[] v) {
        cursor.writeBytes(v);
    }

    public void writePayload(WriteCursor cursor, byte[] v, int vOffset, int length) {
        cursor.writeBytes(v, vOffset, length);
    }

    private OffsetPacker$() {
        MODULE$ = this;
        this.NANOS_PER_SECOND = 1000000000L;
    }
}

