/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorException;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.WebSocketServerCompressionHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.message.DefaultWebSocketHandshaker;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public class WebSocketServerHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketServerHandshakeHandler.class);
    private final ServerConnectorFuture serverConnectorFuture;
    private boolean webSocketCompressionEnabled;
    private SourceHandler sourceHandler;

    public WebSocketServerHandshakeHandler(ServerConnectorFuture serverConnectorFuture, boolean webSocketCompressionEnabled) {
        this.serverConnectorFuture = serverConnectorFuture;
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpMethod requestMethod = httpRequest.method();
            if (this.containsUpgradeHeaders(httpRequest)) {
                if (HttpMethod.GET == requestMethod) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Upgrading the connection from Http to WebSocket for channel : {}", (Object)ctx.channel());
                    }
                    ChannelHandlerContext decoderCtx = this.modifyPipelineForUpgrade(ctx);
                    decoderCtx.fireChannelRead(msg);
                } else {
                    DefaultHttpResponse badRequestResponse = new DefaultHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST);
                    ctx.writeAndFlush((Object)badRequestResponse).addListener(future -> ctx.close());
                }
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private boolean containsUpgradeHeaders(HttpRequest httpRequest) {
        HttpHeaders headers = httpRequest.headers();
        return headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && headers.containsValue((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    private ChannelHandlerContext modifyPipelineForUpgrade(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (pipeline.get("BackPressureHandler") != null) {
            pipeline.remove("BackPressureHandler");
        }
        this.sourceHandler = (SourceHandler)pipeline.remove("SourceHandler");
        ChannelHandlerContext decoderCtx = pipeline.context(HttpRequestDecoder.class);
        pipeline.addAfter(decoderCtx.name(), "HTTP_OBJECT_AGGREGATOR", (ChannelHandler)new HttpObjectAggregator(8192));
        if (this.webSocketCompressionEnabled) {
            pipeline.addAfter("HTTP_OBJECT_AGGREGATOR", "websocket-compression-handler", (ChannelHandler)new WebSocketServerCompressionHandler());
            pipeline.addAfter("websocket-compression-handler", Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
        } else {
            pipeline.addAfter("HTTP_OBJECT_AGGREGATOR", Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
        }
        pipeline.addAfter(Utf8FrameValidator.class.getName(), "handshake", (ChannelHandler)new HandShakeHandler());
        return decoderCtx;
    }

    private class HandShakeHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private HandShakeHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
            ctx.pipeline().remove((ChannelHandler)this);
            this.handleWebSocketHandshake(msg, ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireExceptionCaught(cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }

        private void handleWebSocketHandshake(FullHttpRequest fullHttpRequest, ChannelHandlerContext ctx) throws WebSocketConnectorException {
            DefaultWebSocketHandshaker webSocketHandshaker = new DefaultWebSocketHandshaker(ctx, WebSocketServerHandshakeHandler.this.serverConnectorFuture, fullHttpRequest);
            webSocketHandshaker.setHttpCarbonRequest((HttpCarbonRequest)Util.createInboundReqCarbonMsg((HttpRequest)fullHttpRequest, ctx, WebSocketServerHandshakeHandler.this.sourceHandler));
            ctx.channel().config().setAutoRead(false);
            WebSocketServerHandshakeHandler.this.serverConnectorFuture.notifyWebSocketListener(webSocketHandshaker);
        }
    }
}

