/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.mime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.mime.MimeMappingException;

public class MimeMapper {
    private static Properties mimeMap = null;
    private static final Logger log = LoggerFactory.getLogger(MimeMapper.class);

    private static void loadMimeMap() throws IOException {
        mimeMap = new Properties();
        InputStream inputStream = MimeMapper.class.getClassLoader().getResourceAsStream("mime-map.properties");
        if (inputStream != null) {
            mimeMap.load(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn("Could not close input stream", (Throwable)e);
            }
        }
    }

    public static String getMimeType(String extension) throws MimeMappingException {
        try {
            if (mimeMap == null) {
                MimeMapper.loadMimeMap();
            }
        }
        catch (IOException e) {
            throw new MimeMappingException("Could not load mime map", e);
        }
        String mimeType = mimeMap.getProperty(extension);
        if (mimeType == null) {
            throw new MimeMappingException("Could not find mime type");
        }
        return mimeType;
    }
}

