/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportProperty;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;

public class HttpConnectorUtil {
    public static SenderConfiguration getSenderConfiguration(TransportsConfiguration transportsConfiguration, String scheme) {
        Map<String, SenderConfiguration> senderConfigurations = transportsConfiguration.getSenderConfigurations().stream().collect(Collectors.toMap(senderConf -> senderConf.getScheme().toLowerCase(Locale.getDefault()), config -> config));
        return "https".equals(scheme) ? senderConfigurations.get("https") : senderConfigurations.get("http");
    }

    public static Map<String, Object> getTransportProperties(TransportsConfiguration transportsConfiguration) {
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        Set<TransportProperty> transportPropertiesSet = transportsConfiguration.getTransportProperties();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        return transportProperties;
    }

    public static ServerBootstrapConfiguration getServerBootstrapConfiguration(Set<TransportProperty> transportPropertiesSet) {
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        return new ServerBootstrapConfiguration(transportProperties);
    }

    private HttpConnectorUtil() {
    }
}

