/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contractimpl.listener.MaxEntityBodyValidator;
import org.wso2.transport.http.netty.contractimpl.listener.UriAndHeaderLengthValidator;
import org.wso2.transport.http.netty.contractimpl.listener.WebSocketMessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultServerHandshakeFuture;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketInboundFrameHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public class DefaultWebSocketHandshaker
implements WebSocketHandshaker {
    private final ChannelHandlerContext ctx;
    private final FullHttpRequest httpRequest;
    private final ServerConnectorFuture connectorFuture;
    private final String target;
    private final boolean secureConnection;
    private boolean cancelled = false;
    private boolean handshakeStarted = false;
    private HttpCarbonRequest request;

    public DefaultWebSocketHandshaker(ChannelHandlerContext ctx, ServerConnectorFuture connectorFuture, FullHttpRequest httpRequest) {
        this.ctx = ctx;
        this.connectorFuture = connectorFuture;
        this.secureConnection = ctx.channel().pipeline().get("ssl") != null;
        this.httpRequest = httpRequest;
        this.target = httpRequest.uri();
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public ServerHandshakeFuture handshake() {
        return this.handshake(null);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols) {
        return this.handshake(subProtocols, 0);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout) {
        return this.handshake(subProtocols, idleTimeout, null);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout, HttpHeaders responseHeaders) {
        return this.handshake(subProtocols, idleTimeout, responseHeaders, 65536);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout, HttpHeaders responseHeaders, int maxFramePayloadLength) {
        boolean allowExtensions = this.httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS) != null;
        String subProtocolsStr = subProtocols != null ? String.join((CharSequence)",", subProtocols) : null;
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(), subProtocolsStr, allowExtensions, maxFramePayloadLength);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, responseHeaders);
    }

    private String getWebSocketURL() {
        String scheme = "ws";
        if (this.secureConnection) {
            scheme = "wss";
        }
        return scheme + "://" + this.httpRequest.headers().get("Host") + this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture cancelHandshake(int statusCode, String closeReason) {
        this.handleIllegalStates();
        try {
            ChannelFuture responseFuture;
            int responseStatusCode;
            int n = responseStatusCode = statusCode >= 400 && statusCode < 600 ? statusCode : 400;
            if (closeReason != null) {
                ByteBuf content = Unpooled.wrappedBuffer((byte[])closeReason.getBytes(StandardCharsets.UTF_8));
                responseFuture = this.ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)responseStatusCode), content));
            } else {
                responseFuture = this.ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)responseStatusCode)));
            }
            responseFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> this.ctx.close()));
            ChannelFuture channelFuture = responseFuture;
            return channelFuture;
        }
        finally {
            this.cancelled = true;
        }
    }

    private void handleIllegalStates() {
        if (this.cancelled) {
            throw new IllegalStateException("Cannot cancel the handshake: handshake already cancelled");
        }
        if (this.handshakeStarted) {
            throw new IllegalStateException("Cannot cancel the handshake: handshake already started");
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isHandshakeStarted() {
        return this.handshakeStarted;
    }

    @Override
    public boolean isSecure() {
        return this.secureConnection;
    }

    @Override
    public boolean isServerMessage() {
        return true;
    }

    @Override
    public WebSocketConnection getWebSocketConnection() {
        throw new IllegalStateException("Cannot get WebSocket connection before handshake is completed");
    }

    @Override
    public String getChannelId() {
        return WebSocketUtil.getChannelId(this.ctx);
    }

    private ServerHandshakeFuture handleHandshake(WebSocketServerHandshaker handshaker, int idleTimeout, HttpHeaders headers) {
        DefaultServerHandshakeFuture handshakeFuture = new DefaultServerHandshakeFuture();
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)this.ctx.channel());
            handshakeFuture.notifyError(new UnsupportedOperationException("Unsupported WebSocket version"));
            return handshakeFuture;
        }
        if (this.cancelled) {
            IllegalAccessException e = new IllegalAccessException("Handshake is already cancelled.");
            handshakeFuture.notifyError(e);
            return handshakeFuture;
        }
        ChannelFuture channelFuture = handshaker.handshake(this.ctx.channel(), this.httpRequest, headers, this.ctx.channel().newPromise());
        channelFuture.addListener(future -> {
            if (future.isSuccess() && future.cause() == null) {
                WebSocketInboundFrameHandler frameHandler = new WebSocketInboundFrameHandler(true, this.secureConnection, this.target, handshaker.selectedSubprotocol(), this.connectorFuture, new WebSocketMessageQueueHandler());
                this.configureFrameHandlingPipeline(idleTimeout, frameHandler);
                handshakeFuture.notifySuccess(frameHandler.getWebSocketConnection());
            } else {
                handshakeFuture.notifyError(future.cause());
            }
        });
        this.handshakeStarted = true;
        return handshakeFuture;
    }

    private void configureFrameHandlingPipeline(int idleTimeout, WebSocketInboundFrameHandler frameHandler) {
        ChannelPipeline pipeline = this.ctx.pipeline();
        pipeline.remove("websocket-server-handshake-handler");
        pipeline.remove("chunkWriter");
        pipeline.remove("HttpExceptionHandler");
        if (pipeline.get(UriAndHeaderLengthValidator.class) != null) {
            pipeline.remove(UriAndHeaderLengthValidator.class);
        }
        if (pipeline.get(MaxEntityBodyValidator.class) != null) {
            pipeline.remove(MaxEntityBodyValidator.class);
        }
        if (idleTimeout > 0) {
            pipeline.replace("idleStateHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
        } else {
            pipeline.remove("idleStateHandler");
        }
        pipeline.addLast("WEBSOCKET_FRAME_HANDLER", (ChannelHandler)frameHandler);
        frameHandler.getWebSocketConnection().stopReadingFrames();
        pipeline.fireChannelActive();
    }

    @Override
    public HttpCarbonRequest getHttpCarbonRequest() {
        return this.request;
    }

    public void setHttpCarbonRequest(HttpCarbonRequest request) {
        this.request = request;
    }
}

