/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import java.net.InetSocketAddress;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ForwardedHeaderUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardedHeaderUpdater.class);
    private static final String FOR = "for=";
    private static final String BY = "by=";
    private static final String HOST = "host=";
    private static final String PROTO = "proto=";
    private static final String SEMI_COLON = ";";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private final String localAddress;
    private final String forwardedHeader;
    private final String xForwardedForHeader;
    private final String xForwardedByHeader;
    private final String xForwardedHostHeader;
    private final String xForwardedProtoHeader;
    private final HttpCarbonMessage httpOutboundRequest;

    public ForwardedHeaderUpdater(HttpCarbonMessage httpOutboundRequest, String localAddress) {
        this.httpOutboundRequest = httpOutboundRequest;
        this.localAddress = localAddress;
        this.forwardedHeader = httpOutboundRequest.getHeader("forwarded");
        this.xForwardedForHeader = httpOutboundRequest.getHeader("x-forwarded-for");
        this.xForwardedByHeader = httpOutboundRequest.getHeader("x-forwarded-by");
        this.xForwardedHostHeader = httpOutboundRequest.getHeader("x-forwarded-host");
        this.xForwardedProtoHeader = httpOutboundRequest.getHeader("x-forwarded-proto");
    }

    public boolean isForwardedHeaderRequired() {
        return this.xForwardedForHeader == null && this.xForwardedByHeader == null && this.xForwardedHostHeader == null && this.xForwardedProtoHeader == null;
    }

    public boolean isXForwardedHeaderRequired() {
        return this.forwardedHeader == null && (this.xForwardedForHeader != null || this.xForwardedByHeader != null || this.xForwardedHostHeader != null || this.xForwardedProtoHeader != null);
    }

    public void setForwardedHeader() {
        StringBuilder headerValue = new StringBuilder();
        if (this.forwardedHeader == null) {
            Object protocolHeader;
            Object remoteAddressProperty = this.httpOutboundRequest.getProperty("REMOTE_ADDRESS");
            if (remoteAddressProperty != null) {
                String remoteAddress = ((InetSocketAddress)remoteAddressProperty).getAddress().getHostAddress();
                headerValue.append(FOR).append(ForwardedHeaderUpdater.resolveIP(remoteAddress)).append(SEMI_COLON).append(" ");
            }
            headerValue.append(BY).append(ForwardedHeaderUpdater.resolveIP(this.localAddress));
            Object hostHeader = this.httpOutboundRequest.getProperty("ORIGIN_HOST");
            if (hostHeader != null) {
                headerValue.append("; host=").append(hostHeader.toString());
            }
            if ((protocolHeader = this.httpOutboundRequest.getProperty("PROTOCOL")) != null) {
                headerValue.append("; proto=").append(protocolHeader.toString());
            }
            this.httpOutboundRequest.setHeader("forwarded", headerValue.toString());
            return;
        }
        String[] parts = this.forwardedHeader.split(SEMI_COLON);
        String previousForValue = null;
        String previousByValue = null;
        String previousHostValue = null;
        String previousProtoValue = null;
        for (String part : parts) {
            if (part.toLowerCase(Locale.getDefault()).contains(FOR)) {
                previousForValue = part.trim();
                continue;
            }
            if (part.toLowerCase(Locale.getDefault()).contains(BY)) {
                previousByValue = part.trim().substring(3);
                continue;
            }
            if (part.toLowerCase(Locale.getDefault()).contains(HOST)) {
                previousHostValue = part.substring(5);
                continue;
            }
            if (!part.toLowerCase(Locale.getDefault()).contains(PROTO)) continue;
            previousProtoValue = part.substring(6);
        }
        previousForValue = previousForValue == null ? (previousByValue != null ? FOR + previousByValue : null) : (previousByValue == null ? previousForValue : previousForValue + COMMA + " " + FOR + previousByValue);
        headerValue.append(previousForValue != null ? previousForValue + SEMI_COLON + " " : null);
        headerValue.append(BY).append(ForwardedHeaderUpdater.resolveIP(this.localAddress));
        if (previousHostValue != null) {
            headerValue.append("; host=").append(previousHostValue);
        }
        if (previousProtoValue != null) {
            headerValue.append("; proto=").append(previousProtoValue);
        }
        this.httpOutboundRequest.setHeader("forwarded", headerValue.toString());
    }

    public void transformAndSetForwardedHeader() {
        if (this.xForwardedForHeader != null && this.xForwardedByHeader != null) {
            LOG.info("Header transition is not done as both X-Forwarded-For and X-Forwarded-By headers are present.");
            return;
        }
        StringBuilder headerValue = new StringBuilder();
        if (this.xForwardedForHeader != null) {
            String[] parts;
            for (String part : parts = this.xForwardedForHeader.split(COMMA)) {
                headerValue.append(FOR).append(ForwardedHeaderUpdater.resolveIP(part.trim())).append(COMMA).append(" ");
            }
            headerValue.replace(headerValue.length() - 2, headerValue.length(), "; ");
            this.httpOutboundRequest.removeHeader("x-forwarded-for");
        }
        if (this.xForwardedByHeader != null) {
            headerValue.append(FOR).append(ForwardedHeaderUpdater.resolveIP(this.xForwardedByHeader.trim())).append(SEMI_COLON).append(" ");
            this.httpOutboundRequest.removeHeader("x-forwarded-by");
        }
        headerValue.append(BY).append(ForwardedHeaderUpdater.resolveIP(this.localAddress));
        if (this.xForwardedHostHeader != null) {
            headerValue.append("; host=").append(this.xForwardedHostHeader);
            this.httpOutboundRequest.removeHeader("x-forwarded-host");
        }
        if (this.xForwardedProtoHeader != null) {
            headerValue.append("; proto=").append(this.xForwardedProtoHeader);
            this.httpOutboundRequest.removeHeader("x-forwarded-proto");
        }
        this.httpOutboundRequest.setHeader("forwarded", headerValue.toString());
    }

    public void setDefactoForwardedHeaders() {
        if (this.xForwardedForHeader != null && this.xForwardedByHeader != null) {
            this.httpOutboundRequest.setHeader("x-forwarded-for", this.xForwardedForHeader.trim() + COMMA + " " + this.xForwardedByHeader.trim());
        } else if (this.xForwardedByHeader != null) {
            this.httpOutboundRequest.setHeader("x-forwarded-for", this.xForwardedByHeader.trim());
        }
        this.httpOutboundRequest.setHeader("x-forwarded-by", this.localAddress);
    }

    private static String resolveIP(String ipString) {
        String[] parts = ipString.split(COLON);
        if (parts.length <= 2) {
            return ipString;
        }
        if (ipString.startsWith("[")) {
            return "\"" + ipString + "\"";
        }
        if (ipString.contains(COLON)) {
            return "\"[" + ipString + "]\"";
        }
        return ipString;
    }
}

