/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final Http2MessageStateContext http2MessageStateContext;

    ReceivingEntityBody(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        int streamId = dataFrame.getStreamId();
        ByteBuf data = dataFrame.getData();
        HttpCarbonMessage sourceReqCMsg = http2SourceHandler.getStreamIdRequestMap().get(streamId).getInboundMsg();
        if (sourceReqCMsg != null) {
            for (Http2DataEventListener listener : http2SourceHandler.getHttp2ServerChannel().getDataEventListeners()) {
                listener.onDataRead(http2SourceHandler.getChannelHandlerContext(), streamId, data, dataFrame.isEndOfStream());
            }
            if (dataFrame.isEndOfStream()) {
                sourceReqCMsg.addHttpContent((HttpContent)new DefaultLastHttpContent(data));
                sourceReqCMsg.setLastHttpContentArrived();
                this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
            } else {
                sourceReqCMsg.addHttpContent((HttpContent)new DefaultHttpContent(data));
            }
        } else {
            LOG.warn("Inconsistent state detected : data has been received before headers");
        }
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (this.http2MessageStateContext.isHeadersSent()) {
            this.http2MessageStateContext.setListenerState(new SendingEntityBody(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        } else {
            Http2StateUtil.beginResponseWrite(this.http2MessageStateContext, http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        }
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        Http2StateUtil.writeHttp2Promise(pushPromise, http2OutboundRespListener.getChannelHandlerContext(), http2OutboundRespListener.getConnection(), http2OutboundRespListener.getEncoder(), http2OutboundRespListener.getInboundRequestMsg(), http2OutboundRespListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture(), http2OutboundRespListener.getOriginalStreamId());
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, true, false);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        StateUtil.handleIncompleteInboundMessage(http2OutboundRespListener.getInboundRequestMsg(), "Remote client closed the connection while reading inbound request entity body");
    }
}

