/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;

public class SslHandshakeCompletionHandlerForServer
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SslHandshakeCompletionHandlerForServer.class);
    private HttpServerChannelInitializer httpServerChannelInitializer;
    private ChannelPipeline serverPipeline;
    private SSLEngine sslEngine;

    SslHandshakeCompletionHandlerForServer(HttpServerChannelInitializer httpServerChannelInitializer, ChannelPipeline serverPipeline, SSLEngine sslEngine) {
        this.httpServerChannelInitializer = httpServerChannelInitializer;
        this.serverPipeline = serverPipeline;
        this.sslEngine = sslEngine;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess()) {
                Util.setMutualSslStatus(ctx, this.sslEngine);
                this.httpServerChannelInitializer.configureHttpPipeline(this.serverPipeline, "http");
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelActive();
            } else {
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error while SSL handshake: " + cause.getMessage());
    }
}

