/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.beanutils.ConvertUtils;
import org.wso2.msf4j.util.Defaults;
import org.wso2.msf4j.util.Primitives;

public final class ParamConvertUtils {
    private static final Map<Class<?>, Method> PRIMITIVES_PARSE_METHODS;

    private ParamConvertUtils() {
    }

    public static Function<String, Object> createPathParamConverter(Type resultType) {
        if (!(resultType instanceof Class)) {
            throw new IllegalArgumentException("Unsupported @PathParam type " + resultType);
        }
        return value -> ConvertUtils.convert((String)value, (Class)((Class)resultType));
    }

    public static Function<List<String>, Object> createHeaderParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    public static Function<String, Object> createCookieParamConverter(Type resultType) {
        return value -> ConvertUtils.convert((String)value, (Class)((Class)resultType));
    }

    public static Function<List<String>, Object> createQueryParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    public static Function<List<String>, Object> createFormParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    public static Function<List<String>, Object> createFormDataParamConverter(Type resultType) {
        ParameterizedType type;
        Type elementType;
        if (resultType instanceof ParameterizedType && (elementType = (type = (ParameterizedType)resultType).getActualTypeArguments()[0]) == File.class && type.getRawType() != List.class) {
            throw new IllegalArgumentException("Unsupported type " + resultType);
        }
        Function<List<String>, Object> listConverter = null;
        try {
            listConverter = ParamConvertUtils.createListConverter(resultType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return listConverter;
    }

    private static Function<List<String>, Object> createListConverter(Type resultType) {
        TypeToken typeToken = TypeToken.get((Type)resultType);
        Class resultClass = typeToken.getRawType();
        if (resultClass == String.class) {
            return new BasicConverter(Defaults.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return value;
                }
            };
        }
        Function<List<String>, Object> converter = ParamConvertUtils.createPrimitiveTypeConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringConstructorConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringMethodConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createCollectionConverter(typeToken);
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("Unsupported type " + typeToken);
    }

    private static Function<List<String>, Object> createPrimitiveTypeConverter(Class<?> resultClass) {
        Object defaultValue = Defaults.defaultValue(resultClass);
        final Class<?> boxedType = Primitives.wrap(resultClass);
        if (!Primitives.isWrapperType(boxedType)) {
            return null;
        }
        return new BasicConverter(defaultValue){

            @Override
            protected Object convert(String value) throws Exception {
                Method method = (Method)PRIMITIVES_PARSE_METHODS.get(boxedType);
                if (method != null) {
                    return method.invoke(null, value);
                }
                if (boxedType == Character.class) {
                    return Character.valueOf(value.charAt(0));
                }
                return null;
            }
        };
    }

    private static Function<List<String>, Object> createStringConstructorConverter(Class<?> resultClass) {
        try {
            final Constructor<?> constructor = resultClass.getConstructor(String.class);
            return new BasicConverter(Defaults.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return constructor.newInstance(value);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Function<List<String>, Object> createStringMethodConverter(Class<?> resultClass) {
        Method method;
        try {
            method = resultClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = resultClass.getMethod("fromString", String.class);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        final Method convertMethod = method;
        return new BasicConverter(Defaults.defaultValue(resultClass)){

            @Override
            protected Object convert(String value) throws Exception {
                return convertMethod.invoke(null, value);
            }
        };
    }

    private static Function<List<String>, Object> createCollectionConverter(TypeToken<?> resultType) {
        final Class rawType = resultType.getRawType();
        if (rawType != List.class && rawType != Set.class && rawType != SortedSet.class) {
            return null;
        }
        if (!(resultType.getType() instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)resultType.getType();
        if (type.getActualTypeArguments().length != 1) {
            return null;
        }
        Type elementType = type.getActualTypeArguments()[0];
        if (rawType == SortedSet.class && !Comparable.class.isAssignableFrom(TypeToken.get((Type)elementType).getRawType())) {
            return null;
        }
        if (elementType == File.class && rawType != List.class) {
            throw new IllegalArgumentException("File doesn't support " + rawType);
        }
        final Function<List<String>, Object> elementConverter = ParamConvertUtils.createQueryParamConverter(elementType);
        return new Function<List<String>, Object>(){

            @Override
            public Object apply(List<String> values) {
                AbstractCollection collection = rawType == List.class ? new ArrayList() : (rawType == Set.class ? new HashSet() : new TreeSet());
                if (values != null) {
                    for (String value : values) {
                        this.add(collection, elementConverter.apply(Collections.singletonList(value)));
                    }
                }
                return collection;
            }

            private <T> void add(Collection<T> collection, Object element) {
                collection.add(element);
            }
        };
    }

    static {
        HashMap methods = new HashMap();
        for (Class<?> wrappedType : Primitives.allWrapperTypes()) {
            try {
                methods.put(wrappedType, wrappedType.getMethod("valueOf", String.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        PRIMITIVES_PARSE_METHODS = methods;
    }

    private static abstract class BasicConverter
    implements Function<List<String>, Object> {
        private final Object defaultValue;

        protected BasicConverter(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Object apply(List<String> values) {
            if (values == null || values.isEmpty()) {
                return this.getDefaultValue();
            }
            try {
                return this.convert(values.get(0));
            }
            catch (Exception e) {
                Objects.requireNonNull(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        protected Object getDefaultValue() {
            return this.defaultValue;
        }

        protected abstract Object convert(String var1) throws Exception;
    }
}

