/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.formparam;

import java.io.IOException;
import java.io.InputStream;
import org.wso2.msf4j.formparam.MultipartStream;
import org.wso2.msf4j.formparam.exception.FormUploadException;
import org.wso2.msf4j.formparam.util.Closeable;
import org.wso2.msf4j.formparam.util.FormItemHeader;
import org.wso2.msf4j.formparam.util.StreamUtil;

public class FormItem {
    private final String contentType;
    private final String fieldName;
    private final String name;
    private final boolean formField;
    private final InputStream stream;
    private FormItemHeader headers;

    FormItem(String pName, String pFieldName, String pContentType, boolean pFormField, long pContentLength, MultipartStream multi) {
        this.name = pName;
        this.fieldName = pFieldName;
        this.contentType = pContentType;
        this.formField = pFormField;
        this.stream = multi.newInputStream();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getName() {
        return StreamUtil.checkFileName(this.name);
    }

    public boolean isFormField() {
        return this.formField;
    }

    public InputStream openStream() throws IOException {
        if (((Closeable)((Object)this.stream)).isClosed()) {
            throw new ItemSkippedException();
        }
        return this.stream;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new FormUploadException("Error while closing the stream", e);
        }
    }

    public FormItemHeader getHeaders() {
        return this.headers;
    }

    void setHeaders(FormItemHeader pHeaders) {
        this.headers = pHeaders;
    }

    static class ItemSkippedException
    extends RuntimeException {
        private static final long serialVersionUID = -7280778431581963740L;

        ItemSkippedException() {
        }
    }
}

