/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;

public class ServerRemoteFlowControlListener
implements Http2RemoteFlowController.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRemoteFlowControlListener.class);
    private Http2RemoteFlowController http2RemoteFlowController;
    private ConcurrentHashMap<Integer, Http2OutboundRespListener.ResponseWriter> responseWriters = new ConcurrentHashMap();

    public ServerRemoteFlowControlListener(Http2RemoteFlowController http2RemoteFlowController) {
        this.http2RemoteFlowController = http2RemoteFlowController;
    }

    public void writabilityChanged(Http2Stream stream) {
        Http2OutboundRespListener.ResponseWriter responseWriter = this.responseWriters.get(stream.id());
        if (responseWriter == null) {
            return;
        }
        if (this.http2RemoteFlowController.isWritable(stream)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream {} is writable. State {} ", new Object[]{Thread.currentThread().getName(), stream.id(), stream.state()});
            }
            responseWriter.setStreamWritable(true);
            responseWriter.getBackPressureObservable().notifyWritable();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream {} is not writable. State {}. ", new Object[]{Thread.currentThread().getName(), stream.id(), stream.state()});
            }
            responseWriter.setStreamWritable(false);
        }
    }

    public void addResponseWriter(Http2OutboundRespListener.ResponseWriter responseWriter) {
        this.responseWriters.put(responseWriter.getStreamId(), responseWriter);
    }

    public void removeResponseWriter(Http2OutboundRespListener.ResponseWriter responseWriter) {
        if (responseWriter != null) {
            this.responseWriters.remove(responseWriter.getStreamId(), responseWriter);
        }
    }
}

