/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.message.Http2Frame;

public class Http2PushPromise
extends Http2Frame {
    private int promisedStreamId;
    private boolean rejected = false;
    private HttpRequest httpRequest;
    private OutboundMsgHolder outboundMsgHolder;

    public Http2PushPromise(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public Http2PushPromise(String method, String uri) {
        this.httpRequest = new DefaultHttpRequest(new HttpVersion("HTTP/2.0", true), HttpMethod.valueOf((String)method), uri);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getMethod() {
        return this.httpRequest.method().name();
    }

    public String getPath() {
        return this.httpRequest.uri();
    }

    public void addHeader(String name, String value) {
        this.httpRequest.headers().add(name, (Object)value);
    }

    public void removeHeader(String name) {
        this.httpRequest.headers().remove(name);
    }

    public String getHeader(String name) {
        return this.httpRequest.headers().get(name);
    }

    public String[] getHeaders(String name) {
        List headerList = this.httpRequest.headers().getAll(name);
        return headerList.toArray(new String[0]);
    }

    public void setHeader(String name, String value) {
        this.httpRequest.headers().set(name, (Object)value);
    }

    public void removeAllHeaders() {
        this.httpRequest.headers().clear();
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }

    public void setPromisedStreamId(int promisedStreamId) {
        this.promisedStreamId = promisedStreamId;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void reject() {
        this.rejected = true;
    }

    public OutboundMsgHolder getOutboundMsgHolder() {
        return this.outboundMsgHolder;
    }

    public void setOutboundMsgHolder(OutboundMsgHolder outboundMsgHolder) {
        this.outboundMsgHolder = outboundMsgHolder;
    }
}

