/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.Sending100Continue;
import org.wso2.transport.http.netty.contractimpl.sender.states.SendingEntityBody;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final String httpVersion;
    private final ChunkConfig chunkConfig;
    private final TargetChannel targetChannel;
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final HttpResponseFuture httpInboundResponseFuture;
    private long contentLength = 0L;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();

    public SendingHeaders(SenderReqRespStateManager senderReqRespStateManager, TargetChannel targetChannel, String httpVersion, ChunkConfig chunkConfig, HttpResponseFuture httpInboundResponseFuture) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.targetChannel = targetChannel;
        this.httpVersion = httpVersion;
        this.chunkConfig = chunkConfig;
        this.httpInboundResponseFuture = httpInboundResponseFuture;
        this.configIdleTimeoutTrigger(senderReqRespStateManager.socketTimeout);
    }

    private void configIdleTimeoutTrigger(int socketIdleTimeout) {
        ChannelPipeline pipeline = this.senderReqRespStateManager.nettyTargetChannel.pipeline();
        IdleStateHandler idleStateHandler = new IdleStateHandler(0L, 0L, (long)socketIdleTimeout, TimeUnit.MILLISECONDS);
        if (pipeline.get("targetHandler") == null) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        } else {
            pipeline.addBefore("targetHandler", "idleStateHandler", (ChannelHandler)idleStateHandler);
        }
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        if (Util.isLastHttpContent(httpContent)) {
            if (Util.checkContentLengthAndTransferEncodingHeaderAllowance(httpOutboundRequest)) {
                if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(this.httpVersion, this.chunkConfig)) {
                    Util.setupChunkedRequest(httpOutboundRequest);
                } else {
                    this.contentLength += (long)httpContent.content().readableBytes();
                    Util.setupContentLengthRequest(httpOutboundRequest, this.contentLength);
                }
            }
            this.writeRequestHeaders(httpOutboundRequest, this.httpInboundResponseFuture, this.httpVersion, this.targetChannel);
            this.writeRequestBody(httpOutboundRequest, httpContent);
        } else {
            if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && StateUtil.checkChunkingCompatibility(this.httpVersion, this.chunkConfig)) {
                Util.setupChunkedRequest(httpOutboundRequest);
                this.writeRequestHeaders(httpOutboundRequest, this.httpInboundResponseFuture, this.httpVersion, this.targetChannel);
                this.writeRequestBody(httpOutboundRequest, httpContent);
                return;
            }
            this.waitForCompleteBody(httpContent);
        }
    }

    private void writeRequestHeaders(HttpCarbonMessage httpOutboundRequest, HttpResponseFuture httpInboundResponseFuture, String httpVersion, TargetChannel targetChannel) {
        this.setHttpVersionProperty(httpOutboundRequest, httpVersion);
        HttpRequest httpRequest = Util.createHttpRequest(httpOutboundRequest);
        targetChannel.setRequestHeaderWritten(true);
        ChannelFuture outboundHeaderFuture = this.senderReqRespStateManager.nettyTargetChannel.write((Object)httpRequest);
        StateUtil.notifyIfHeaderWriteFailure(httpInboundResponseFuture, outboundHeaderFuture, "Connection between client and remote host is closed");
    }

    private void setHttpVersionProperty(HttpCarbonMessage httpOutboundRequest, String httpVersion) {
        if ("2.0".equals(httpVersion)) {
            httpOutboundRequest.setHttpVersion(String.valueOf(1.1f));
        } else {
            httpOutboundRequest.setHttpVersion(httpVersion);
        }
    }

    private void writeRequestBody(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        String expectHeader = httpOutboundRequest.getHeader(HttpHeaderNames.EXPECT.toString());
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            this.senderReqRespStateManager.state = new Sending100Continue(this.senderReqRespStateManager, this.httpInboundResponseFuture);
            this.senderReqRespStateManager.nettyTargetChannel.flush();
        } else {
            this.senderReqRespStateManager.state = new SendingEntityBody(this.senderReqRespStateManager, this.httpInboundResponseFuture);
        }
        for (HttpContent cachedHttpContent : this.contentList) {
            this.senderReqRespStateManager.writeOutboundRequestEntity(httpOutboundRequest, cachedHttpContent);
        }
        this.senderReqRespStateManager.writeOutboundRequestEntity(httpOutboundRequest, httpContent);
    }

    private void waitForCompleteBody(HttpContent httpContent) {
        this.contentList.add(httpContent);
        this.contentLength += (long)httpContent.content().readableBytes();
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        targetHandler.getOutboundRequestMsg().setIoException(new IOException("Inbound response message already received"));
        this.senderReqRespStateManager.state = new ReceivingHeaders(this.senderReqRespStateManager);
        this.senderReqRespStateManager.readInboundResponseHeaders(targetHandler, httpInboundResponse);
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) {
        LOG.warn("readInboundResponseEntityBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        LOG.error("Remote host closed the connection while writing outbound request headers");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        LOG.error("Error in HTTP client: {}", (Object)"Idle timeout triggered while writing outbound request headers");
    }
}

