/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingHeaders;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Response100ContinueSent
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(Response100ContinueSent.class);
    private final Http2MessageStateContext http2MessageStateContext;

    public Response100ContinueSent(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) throws Http2Exception {
        this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
        this.http2MessageStateContext.getListenerState().readInboundRequestBody(http2SourceHandler, dataFrame);
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        ChannelHandlerContext ctx = http2OutboundRespListener.getChannelHandlerContext();
        ChannelFuture channelFuture = http2OutboundRespListener.getEncoder().writeHeaders(ctx, streamId, new DefaultHttp2Headers(false).status((CharSequence)HttpResponseStatus.CONTINUE.codeAsText()), 0, false, ctx.voidPromise());
        http2OutboundRespListener.getEncoder().flowController().writePendingBytes();
        ctx.flush();
        this.http2MessageStateContext.setListenerState(new SendingHeaders(http2OutboundRespListener, this.http2MessageStateContext));
        Response100ContinueSent.addResponseWriteFailureListener(http2OutboundRespListener.getOutboundRespStatusFuture(), channelFuture, http2OutboundRespListener);
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        LOG.warn("writeOutboundPromise {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, true, true);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        LOG.error("Remote client closed the connection while writing 100 continue response");
    }

    private static void addResponseWriteFailureListener(HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture, Http2OutboundRespListener http2OutboundRespListener) {
        channelFuture.addListener(writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote client closed the connection while writing 100 continue response");
                }
                http2OutboundRespListener.removeDefaultResponseWriter();
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(http2OutboundRespListener.getInboundRequestMsg());
            }
        });
    }
}

