/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.ssl;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;

public class SSLHandlerFactory {
    private SSLContext sslContext = null;
    private SSLConfig sslConfig;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;
    private SslContextBuilder sslContextBuilder;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.wantClientAuth = sslConfig.isWantClientAuth();
    }

    public SSLContext createSSLContextFromKeystores(boolean isServer) {
        String protocol = this.sslConfig.getSSLProtocol();
        try {
            if (this.sslConfig.useJavaDefaults() && !isServer) {
                return SSLContext.getDefault();
            }
            KeyManager[] keyManagers = null;
            if (this.sslConfig.getKeyStore() != null) {
                KeyStore ks = this.getKeyStore(this.sslConfig.getKeyStore(), this.sslConfig.getKeyStorePass());
                this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (ks != null) {
                    this.kmf.init(ks, this.sslConfig.getCertPass() != null ? this.sslConfig.getCertPass().toCharArray() : this.sslConfig.getKeyStorePass().toCharArray());
                    keyManagers = this.kmf.getKeyManagers();
                }
            }
            TrustManager[] trustManagers = null;
            if (this.sslConfig.getTrustStore() != null) {
                KeyStore tks = this.getKeyStore(this.sslConfig.getTrustStore(), this.sslConfig.getTrustStorePass());
                this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.tmf.init(tks);
                trustManagers = this.tmf.getTrustManagers();
            }
            this.sslContext = SSLContext.getInstance(protocol);
            this.sslContext.init(keyManagers, trustManagers, null);
            int sessionTimeout = this.sslConfig.getSessionTimeOut();
            if (isServer) {
                if (sessionTimeout > 0) {
                    this.sslContext.getServerSessionContext().setSessionTimeout(sessionTimeout);
                }
            } else if (sessionTimeout > 0) {
                this.sslContext.getClientSessionContext().setSessionTimeout(sessionTimeout);
            }
            return this.sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Failed to initialize the SSLContext: " + e.getMessage());
        }
    }

    private KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        String tlsStoreType = this.sslConfig.getTLSStoreType();
        if (keyStore != null && keyStorePassword != null) {
            try (FileInputStream is = new FileInputStream(keyStore);){
                ks = KeyStore.getInstance(tlsStoreType);
                ks.load(is, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }

    public SSLEngine buildServerSSLEngine(SSLContext sslContext) {
        SSLEngine engine = sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        if (this.needClientAuth) {
            engine.setNeedClientAuth(true);
        } else if (this.wantClientAuth) {
            engine.setWantClientAuth(true);
        }
        return this.addCommonConfigs(engine);
    }

    public ReferenceCountedOpenSslContext getServerReferenceCountedOpenSslContext(boolean enableOcsp) throws SSLException {
        this.sslContextBuilder = this.sslConfig.getKeyStore() != null ? this.serverContextBuilderWithKs(SslProvider.OPENSSL) : this.serverContextBuilderWithCerts(SslProvider.OPENSSL);
        this.setOcspStapling(this.sslContextBuilder, enableOcsp);
        if (this.sslConfig.getCipherSuites() != null) {
            List<String> ciphers = Arrays.asList(this.sslConfig.getCipherSuites());
            this.setCiphers(this.sslContextBuilder, ciphers);
        }
        this.setSslProtocol(this.sslContextBuilder);
        ReferenceCountedOpenSslContext referenceCountedOpenSslCtx = (ReferenceCountedOpenSslContext)this.sslContextBuilder.build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            referenceCountedOpenSslCtx.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return referenceCountedOpenSslCtx;
    }

    public ReferenceCountedOpenSslContext buildClientReferenceCountedOpenSslContext() throws SSLException {
        this.sslContextBuilder = this.sslConfig.getTrustStore() != null ? this.clientContextBuilderWithKs(SslProvider.OPENSSL) : this.clientContextBuilderWithCerts(SslProvider.OPENSSL);
        this.setOcspStapling(this.sslContextBuilder, true);
        if (this.sslConfig.getCipherSuites() != null) {
            List<String> ciphers = Arrays.asList(this.sslConfig.getCipherSuites());
            this.setCiphers(this.sslContextBuilder, ciphers);
        }
        this.setSslProtocol(this.sslContextBuilder);
        ReferenceCountedOpenSslContext referenceCountedOpenSslCtx = (ReferenceCountedOpenSslContext)this.sslContextBuilder.build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            referenceCountedOpenSslCtx.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return referenceCountedOpenSslCtx;
    }

    public SSLEngine buildClientSSLEngine(String host, int port) {
        SSLEngine engine = this.sslContext.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        return this.addCommonConfigs(engine);
    }

    public SSLEngine addCommonConfigs(SSLEngine engine) {
        if (this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0) {
            engine.setEnabledCipherSuites(this.sslConfig.getCipherSuites());
        }
        if (this.sslConfig.getEnableProtocols() != null && this.sslConfig.getEnableProtocols().length > 0) {
            engine.setEnabledProtocols(this.sslConfig.getEnableProtocols());
        }
        engine.setEnableSessionCreation(this.sslConfig.isEnableSessionCreation());
        return engine;
    }

    public SslContext createHttp2TLSContextForServer(SSLConfig sslConfig) throws SSLException {
        this.createSSLContextFromKeystores(true);
        List<String> ciphers = sslConfig.getCipherSuites() != null && sslConfig.getCipherSuites().length > 0 ? Arrays.asList(sslConfig.getCipherSuites()) : Http2SecurityUtil.CIPHERS;
        SslProvider provider = SslProvider.OPENSSL;
        this.sslContextBuilder = sslConfig.getKeyStore() != null ? this.serverContextBuilderWithKs(provider) : this.serverContextBuilderWithCerts(provider);
        this.setCiphers(this.sslContextBuilder, ciphers);
        this.setSslProtocol(this.sslContextBuilder);
        this.setAlpnConfigs(this.sslContextBuilder);
        this.setOcspStapling(this.sslContextBuilder, sslConfig.isOcspStaplingEnabled());
        SslContext sslCtx = this.sslContextBuilder.build();
        int sessionTimeout = sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            sslCtx.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return sslCtx;
    }

    public SslContext createHttpTLSContextForServer() throws SSLException {
        SslProvider provider = SslProvider.JDK;
        SslContext certsSslContext = this.serverContextBuilderWithCerts(provider).build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            certsSslContext.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return certsSslContext;
    }

    public SslContext createHttpTLSContextForClient() throws SSLException {
        SslProvider provider = SslProvider.JDK;
        SslContext certsSslContext = this.clientContextBuilderWithCerts(provider).build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            certsSslContext.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return certsSslContext;
    }

    private SslContextBuilder serverContextBuilderWithKs(SslProvider sslProvider) {
        SslContextBuilder serverSslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory()).trustManager(this.getTrustStoreFactory()).sslProvider(sslProvider);
        this.setClientAuth(serverSslContextBuilder);
        return serverSslContextBuilder;
    }

    private SslContextBuilder clientContextBuilderWithKs(SslProvider sslProvider) {
        return SslContextBuilder.forClient().sslProvider(sslProvider).keyManager(this.kmf).trustManager(this.tmf);
    }

    private SslContextBuilder serverContextBuilderWithCerts(SslProvider sslProvider) {
        String keyPassword = this.sslConfig.getServerKeyPassword();
        SslContextBuilder serverSslContextBuilder = SslContextBuilder.forServer((File)this.sslConfig.getServerCertificates(), (File)this.sslConfig.getServerKeyFile()).keyManager(this.sslConfig.getServerCertificates(), this.sslConfig.getServerKeyFile(), keyPassword).trustManager(this.sslConfig.getServerTrustCertificates()).sslProvider(sslProvider);
        this.setClientAuth(serverSslContextBuilder);
        return serverSslContextBuilder;
    }

    private SslContextBuilder clientContextBuilderWithCerts(SslProvider sslProvider) {
        String keyPassword = this.sslConfig.getClientKeyPassword();
        return SslContextBuilder.forClient().sslProvider(sslProvider).keyManager(this.sslConfig.getClientCertificates(), this.sslConfig.getClientKeyFile(), keyPassword).trustManager(this.sslConfig.getClientTrustCertificates());
    }

    public SslContext createHttp2TLSContextForClient(boolean enableOcsp) throws SSLException {
        SslProvider provider = SslProvider.OPENSSL;
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : Http2SecurityUtil.CIPHERS;
        this.sslContextBuilder = this.sslConfig.getTrustStore() != null ? this.clientContextBuilderWithKs(provider) : this.clientContextBuilderWithCerts(provider);
        this.setCiphers(this.sslContextBuilder, ciphers);
        this.setSslProtocol(this.sslContextBuilder);
        this.setAlpnConfigs(this.sslContextBuilder);
        this.setOcspStapling(this.sslContextBuilder, enableOcsp);
        SslContext sslContext = this.sslContextBuilder.build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            sslContext.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return this.sslContextBuilder.build();
    }

    private void setCiphers(SslContextBuilder sslContextBuilder, List<String> ciphers) {
        sslContextBuilder.ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
    }

    private void setSslProtocol(SslContextBuilder sslContextBuilder) {
        sslContextBuilder.protocols(this.sslConfig.getEnableProtocols());
    }

    private void setAlpnConfigs(SslContextBuilder sslContextBuilder) {
        sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
    }

    private void setOcspStapling(SslContextBuilder sslContextBuilder, boolean enableOcsp) {
        sslContextBuilder.enableOcsp(enableOcsp);
    }

    private KeyManagerFactory getKeyManagerFactory() {
        return this.kmf;
    }

    private TrustManagerFactory getTrustStoreFactory() {
        return this.tmf;
    }

    private void setClientAuth(SslContextBuilder serverSslContextBuilder) {
        if (this.needClientAuth) {
            serverSslContextBuilder.clientAuth(ClientAuth.REQUIRE);
        } else if (this.wantClientAuth) {
            serverSslContextBuilder.clientAuth(ClientAuth.OPTIONAL);
        } else {
            serverSslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public void setSNIServerNames(SSLEngine sslEngine, String peerHost) {
        SSLParameters sslParameters = new SSLParameters();
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
        serverNames.add(new SNIHostName(peerHost));
        sslParameters.setServerNames(serverNames);
        sslEngine.setSSLParameters(sslParameters);
    }

    public void setHostNameVerfication(SSLEngine sslEngine) {
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("https");
        sslEngine.setSSLParameters(sslParams);
    }
}

